/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ImportTablesCompletedCopier;
import software.amazon.awssdk.services.redshift.model.ImportTablesInProgressCopier;
import software.amazon.awssdk.services.redshift.model.ImportTablesNotStartedCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CancelResizeResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, CancelResizeResponse> {
    private static final SdkField<String> TARGET_NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetNodeType").getter(CancelResizeResponse.getter(CancelResizeResponse::targetNodeType)).setter(CancelResizeResponse.setter(Builder::targetNodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNodeType").build()}).build();
    private static final SdkField<Integer> TARGET_NUMBER_OF_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetNumberOfNodes").getter(CancelResizeResponse.getter(CancelResizeResponse::targetNumberOfNodes)).setter(CancelResizeResponse.setter(Builder::targetNumberOfNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetNumberOfNodes").build()}).build();
    private static final SdkField<String> TARGET_CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetClusterType").getter(CancelResizeResponse.getter(CancelResizeResponse::targetClusterType)).setter(CancelResizeResponse.setter(Builder::targetClusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetClusterType").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(CancelResizeResponse.getter(CancelResizeResponse::status)).setter(CancelResizeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<List<String>> IMPORT_TABLES_COMPLETED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImportTablesCompleted").getter(CancelResizeResponse.getter(CancelResizeResponse::importTablesCompleted)).setter(CancelResizeResponse.setter(Builder::importTablesCompleted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTablesCompleted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMPORT_TABLES_IN_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImportTablesInProgress").getter(CancelResizeResponse.getter(CancelResizeResponse::importTablesInProgress)).setter(CancelResizeResponse.setter(Builder::importTablesInProgress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTablesInProgress").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IMPORT_TABLES_NOT_STARTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImportTablesNotStarted").getter(CancelResizeResponse.getter(CancelResizeResponse::importTablesNotStarted)).setter(CancelResizeResponse.setter(Builder::importTablesNotStarted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImportTablesNotStarted").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> AVG_RESIZE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("AvgResizeRateInMegaBytesPerSecond").getter(CancelResizeResponse.getter(CancelResizeResponse::avgResizeRateInMegaBytesPerSecond)).setter(CancelResizeResponse.setter(Builder::avgResizeRateInMegaBytesPerSecond)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvgResizeRateInMegaBytesPerSecond").build()}).build();
    private static final SdkField<Long> TOTAL_RESIZE_DATA_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalResizeDataInMegaBytes").getter(CancelResizeResponse.getter(CancelResizeResponse::totalResizeDataInMegaBytes)).setter(CancelResizeResponse.setter(Builder::totalResizeDataInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalResizeDataInMegaBytes").build()}).build();
    private static final SdkField<Long> PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ProgressInMegaBytes").getter(CancelResizeResponse.getter(CancelResizeResponse::progressInMegaBytes)).setter(CancelResizeResponse.setter(Builder::progressInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressInMegaBytes").build()}).build();
    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("ElapsedTimeInSeconds").getter(CancelResizeResponse.getter(CancelResizeResponse::elapsedTimeInSeconds)).setter(CancelResizeResponse.setter(Builder::elapsedTimeInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build()}).build();
    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("EstimatedTimeToCompletionInSeconds").getter(CancelResizeResponse.getter(CancelResizeResponse::estimatedTimeToCompletionInSeconds)).setter(CancelResizeResponse.setter(Builder::estimatedTimeToCompletionInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompletionInSeconds").build()}).build();
    private static final SdkField<String> RESIZE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResizeType").getter(CancelResizeResponse.getter(CancelResizeResponse::resizeType)).setter(CancelResizeResponse.setter(Builder::resizeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeType").build()}).build();
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Message").getter(CancelResizeResponse.getter(CancelResizeResponse::message)).setter(CancelResizeResponse.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()}).build();
    private static final SdkField<String> TARGET_ENCRYPTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetEncryptionType").getter(CancelResizeResponse.getter(CancelResizeResponse::targetEncryptionType)).setter(CancelResizeResponse.setter(Builder::targetEncryptionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetEncryptionType").build()}).build();
    private static final SdkField<Double> DATA_TRANSFER_PROGRESS_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("DataTransferProgressPercent").getter(CancelResizeResponse.getter(CancelResizeResponse::dataTransferProgressPercent)).setter(CancelResizeResponse.setter(Builder::dataTransferProgressPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferProgressPercent").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_NODE_TYPE_FIELD, TARGET_NUMBER_OF_NODES_FIELD, TARGET_CLUSTER_TYPE_FIELD, STATUS_FIELD, IMPORT_TABLES_COMPLETED_FIELD, IMPORT_TABLES_IN_PROGRESS_FIELD, IMPORT_TABLES_NOT_STARTED_FIELD, AVG_RESIZE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, TOTAL_RESIZE_DATA_IN_MEGA_BYTES_FIELD, PROGRESS_IN_MEGA_BYTES_FIELD, ELAPSED_TIME_IN_SECONDS_FIELD, ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD, RESIZE_TYPE_FIELD, MESSAGE_FIELD, TARGET_ENCRYPTION_TYPE_FIELD, DATA_TRANSFER_PROGRESS_PERCENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CancelResizeResponse.memberNameToFieldInitializer();
    private final String targetNodeType;
    private final Integer targetNumberOfNodes;
    private final String targetClusterType;
    private final String status;
    private final List<String> importTablesCompleted;
    private final List<String> importTablesInProgress;
    private final List<String> importTablesNotStarted;
    private final Double avgResizeRateInMegaBytesPerSecond;
    private final Long totalResizeDataInMegaBytes;
    private final Long progressInMegaBytes;
    private final Long elapsedTimeInSeconds;
    private final Long estimatedTimeToCompletionInSeconds;
    private final String resizeType;
    private final String message;
    private final String targetEncryptionType;
    private final Double dataTransferProgressPercent;

    private CancelResizeResponse(BuilderImpl builder) {
        super(builder);
        this.targetNodeType = builder.targetNodeType;
        this.targetNumberOfNodes = builder.targetNumberOfNodes;
        this.targetClusterType = builder.targetClusterType;
        this.status = builder.status;
        this.importTablesCompleted = builder.importTablesCompleted;
        this.importTablesInProgress = builder.importTablesInProgress;
        this.importTablesNotStarted = builder.importTablesNotStarted;
        this.avgResizeRateInMegaBytesPerSecond = builder.avgResizeRateInMegaBytesPerSecond;
        this.totalResizeDataInMegaBytes = builder.totalResizeDataInMegaBytes;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
        this.resizeType = builder.resizeType;
        this.message = builder.message;
        this.targetEncryptionType = builder.targetEncryptionType;
        this.dataTransferProgressPercent = builder.dataTransferProgressPercent;
    }

    public final String targetNodeType() {
        return this.targetNodeType;
    }

    public final Integer targetNumberOfNodes() {
        return this.targetNumberOfNodes;
    }

    public final String targetClusterType() {
        return this.targetClusterType;
    }

    public final String status() {
        return this.status;
    }

    public final boolean hasImportTablesCompleted() {
        return this.importTablesCompleted != null && !(this.importTablesCompleted instanceof SdkAutoConstructList);
    }

    public final List<String> importTablesCompleted() {
        return this.importTablesCompleted;
    }

    public final boolean hasImportTablesInProgress() {
        return this.importTablesInProgress != null && !(this.importTablesInProgress instanceof SdkAutoConstructList);
    }

    public final List<String> importTablesInProgress() {
        return this.importTablesInProgress;
    }

    public final boolean hasImportTablesNotStarted() {
        return this.importTablesNotStarted != null && !(this.importTablesNotStarted instanceof SdkAutoConstructList);
    }

    public final List<String> importTablesNotStarted() {
        return this.importTablesNotStarted;
    }

    public final Double avgResizeRateInMegaBytesPerSecond() {
        return this.avgResizeRateInMegaBytesPerSecond;
    }

    public final Long totalResizeDataInMegaBytes() {
        return this.totalResizeDataInMegaBytes;
    }

    public final Long progressInMegaBytes() {
        return this.progressInMegaBytes;
    }

    public final Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public final Long estimatedTimeToCompletionInSeconds() {
        return this.estimatedTimeToCompletionInSeconds;
    }

    public final String resizeType() {
        return this.resizeType;
    }

    public final String message() {
        return this.message;
    }

    public final String targetEncryptionType() {
        return this.targetEncryptionType;
    }

    public final Double dataTransferProgressPercent() {
        return this.dataTransferProgressPercent;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.targetNodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetNumberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetClusterType());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportTablesCompleted() ? this.importTablesCompleted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportTablesInProgress() ? this.importTablesInProgress() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImportTablesNotStarted() ? this.importTablesNotStarted() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.avgResizeRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalResizeDataInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.estimatedTimeToCompletionInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.resizeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetEncryptionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferProgressPercent());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CancelResizeResponse)) {
            return false;
        }
        CancelResizeResponse other = (CancelResizeResponse)((Object)obj);
        return Objects.equals(this.targetNodeType(), other.targetNodeType()) && Objects.equals(this.targetNumberOfNodes(), other.targetNumberOfNodes()) && Objects.equals(this.targetClusterType(), other.targetClusterType()) && Objects.equals(this.status(), other.status()) && this.hasImportTablesCompleted() == other.hasImportTablesCompleted() && Objects.equals(this.importTablesCompleted(), other.importTablesCompleted()) && this.hasImportTablesInProgress() == other.hasImportTablesInProgress() && Objects.equals(this.importTablesInProgress(), other.importTablesInProgress()) && this.hasImportTablesNotStarted() == other.hasImportTablesNotStarted() && Objects.equals(this.importTablesNotStarted(), other.importTablesNotStarted()) && Objects.equals(this.avgResizeRateInMegaBytesPerSecond(), other.avgResizeRateInMegaBytesPerSecond()) && Objects.equals(this.totalResizeDataInMegaBytes(), other.totalResizeDataInMegaBytes()) && Objects.equals(this.progressInMegaBytes(), other.progressInMegaBytes()) && Objects.equals(this.elapsedTimeInSeconds(), other.elapsedTimeInSeconds()) && Objects.equals(this.estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds()) && Objects.equals(this.resizeType(), other.resizeType()) && Objects.equals(this.message(), other.message()) && Objects.equals(this.targetEncryptionType(), other.targetEncryptionType()) && Objects.equals(this.dataTransferProgressPercent(), other.dataTransferProgressPercent());
    }

    public final String toString() {
        return ToString.builder((String)"CancelResizeResponse").add("TargetNodeType", (Object)this.targetNodeType()).add("TargetNumberOfNodes", (Object)this.targetNumberOfNodes()).add("TargetClusterType", (Object)this.targetClusterType()).add("Status", (Object)this.status()).add("ImportTablesCompleted", this.hasImportTablesCompleted() ? this.importTablesCompleted() : null).add("ImportTablesInProgress", this.hasImportTablesInProgress() ? this.importTablesInProgress() : null).add("ImportTablesNotStarted", this.hasImportTablesNotStarted() ? this.importTablesNotStarted() : null).add("AvgResizeRateInMegaBytesPerSecond", (Object)this.avgResizeRateInMegaBytesPerSecond()).add("TotalResizeDataInMegaBytes", (Object)this.totalResizeDataInMegaBytes()).add("ProgressInMegaBytes", (Object)this.progressInMegaBytes()).add("ElapsedTimeInSeconds", (Object)this.elapsedTimeInSeconds()).add("EstimatedTimeToCompletionInSeconds", (Object)this.estimatedTimeToCompletionInSeconds()).add("ResizeType", (Object)this.resizeType()).add("Message", (Object)this.message()).add("TargetEncryptionType", (Object)this.targetEncryptionType()).add("DataTransferProgressPercent", (Object)this.dataTransferProgressPercent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetNodeType": {
                return Optional.ofNullable(clazz.cast(this.targetNodeType()));
            }
            case "TargetNumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.targetNumberOfNodes()));
            }
            case "TargetClusterType": {
                return Optional.ofNullable(clazz.cast(this.targetClusterType()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "ImportTablesCompleted": {
                return Optional.ofNullable(clazz.cast(this.importTablesCompleted()));
            }
            case "ImportTablesInProgress": {
                return Optional.ofNullable(clazz.cast(this.importTablesInProgress()));
            }
            case "ImportTablesNotStarted": {
                return Optional.ofNullable(clazz.cast(this.importTablesNotStarted()));
            }
            case "AvgResizeRateInMegaBytesPerSecond": {
                return Optional.ofNullable(clazz.cast(this.avgResizeRateInMegaBytesPerSecond()));
            }
            case "TotalResizeDataInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.totalResizeDataInMegaBytes()));
            }
            case "ProgressInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.progressInMegaBytes()));
            }
            case "ElapsedTimeInSeconds": {
                return Optional.ofNullable(clazz.cast(this.elapsedTimeInSeconds()));
            }
            case "EstimatedTimeToCompletionInSeconds": {
                return Optional.ofNullable(clazz.cast(this.estimatedTimeToCompletionInSeconds()));
            }
            case "ResizeType": {
                return Optional.ofNullable(clazz.cast(this.resizeType()));
            }
            case "Message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "TargetEncryptionType": {
                return Optional.ofNullable(clazz.cast(this.targetEncryptionType()));
            }
            case "DataTransferProgressPercent": {
                return Optional.ofNullable(clazz.cast(this.dataTransferProgressPercent()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetNodeType", TARGET_NODE_TYPE_FIELD);
        map.put("TargetNumberOfNodes", TARGET_NUMBER_OF_NODES_FIELD);
        map.put("TargetClusterType", TARGET_CLUSTER_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("ImportTablesCompleted", IMPORT_TABLES_COMPLETED_FIELD);
        map.put("ImportTablesInProgress", IMPORT_TABLES_IN_PROGRESS_FIELD);
        map.put("ImportTablesNotStarted", IMPORT_TABLES_NOT_STARTED_FIELD);
        map.put("AvgResizeRateInMegaBytesPerSecond", AVG_RESIZE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD);
        map.put("TotalResizeDataInMegaBytes", TOTAL_RESIZE_DATA_IN_MEGA_BYTES_FIELD);
        map.put("ProgressInMegaBytes", PROGRESS_IN_MEGA_BYTES_FIELD);
        map.put("ElapsedTimeInSeconds", ELAPSED_TIME_IN_SECONDS_FIELD);
        map.put("EstimatedTimeToCompletionInSeconds", ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD);
        map.put("ResizeType", RESIZE_TYPE_FIELD);
        map.put("Message", MESSAGE_FIELD);
        map.put("TargetEncryptionType", TARGET_ENCRYPTION_TYPE_FIELD);
        map.put("DataTransferProgressPercent", DATA_TRANSFER_PROGRESS_PERCENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CancelResizeResponse, T> g) {
        return obj -> g.apply((CancelResizeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String targetNodeType;
        private Integer targetNumberOfNodes;
        private String targetClusterType;
        private String status;
        private List<String> importTablesCompleted = DefaultSdkAutoConstructList.getInstance();
        private List<String> importTablesInProgress = DefaultSdkAutoConstructList.getInstance();
        private List<String> importTablesNotStarted = DefaultSdkAutoConstructList.getInstance();
        private Double avgResizeRateInMegaBytesPerSecond;
        private Long totalResizeDataInMegaBytes;
        private Long progressInMegaBytes;
        private Long elapsedTimeInSeconds;
        private Long estimatedTimeToCompletionInSeconds;
        private String resizeType;
        private String message;
        private String targetEncryptionType;
        private Double dataTransferProgressPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(CancelResizeResponse model) {
            super(model);
            this.targetNodeType(model.targetNodeType);
            this.targetNumberOfNodes(model.targetNumberOfNodes);
            this.targetClusterType(model.targetClusterType);
            this.status(model.status);
            this.importTablesCompleted(model.importTablesCompleted);
            this.importTablesInProgress(model.importTablesInProgress);
            this.importTablesNotStarted(model.importTablesNotStarted);
            this.avgResizeRateInMegaBytesPerSecond(model.avgResizeRateInMegaBytesPerSecond);
            this.totalResizeDataInMegaBytes(model.totalResizeDataInMegaBytes);
            this.progressInMegaBytes(model.progressInMegaBytes);
            this.elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            this.estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
            this.resizeType(model.resizeType);
            this.message(model.message);
            this.targetEncryptionType(model.targetEncryptionType);
            this.dataTransferProgressPercent(model.dataTransferProgressPercent);
        }

        public final String getTargetNodeType() {
            return this.targetNodeType;
        }

        public final void setTargetNodeType(String targetNodeType) {
            this.targetNodeType = targetNodeType;
        }

        @Override
        public final Builder targetNodeType(String targetNodeType) {
            this.targetNodeType = targetNodeType;
            return this;
        }

        public final Integer getTargetNumberOfNodes() {
            return this.targetNumberOfNodes;
        }

        public final void setTargetNumberOfNodes(Integer targetNumberOfNodes) {
            this.targetNumberOfNodes = targetNumberOfNodes;
        }

        @Override
        public final Builder targetNumberOfNodes(Integer targetNumberOfNodes) {
            this.targetNumberOfNodes = targetNumberOfNodes;
            return this;
        }

        public final String getTargetClusterType() {
            return this.targetClusterType;
        }

        public final void setTargetClusterType(String targetClusterType) {
            this.targetClusterType = targetClusterType;
        }

        @Override
        public final Builder targetClusterType(String targetClusterType) {
            this.targetClusterType = targetClusterType;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final Collection<String> getImportTablesCompleted() {
            if (this.importTablesCompleted instanceof SdkAutoConstructList) {
                return null;
            }
            return this.importTablesCompleted;
        }

        public final void setImportTablesCompleted(Collection<String> importTablesCompleted) {
            this.importTablesCompleted = ImportTablesCompletedCopier.copy(importTablesCompleted);
        }

        @Override
        public final Builder importTablesCompleted(Collection<String> importTablesCompleted) {
            this.importTablesCompleted = ImportTablesCompletedCopier.copy(importTablesCompleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesCompleted(String ... importTablesCompleted) {
            this.importTablesCompleted(Arrays.asList(importTablesCompleted));
            return this;
        }

        public final Collection<String> getImportTablesInProgress() {
            if (this.importTablesInProgress instanceof SdkAutoConstructList) {
                return null;
            }
            return this.importTablesInProgress;
        }

        public final void setImportTablesInProgress(Collection<String> importTablesInProgress) {
            this.importTablesInProgress = ImportTablesInProgressCopier.copy(importTablesInProgress);
        }

        @Override
        public final Builder importTablesInProgress(Collection<String> importTablesInProgress) {
            this.importTablesInProgress = ImportTablesInProgressCopier.copy(importTablesInProgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesInProgress(String ... importTablesInProgress) {
            this.importTablesInProgress(Arrays.asList(importTablesInProgress));
            return this;
        }

        public final Collection<String> getImportTablesNotStarted() {
            if (this.importTablesNotStarted instanceof SdkAutoConstructList) {
                return null;
            }
            return this.importTablesNotStarted;
        }

        public final void setImportTablesNotStarted(Collection<String> importTablesNotStarted) {
            this.importTablesNotStarted = ImportTablesNotStartedCopier.copy(importTablesNotStarted);
        }

        @Override
        public final Builder importTablesNotStarted(Collection<String> importTablesNotStarted) {
            this.importTablesNotStarted = ImportTablesNotStartedCopier.copy(importTablesNotStarted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesNotStarted(String ... importTablesNotStarted) {
            this.importTablesNotStarted(Arrays.asList(importTablesNotStarted));
            return this;
        }

        public final Double getAvgResizeRateInMegaBytesPerSecond() {
            return this.avgResizeRateInMegaBytesPerSecond;
        }

        public final void setAvgResizeRateInMegaBytesPerSecond(Double avgResizeRateInMegaBytesPerSecond) {
            this.avgResizeRateInMegaBytesPerSecond = avgResizeRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder avgResizeRateInMegaBytesPerSecond(Double avgResizeRateInMegaBytesPerSecond) {
            this.avgResizeRateInMegaBytesPerSecond = avgResizeRateInMegaBytesPerSecond;
            return this;
        }

        public final Long getTotalResizeDataInMegaBytes() {
            return this.totalResizeDataInMegaBytes;
        }

        public final void setTotalResizeDataInMegaBytes(Long totalResizeDataInMegaBytes) {
            this.totalResizeDataInMegaBytes = totalResizeDataInMegaBytes;
        }

        @Override
        public final Builder totalResizeDataInMegaBytes(Long totalResizeDataInMegaBytes) {
            this.totalResizeDataInMegaBytes = totalResizeDataInMegaBytes;
            return this;
        }

        public final Long getProgressInMegaBytes() {
            return this.progressInMegaBytes;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return this.estimatedTimeToCompletionInSeconds;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final String getResizeType() {
            return this.resizeType;
        }

        public final void setResizeType(String resizeType) {
            this.resizeType = resizeType;
        }

        @Override
        public final Builder resizeType(String resizeType) {
            this.resizeType = resizeType;
            return this;
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getTargetEncryptionType() {
            return this.targetEncryptionType;
        }

        public final void setTargetEncryptionType(String targetEncryptionType) {
            this.targetEncryptionType = targetEncryptionType;
        }

        @Override
        public final Builder targetEncryptionType(String targetEncryptionType) {
            this.targetEncryptionType = targetEncryptionType;
            return this;
        }

        public final Double getDataTransferProgressPercent() {
            return this.dataTransferProgressPercent;
        }

        public final void setDataTransferProgressPercent(Double dataTransferProgressPercent) {
            this.dataTransferProgressPercent = dataTransferProgressPercent;
        }

        @Override
        public final Builder dataTransferProgressPercent(Double dataTransferProgressPercent) {
            this.dataTransferProgressPercent = dataTransferProgressPercent;
            return this;
        }

        @Override
        public CancelResizeResponse build() {
            return new CancelResizeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CancelResizeResponse> {
        public Builder targetNodeType(String var1);

        public Builder targetNumberOfNodes(Integer var1);

        public Builder targetClusterType(String var1);

        public Builder status(String var1);

        public Builder importTablesCompleted(Collection<String> var1);

        public Builder importTablesCompleted(String ... var1);

        public Builder importTablesInProgress(Collection<String> var1);

        public Builder importTablesInProgress(String ... var1);

        public Builder importTablesNotStarted(Collection<String> var1);

        public Builder importTablesNotStarted(String ... var1);

        public Builder avgResizeRateInMegaBytesPerSecond(Double var1);

        public Builder totalResizeDataInMegaBytes(Long var1);

        public Builder progressInMegaBytes(Long var1);

        public Builder elapsedTimeInSeconds(Long var1);

        public Builder estimatedTimeToCompletionInSeconds(Long var1);

        public Builder resizeType(String var1);

        public Builder message(String var1);

        public Builder targetEncryptionType(String var1);

        public Builder dataTransferProgressPercent(Double var1);
    }
}

