/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizeSnapshotAccessRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, AuthorizeSnapshotAccessRequest> {
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotIdentifier").getter(AuthorizeSnapshotAccessRequest.getter(AuthorizeSnapshotAccessRequest::snapshotIdentifier)).setter(AuthorizeSnapshotAccessRequest.setter(Builder::snapshotIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotArn").getter(AuthorizeSnapshotAccessRequest.getter(AuthorizeSnapshotAccessRequest::snapshotArn)).setter(AuthorizeSnapshotAccessRequest.setter(Builder::snapshotArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotArn").build()}).build();
    private static final SdkField<String> SNAPSHOT_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotClusterIdentifier").getter(AuthorizeSnapshotAccessRequest.getter(AuthorizeSnapshotAccessRequest::snapshotClusterIdentifier)).setter(AuthorizeSnapshotAccessRequest.setter(Builder::snapshotClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotClusterIdentifier").build()}).build();
    private static final SdkField<String> ACCOUNT_WITH_RESTORE_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountWithRestoreAccess").getter(AuthorizeSnapshotAccessRequest.getter(AuthorizeSnapshotAccessRequest::accountWithRestoreAccess)).setter(AuthorizeSnapshotAccessRequest.setter(Builder::accountWithRestoreAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountWithRestoreAccess").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_FIELD, SNAPSHOT_ARN_FIELD, SNAPSHOT_CLUSTER_IDENTIFIER_FIELD, ACCOUNT_WITH_RESTORE_ACCESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AuthorizeSnapshotAccessRequest.memberNameToFieldInitializer();
    private final String snapshotIdentifier;
    private final String snapshotArn;
    private final String snapshotClusterIdentifier;
    private final String accountWithRestoreAccess;

    private AuthorizeSnapshotAccessRequest(BuilderImpl builder) {
        super(builder);
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotArn = builder.snapshotArn;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.accountWithRestoreAccess = builder.accountWithRestoreAccess;
    }

    public final String snapshotIdentifier() {
        return this.snapshotIdentifier;
    }

    public final String snapshotArn() {
        return this.snapshotArn;
    }

    public final String snapshotClusterIdentifier() {
        return this.snapshotClusterIdentifier;
    }

    public final String accountWithRestoreAccess() {
        return this.accountWithRestoreAccess;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountWithRestoreAccess());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizeSnapshotAccessRequest)) {
            return false;
        }
        AuthorizeSnapshotAccessRequest other = (AuthorizeSnapshotAccessRequest)((Object)obj);
        return Objects.equals(this.snapshotIdentifier(), other.snapshotIdentifier()) && Objects.equals(this.snapshotArn(), other.snapshotArn()) && Objects.equals(this.snapshotClusterIdentifier(), other.snapshotClusterIdentifier()) && Objects.equals(this.accountWithRestoreAccess(), other.accountWithRestoreAccess());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizeSnapshotAccessRequest").add("SnapshotIdentifier", (Object)this.snapshotIdentifier()).add("SnapshotArn", (Object)this.snapshotArn()).add("SnapshotClusterIdentifier", (Object)this.snapshotClusterIdentifier()).add("AccountWithRestoreAccess", (Object)this.accountWithRestoreAccess()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SnapshotIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotIdentifier()));
            }
            case "SnapshotArn": {
                return Optional.ofNullable(clazz.cast(this.snapshotArn()));
            }
            case "SnapshotClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotClusterIdentifier()));
            }
            case "AccountWithRestoreAccess": {
                return Optional.ofNullable(clazz.cast(this.accountWithRestoreAccess()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("SnapshotIdentifier", SNAPSHOT_IDENTIFIER_FIELD);
        map.put("SnapshotArn", SNAPSHOT_ARN_FIELD);
        map.put("SnapshotClusterIdentifier", SNAPSHOT_CLUSTER_IDENTIFIER_FIELD);
        map.put("AccountWithRestoreAccess", ACCOUNT_WITH_RESTORE_ACCESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AuthorizeSnapshotAccessRequest, T> g) {
        return obj -> g.apply((AuthorizeSnapshotAccessRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String snapshotIdentifier;
        private String snapshotArn;
        private String snapshotClusterIdentifier;
        private String accountWithRestoreAccess;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizeSnapshotAccessRequest model) {
            super(model);
            this.snapshotIdentifier(model.snapshotIdentifier);
            this.snapshotArn(model.snapshotArn);
            this.snapshotClusterIdentifier(model.snapshotClusterIdentifier);
            this.accountWithRestoreAccess(model.accountWithRestoreAccess);
        }

        public final String getSnapshotIdentifier() {
            return this.snapshotIdentifier;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final String getSnapshotArn() {
            return this.snapshotArn;
        }

        public final void setSnapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
        }

        @Override
        public final Builder snapshotArn(String snapshotArn) {
            this.snapshotArn = snapshotArn;
            return this;
        }

        public final String getSnapshotClusterIdentifier() {
            return this.snapshotClusterIdentifier;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final String getAccountWithRestoreAccess() {
            return this.accountWithRestoreAccess;
        }

        public final void setAccountWithRestoreAccess(String accountWithRestoreAccess) {
            this.accountWithRestoreAccess = accountWithRestoreAccess;
        }

        @Override
        public final Builder accountWithRestoreAccess(String accountWithRestoreAccess) {
            this.accountWithRestoreAccess = accountWithRestoreAccess;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AuthorizeSnapshotAccessRequest build() {
            return new AuthorizeSnapshotAccessRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AuthorizeSnapshotAccessRequest> {
        public Builder snapshotIdentifier(String var1);

        public Builder snapshotArn(String var1);

        public Builder snapshotClusterIdentifier(String var1);

        public Builder accountWithRestoreAccess(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

