/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusRequest;
import software.amazon.awssdk.services.redshift.model.DescribeReservedNodeExchangeStatusResponse;
import software.amazon.awssdk.services.redshift.model.ReservedNodeExchangeStatus;

public class DescribeReservedNodeExchangeStatusIterable
implements SdkIterable<DescribeReservedNodeExchangeStatusResponse> {
    private final RedshiftClient client;
    private final DescribeReservedNodeExchangeStatusRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeReservedNodeExchangeStatusIterable(RedshiftClient client, DescribeReservedNodeExchangeStatusRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeReservedNodeExchangeStatusResponseFetcher();
    }

    public Iterator<DescribeReservedNodeExchangeStatusResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ReservedNodeExchangeStatus> reservedNodeExchangeStatusDetails() {
        Function<DescribeReservedNodeExchangeStatusResponse, Iterator> getIterator = response -> {
            if (response != null && response.reservedNodeExchangeStatusDetails() != null) {
                return response.reservedNodeExchangeStatusDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeReservedNodeExchangeStatusResponseFetcher
    implements SyncPageFetcher<DescribeReservedNodeExchangeStatusResponse> {
        private DescribeReservedNodeExchangeStatusResponseFetcher() {
        }

        public boolean hasNextPage(DescribeReservedNodeExchangeStatusResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public DescribeReservedNodeExchangeStatusResponse nextPage(DescribeReservedNodeExchangeStatusResponse previousPage) {
            if (previousPage == null) {
                return DescribeReservedNodeExchangeStatusIterable.this.client.describeReservedNodeExchangeStatus(DescribeReservedNodeExchangeStatusIterable.this.firstRequest);
            }
            return DescribeReservedNodeExchangeStatusIterable.this.client.describeReservedNodeExchangeStatus((DescribeReservedNodeExchangeStatusRequest)((Object)DescribeReservedNodeExchangeStatusIterable.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

