/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.Parameter;

public class DescribeClusterParametersPublisher
implements SdkPublisher<DescribeClusterParametersResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeClusterParametersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeClusterParametersPublisher(RedshiftAsyncClient client, DescribeClusterParametersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeClusterParametersPublisher(RedshiftAsyncClient client, DescribeClusterParametersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeClusterParametersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeClusterParametersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Parameter> parameters() {
        Function<DescribeClusterParametersResponse, Iterator> getIterator = response -> {
            if (response != null && response.parameters() != null) {
                return response.parameters().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeClusterParametersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeClusterParametersPublisher resume(DescribeClusterParametersResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeClusterParametersPublisher(this.client, (DescribeClusterParametersRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeClusterParametersPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeClusterParametersResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeClusterParametersResponseFetcher
    implements AsyncPageFetcher<DescribeClusterParametersResponse> {
        private DescribeClusterParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterParametersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeClusterParametersResponse> nextPage(DescribeClusterParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterParametersPublisher.this.client.describeClusterParameters(DescribeClusterParametersPublisher.this.firstRequest);
            }
            return DescribeClusterParametersPublisher.this.client.describeClusterParameters((DescribeClusterParametersRequest)((Object)DescribeClusterParametersPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

