/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyClusterSnapshotScheduleRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyClusterSnapshotScheduleRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(ModifyClusterSnapshotScheduleRequest.getter(ModifyClusterSnapshotScheduleRequest::clusterIdentifier)).setter(ModifyClusterSnapshotScheduleRequest.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> SCHEDULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScheduleIdentifier").getter(ModifyClusterSnapshotScheduleRequest.getter(ModifyClusterSnapshotScheduleRequest::scheduleIdentifier)).setter(ModifyClusterSnapshotScheduleRequest.setter(Builder::scheduleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleIdentifier").build()}).build();
    private static final SdkField<Boolean> DISASSOCIATE_SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DisassociateSchedule").getter(ModifyClusterSnapshotScheduleRequest.getter(ModifyClusterSnapshotScheduleRequest::disassociateSchedule)).setter(ModifyClusterSnapshotScheduleRequest.setter(Builder::disassociateSchedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisassociateSchedule").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, SCHEDULE_IDENTIFIER_FIELD, DISASSOCIATE_SCHEDULE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ModifyClusterSnapshotScheduleRequest.memberNameToFieldInitializer();
    private final String clusterIdentifier;
    private final String scheduleIdentifier;
    private final Boolean disassociateSchedule;

    private ModifyClusterSnapshotScheduleRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.scheduleIdentifier = builder.scheduleIdentifier;
        this.disassociateSchedule = builder.disassociateSchedule;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String scheduleIdentifier() {
        return this.scheduleIdentifier;
    }

    public final Boolean disassociateSchedule() {
        return this.disassociateSchedule;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.disassociateSchedule());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterSnapshotScheduleRequest)) {
            return false;
        }
        ModifyClusterSnapshotScheduleRequest other = (ModifyClusterSnapshotScheduleRequest)((Object)obj);
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.scheduleIdentifier(), other.scheduleIdentifier()) && Objects.equals(this.disassociateSchedule(), other.disassociateSchedule());
    }

    public final String toString() {
        return ToString.builder((String)"ModifyClusterSnapshotScheduleRequest").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("ScheduleIdentifier", (Object)this.scheduleIdentifier()).add("DisassociateSchedule", (Object)this.disassociateSchedule()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "ScheduleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.scheduleIdentifier()));
            }
            case "DisassociateSchedule": {
                return Optional.ofNullable(clazz.cast(this.disassociateSchedule()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClusterIdentifier", CLUSTER_IDENTIFIER_FIELD);
        map.put("ScheduleIdentifier", SCHEDULE_IDENTIFIER_FIELD);
        map.put("DisassociateSchedule", DISASSOCIATE_SCHEDULE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterSnapshotScheduleRequest, T> g) {
        return obj -> g.apply((ModifyClusterSnapshotScheduleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String scheduleIdentifier;
        private Boolean disassociateSchedule;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterSnapshotScheduleRequest model) {
            super(model);
            this.clusterIdentifier(model.clusterIdentifier);
            this.scheduleIdentifier(model.scheduleIdentifier);
            this.disassociateSchedule(model.disassociateSchedule);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getScheduleIdentifier() {
            return this.scheduleIdentifier;
        }

        public final void setScheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
        }

        @Override
        public final Builder scheduleIdentifier(String scheduleIdentifier) {
            this.scheduleIdentifier = scheduleIdentifier;
            return this;
        }

        public final Boolean getDisassociateSchedule() {
            return this.disassociateSchedule;
        }

        public final void setDisassociateSchedule(Boolean disassociateSchedule) {
            this.disassociateSchedule = disassociateSchedule;
        }

        @Override
        public final Builder disassociateSchedule(Boolean disassociateSchedule) {
            this.disassociateSchedule = disassociateSchedule;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterSnapshotScheduleRequest build() {
            return new ModifyClusterSnapshotScheduleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyClusterSnapshotScheduleRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder scheduleIdentifier(String var1);

        public Builder disassociateSchedule(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

