/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrant;
import software.amazon.awssdk.services.redshift.model.SnapshotCopyGrantListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSnapshotCopyGrantsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeSnapshotCopyGrantsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeSnapshotCopyGrantsResponse.getter(DescribeSnapshotCopyGrantsResponse::marker)).setter(DescribeSnapshotCopyGrantsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<SnapshotCopyGrant>> SNAPSHOT_COPY_GRANTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SnapshotCopyGrants").getter(DescribeSnapshotCopyGrantsResponse.getter(DescribeSnapshotCopyGrantsResponse::snapshotCopyGrants)).setter(DescribeSnapshotCopyGrantsResponse.setter(Builder::snapshotCopyGrants)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCopyGrants").build(), ListTrait.builder().memberLocationName("SnapshotCopyGrant").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SnapshotCopyGrant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCopyGrant").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, SNAPSHOT_COPY_GRANTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSnapshotCopyGrantsResponse.memberNameToFieldInitializer();
    private final String marker;
    private final List<SnapshotCopyGrant> snapshotCopyGrants;

    private DescribeSnapshotCopyGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.snapshotCopyGrants = builder.snapshotCopyGrants;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasSnapshotCopyGrants() {
        return this.snapshotCopyGrants != null && !(this.snapshotCopyGrants instanceof SdkAutoConstructList);
    }

    public final List<SnapshotCopyGrant> snapshotCopyGrants() {
        return this.snapshotCopyGrants;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSnapshotCopyGrants() ? this.snapshotCopyGrants() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotCopyGrantsResponse)) {
            return false;
        }
        DescribeSnapshotCopyGrantsResponse other = (DescribeSnapshotCopyGrantsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasSnapshotCopyGrants() == other.hasSnapshotCopyGrants() && Objects.equals(this.snapshotCopyGrants(), other.snapshotCopyGrants());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSnapshotCopyGrantsResponse").add("Marker", (Object)this.marker()).add("SnapshotCopyGrants", this.hasSnapshotCopyGrants() ? this.snapshotCopyGrants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "SnapshotCopyGrants": {
                return Optional.ofNullable(clazz.cast(this.snapshotCopyGrants()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Marker", MARKER_FIELD);
        map.put("SnapshotCopyGrants", SNAPSHOT_COPY_GRANTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotCopyGrantsResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotCopyGrantsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<SnapshotCopyGrant> snapshotCopyGrants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotCopyGrantsResponse model) {
            super(model);
            this.marker(model.marker);
            this.snapshotCopyGrants(model.snapshotCopyGrants);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<SnapshotCopyGrant.Builder> getSnapshotCopyGrants() {
            List<SnapshotCopyGrant.Builder> result = SnapshotCopyGrantListCopier.copyToBuilder(this.snapshotCopyGrants);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSnapshotCopyGrants(Collection<SnapshotCopyGrant.BuilderImpl> snapshotCopyGrants) {
            this.snapshotCopyGrants = SnapshotCopyGrantListCopier.copyFromBuilder(snapshotCopyGrants);
        }

        @Override
        public final Builder snapshotCopyGrants(Collection<SnapshotCopyGrant> snapshotCopyGrants) {
            this.snapshotCopyGrants = SnapshotCopyGrantListCopier.copy(snapshotCopyGrants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyGrants(SnapshotCopyGrant ... snapshotCopyGrants) {
            this.snapshotCopyGrants(Arrays.asList(snapshotCopyGrants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyGrants(Consumer<SnapshotCopyGrant.Builder> ... snapshotCopyGrants) {
            this.snapshotCopyGrants(Stream.of(snapshotCopyGrants).map(c -> (SnapshotCopyGrant)((SnapshotCopyGrant.Builder)SnapshotCopyGrant.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeSnapshotCopyGrantsResponse build() {
            return new DescribeSnapshotCopyGrantsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSnapshotCopyGrantsResponse> {
        public Builder marker(String var1);

        public Builder snapshotCopyGrants(Collection<SnapshotCopyGrant> var1);

        public Builder snapshotCopyGrants(SnapshotCopyGrant ... var1);

        public Builder snapshotCopyGrants(Consumer<SnapshotCopyGrant.Builder> ... var1);
    }
}

