/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.Association;
import software.amazon.awssdk.services.redshift.model.AssociationListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCustomDomainAssociationsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeCustomDomainAssociationsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeCustomDomainAssociationsResponse.getter(DescribeCustomDomainAssociationsResponse::marker)).setter(DescribeCustomDomainAssociationsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<Association>> ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Associations").getter(DescribeCustomDomainAssociationsResponse.getter(DescribeCustomDomainAssociationsResponse::associations)).setter(DescribeCustomDomainAssociationsResponse.setter(Builder::associations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Associations").build(), ListTrait.builder().memberLocationName("Association").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Association::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Association").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, ASSOCIATIONS_FIELD));
    private final String marker;
    private final List<Association> associations;

    private DescribeCustomDomainAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.associations = builder.associations;
    }

    public final String marker() {
        return this.marker;
    }

    public final boolean hasAssociations() {
        return this.associations != null && !(this.associations instanceof SdkAutoConstructList);
    }

    public final List<Association> associations() {
        return this.associations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssociations() ? this.associations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCustomDomainAssociationsResponse)) {
            return false;
        }
        DescribeCustomDomainAssociationsResponse other = (DescribeCustomDomainAssociationsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasAssociations() == other.hasAssociations() && Objects.equals(this.associations(), other.associations());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCustomDomainAssociationsResponse").add("Marker", (Object)this.marker()).add("Associations", this.hasAssociations() ? this.associations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "Associations": {
                return Optional.ofNullable(clazz.cast(this.associations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeCustomDomainAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeCustomDomainAssociationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<Association> associations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCustomDomainAssociationsResponse model) {
            super(model);
            this.marker(model.marker);
            this.associations(model.associations);
        }

        public final String getMarker() {
            return this.marker;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final List<Association.Builder> getAssociations() {
            List<Association.Builder> result = AssociationListCopier.copyToBuilder(this.associations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssociations(Collection<Association.BuilderImpl> associations) {
            this.associations = AssociationListCopier.copyFromBuilder(associations);
        }

        @Override
        public final Builder associations(Collection<Association> associations) {
            this.associations = AssociationListCopier.copy(associations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Association ... associations) {
            this.associations(Arrays.asList(associations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder associations(Consumer<Association.Builder> ... associations) {
            this.associations(Stream.of(associations).map(c -> (Association)((Association.Builder)Association.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeCustomDomainAssociationsResponse build() {
            return new DescribeCustomDomainAssociationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCustomDomainAssociationsResponse> {
        public Builder marker(String var1);

        public Builder associations(Collection<Association> var1);

        public Builder associations(Association ... var1);

        public Builder associations(Consumer<Association.Builder> ... var1);
    }
}

