/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A list of scopes set up for Lake Formation integration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LakeFormationScopeUnion implements SdkPojo, Serializable,
        ToCopyableBuilder<LakeFormationScopeUnion.Builder, LakeFormationScopeUnion> {
    private static final SdkField<LakeFormationQuery> LAKE_FORMATION_QUERY_FIELD = SdkField
            .<LakeFormationQuery> builder(MarshallingType.SDK_POJO).memberName("LakeFormationQuery")
            .getter(getter(LakeFormationScopeUnion::lakeFormationQuery)).setter(setter(Builder::lakeFormationQuery))
            .constructor(LakeFormationQuery::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LakeFormationQuery").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAKE_FORMATION_QUERY_FIELD));

    private static final long serialVersionUID = 1L;

    private final LakeFormationQuery lakeFormationQuery;

    private final Type type;

    private LakeFormationScopeUnion(BuilderImpl builder) {
        this.lakeFormationQuery = builder.lakeFormationQuery;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Lake Formation scope.
     * </p>
     * 
     * @return The Lake Formation scope.
     */
    public final LakeFormationQuery lakeFormationQuery() {
        return lakeFormationQuery;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(lakeFormationQuery());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationScopeUnion)) {
            return false;
        }
        LakeFormationScopeUnion other = (LakeFormationScopeUnion) obj;
        return Objects.equals(lakeFormationQuery(), other.lakeFormationQuery());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LakeFormationScopeUnion").add("LakeFormationQuery", lakeFormationQuery()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LakeFormationQuery":
            return Optional.ofNullable(clazz.cast(lakeFormationQuery()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #lakeFormationQuery()} initialized to the given value.
     *
     * <p>
     * The Lake Formation scope.
     * </p>
     * 
     * @param lakeFormationQuery
     *        The Lake Formation scope.
     */
    public static LakeFormationScopeUnion fromLakeFormationQuery(LakeFormationQuery lakeFormationQuery) {
        return builder().lakeFormationQuery(lakeFormationQuery).build();
    }

    /**
     * Create an instance of this class with {@link #lakeFormationQuery()} initialized to the given value.
     *
     * <p>
     * The Lake Formation scope.
     * </p>
     * 
     * @param lakeFormationQuery
     *        The Lake Formation scope.
     */
    public static LakeFormationScopeUnion fromLakeFormationQuery(Consumer<LakeFormationQuery.Builder> lakeFormationQuery) {
        LakeFormationQuery.Builder builder = LakeFormationQuery.builder();
        lakeFormationQuery.accept(builder);
        return fromLakeFormationQuery(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationScopeUnion, T> g) {
        return obj -> g.apply((LakeFormationScopeUnion) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LakeFormationScopeUnion> {
        /**
         * <p>
         * The Lake Formation scope.
         * </p>
         * 
         * @param lakeFormationQuery
         *        The Lake Formation scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lakeFormationQuery(LakeFormationQuery lakeFormationQuery);

        /**
         * <p>
         * The Lake Formation scope.
         * </p>
         * This is a convenience method that creates an instance of the {@link LakeFormationQuery.Builder} avoiding the
         * need to create one manually via {@link LakeFormationQuery#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LakeFormationQuery.Builder#build()} is called immediately and its
         * result is passed to {@link #lakeFormationQuery(LakeFormationQuery)}.
         * 
         * @param lakeFormationQuery
         *        a consumer that will call methods on {@link LakeFormationQuery.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lakeFormationQuery(LakeFormationQuery)
         */
        default Builder lakeFormationQuery(Consumer<LakeFormationQuery.Builder> lakeFormationQuery) {
            return lakeFormationQuery(LakeFormationQuery.builder().applyMutation(lakeFormationQuery).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LakeFormationQuery lakeFormationQuery;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationScopeUnion model) {
            lakeFormationQuery(model.lakeFormationQuery);
        }

        public final LakeFormationQuery.Builder getLakeFormationQuery() {
            return lakeFormationQuery != null ? lakeFormationQuery.toBuilder() : null;
        }

        public final void setLakeFormationQuery(LakeFormationQuery.BuilderImpl lakeFormationQuery) {
            Object oldValue = this.lakeFormationQuery;
            this.lakeFormationQuery = lakeFormationQuery != null ? lakeFormationQuery.build() : null;
            handleUnionValueChange(Type.LAKE_FORMATION_QUERY, oldValue, this.lakeFormationQuery);
        }

        @Override
        public final Builder lakeFormationQuery(LakeFormationQuery lakeFormationQuery) {
            Object oldValue = this.lakeFormationQuery;
            this.lakeFormationQuery = lakeFormationQuery;
            handleUnionValueChange(Type.LAKE_FORMATION_QUERY, oldValue, this.lakeFormationQuery);
            return this;
        }

        @Override
        public LakeFormationScopeUnion build() {
            return new LakeFormationScopeUnion(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see LakeFormationScopeUnion#type()
     */
    public enum Type {
        LAKE_FORMATION_QUERY,

        UNKNOWN_TO_SDK_VERSION
    }
}
