/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseReservedNodeOfferingRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, PurchaseReservedNodeOfferingRequest> {
    private static final SdkField<String> RESERVED_NODE_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedNodeOfferingId").getter(PurchaseReservedNodeOfferingRequest.getter(PurchaseReservedNodeOfferingRequest::reservedNodeOfferingId)).setter(PurchaseReservedNodeOfferingRequest.setter(Builder::reservedNodeOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodeOfferingId").build()}).build();
    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NodeCount").getter(PurchaseReservedNodeOfferingRequest.getter(PurchaseReservedNodeOfferingRequest::nodeCount)).setter(PurchaseReservedNodeOfferingRequest.setter(Builder::nodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_NODE_OFFERING_ID_FIELD, NODE_COUNT_FIELD));
    private final String reservedNodeOfferingId;
    private final Integer nodeCount;

    private PurchaseReservedNodeOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedNodeOfferingId = builder.reservedNodeOfferingId;
        this.nodeCount = builder.nodeCount;
    }

    public final String reservedNodeOfferingId() {
        return this.reservedNodeOfferingId;
    }

    public final Integer nodeCount() {
        return this.nodeCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedNodeOfferingRequest)) {
            return false;
        }
        PurchaseReservedNodeOfferingRequest other = (PurchaseReservedNodeOfferingRequest)((Object)obj);
        return Objects.equals(this.reservedNodeOfferingId(), other.reservedNodeOfferingId()) && Objects.equals(this.nodeCount(), other.nodeCount());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseReservedNodeOfferingRequest").add("ReservedNodeOfferingId", (Object)this.reservedNodeOfferingId()).add("NodeCount", (Object)this.nodeCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedNodeOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodeOfferingId()));
            }
            case "NodeCount": {
                return Optional.ofNullable(clazz.cast(this.nodeCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedNodeOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedNodeOfferingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String reservedNodeOfferingId;
        private Integer nodeCount;

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedNodeOfferingRequest model) {
            super(model);
            this.reservedNodeOfferingId(model.reservedNodeOfferingId);
            this.nodeCount(model.nodeCount);
        }

        public final String getReservedNodeOfferingId() {
            return this.reservedNodeOfferingId;
        }

        public final void setReservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
        }

        @Override
        public final Builder reservedNodeOfferingId(String reservedNodeOfferingId) {
            this.reservedNodeOfferingId = reservedNodeOfferingId;
            return this;
        }

        public final Integer getNodeCount() {
            return this.nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedNodeOfferingRequest build() {
            return new PurchaseReservedNodeOfferingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseReservedNodeOfferingRequest> {
        public Builder reservedNodeOfferingId(String var1);

        public Builder nodeCount(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

