/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.AquaConfiguration;
import software.amazon.awssdk.services.redshift.model.ClusterIamRole;
import software.amazon.awssdk.services.redshift.model.ClusterIamRoleListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterNode;
import software.amazon.awssdk.services.redshift.model.ClusterNodesListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatus;
import software.amazon.awssdk.services.redshift.model.ClusterParameterGroupStatusListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembership;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.redshift.model.ClusterSnapshotCopyStatus;
import software.amazon.awssdk.services.redshift.model.DataTransferProgress;
import software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindow;
import software.amazon.awssdk.services.redshift.model.DeferredMaintenanceWindowsListCopier;
import software.amazon.awssdk.services.redshift.model.ElasticIpStatus;
import software.amazon.awssdk.services.redshift.model.Endpoint;
import software.amazon.awssdk.services.redshift.model.HsmStatus;
import software.amazon.awssdk.services.redshift.model.PendingActionsListCopier;
import software.amazon.awssdk.services.redshift.model.PendingModifiedValues;
import software.amazon.awssdk.services.redshift.model.ResizeInfo;
import software.amazon.awssdk.services.redshift.model.RestoreStatus;
import software.amazon.awssdk.services.redshift.model.ScheduleState;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembership;
import software.amazon.awssdk.services.redshift.model.VpcSecurityGroupMembershipListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterIdentifier").getter(Cluster.getter(Cluster::clusterIdentifier)).setter(Cluster.setter(Builder::clusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(Cluster.getter(Cluster::nodeType)).setter(Cluster.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> CLUSTER_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterStatus").getter(Cluster.getter(Cluster::clusterStatus)).setter(Cluster.setter(Builder::clusterStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterStatus").build()}).build();
    private static final SdkField<String> CLUSTER_AVAILABILITY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterAvailabilityStatus").getter(Cluster.getter(Cluster::clusterAvailabilityStatus)).setter(Cluster.setter(Builder::clusterAvailabilityStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterAvailabilityStatus").build()}).build();
    private static final SdkField<String> MODIFY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ModifyStatus").getter(Cluster.getter(Cluster::modifyStatus)).setter(Cluster.setter(Builder::modifyStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModifyStatus").build()}).build();
    private static final SdkField<String> MASTER_USERNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MasterUsername").getter(Cluster.getter(Cluster::masterUsername)).setter(Cluster.setter(Builder::masterUsername)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MasterUsername").build()}).build();
    private static final SdkField<String> DB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DBName").getter(Cluster.getter(Cluster::dbName)).setter(Cluster.setter(Builder::dbName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DBName").build()}).build();
    private static final SdkField<Endpoint> ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Endpoint").getter(Cluster.getter(Cluster::endpoint)).setter(Cluster.setter(Builder::endpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Endpoint").build()}).build();
    private static final SdkField<Instant> CLUSTER_CREATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ClusterCreateTime").getter(Cluster.getter(Cluster::clusterCreateTime)).setter(Cluster.setter(Builder::clusterCreateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterCreateTime").build()}).build();
    private static final SdkField<Integer> AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("AutomatedSnapshotRetentionPeriod").getter(Cluster.getter(Cluster::automatedSnapshotRetentionPeriod)).setter(Cluster.setter(Builder::automatedSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutomatedSnapshotRetentionPeriod").build()}).build();
    private static final SdkField<Integer> MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ManualSnapshotRetentionPeriod").getter(Cluster.getter(Cluster::manualSnapshotRetentionPeriod)).setter(Cluster.setter(Builder::manualSnapshotRetentionPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManualSnapshotRetentionPeriod").build()}).build();
    private static final SdkField<List<ClusterSecurityGroupMembership>> CLUSTER_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterSecurityGroups").getter(Cluster.getter(Cluster::clusterSecurityGroups)).setter(Cluster.setter(Builder::clusterSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroups").build(), ListTrait.builder().memberLocationName("ClusterSecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<List<VpcSecurityGroupMembership>> VPC_SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VpcSecurityGroups").getter(Cluster.getter(Cluster::vpcSecurityGroups)).setter(Cluster.setter(Builder::vpcSecurityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroups").build(), ListTrait.builder().memberLocationName("VpcSecurityGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VpcSecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcSecurityGroup").build()}).build()).build()}).build();
    private static final SdkField<List<ClusterParameterGroupStatus>> CLUSTER_PARAMETER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterParameterGroups").getter(Cluster.getter(Cluster::clusterParameterGroups)).setter(Cluster.setter(Builder::clusterParameterGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroups").build(), ListTrait.builder().memberLocationName("ClusterParameterGroup").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterParameterGroupStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterGroup").build()}).build()).build()}).build();
    private static final SdkField<String> CLUSTER_SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterSubnetGroupName").getter(Cluster.getter(Cluster::clusterSubnetGroupName)).setter(Cluster.setter(Builder::clusterSubnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSubnetGroupName").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(Cluster.getter(Cluster::vpcId)).setter(Cluster.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZone").getter(Cluster.getter(Cluster::availabilityZone)).setter(Cluster.setter(Builder::availabilityZone)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()}).build();
    private static final SdkField<String> PREFERRED_MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PreferredMaintenanceWindow").getter(Cluster.getter(Cluster::preferredMaintenanceWindow)).setter(Cluster.setter(Builder::preferredMaintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredMaintenanceWindow").build()}).build();
    private static final SdkField<PendingModifiedValues> PENDING_MODIFIED_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingModifiedValues").getter(Cluster.getter(Cluster::pendingModifiedValues)).setter(Cluster.setter(Builder::pendingModifiedValues)).constructor(PendingModifiedValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingModifiedValues").build()}).build();
    private static final SdkField<String> CLUSTER_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterVersion").getter(Cluster.getter(Cluster::clusterVersion)).setter(Cluster.setter(Builder::clusterVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()}).build();
    private static final SdkField<Boolean> ALLOW_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowVersionUpgrade").getter(Cluster.getter(Cluster::allowVersionUpgrade)).setter(Cluster.setter(Builder::allowVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowVersionUpgrade").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfNodes").getter(Cluster.getter(Cluster::numberOfNodes)).setter(Cluster.setter(Builder::numberOfNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfNodes").build()}).build();
    private static final SdkField<Boolean> PUBLICLY_ACCESSIBLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("PubliclyAccessible").getter(Cluster.getter(Cluster::publiclyAccessible)).setter(Cluster.setter(Builder::publiclyAccessible)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PubliclyAccessible").build()}).build();
    private static final SdkField<Boolean> ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("Encrypted").getter(Cluster.getter(Cluster::encrypted)).setter(Cluster.setter(Builder::encrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Encrypted").build()}).build();
    private static final SdkField<RestoreStatus> RESTORE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RestoreStatus").getter(Cluster.getter(Cluster::restoreStatus)).setter(Cluster.setter(Builder::restoreStatus)).constructor(RestoreStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreStatus").build()}).build();
    private static final SdkField<DataTransferProgress> DATA_TRANSFER_PROGRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DataTransferProgress").getter(Cluster.getter(Cluster::dataTransferProgress)).setter(Cluster.setter(Builder::dataTransferProgress)).constructor(DataTransferProgress::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTransferProgress").build()}).build();
    private static final SdkField<HsmStatus> HSM_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HsmStatus").getter(Cluster.getter(Cluster::hsmStatus)).setter(Cluster.setter(Builder::hsmStatus)).constructor(HsmStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmStatus").build()}).build();
    private static final SdkField<ClusterSnapshotCopyStatus> CLUSTER_SNAPSHOT_COPY_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClusterSnapshotCopyStatus").getter(Cluster.getter(Cluster::clusterSnapshotCopyStatus)).setter(Cluster.setter(Builder::clusterSnapshotCopyStatus)).constructor(ClusterSnapshotCopyStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSnapshotCopyStatus").build()}).build();
    private static final SdkField<String> CLUSTER_PUBLIC_KEY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterPublicKey").getter(Cluster.getter(Cluster::clusterPublicKey)).setter(Cluster.setter(Builder::clusterPublicKey)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterPublicKey").build()}).build();
    private static final SdkField<List<ClusterNode>> CLUSTER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterNodes").getter(Cluster.getter(Cluster::clusterNodes)).setter(Cluster.setter(Builder::clusterNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterNode::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ElasticIpStatus> ELASTIC_IP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ElasticIpStatus").getter(Cluster.getter(Cluster::elasticIpStatus)).setter(Cluster.setter(Builder::elasticIpStatus)).constructor(ElasticIpStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticIpStatus").build()}).build();
    private static final SdkField<String> CLUSTER_REVISION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterRevisionNumber").getter(Cluster.getter(Cluster::clusterRevisionNumber)).setter(Cluster.setter(Builder::clusterRevisionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterRevisionNumber").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(Cluster.getter(Cluster::tags)).setter(Cluster.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName("Tag").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tag").build()}).build()).build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(Cluster.getter(Cluster::kmsKeyId)).setter(Cluster.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<Boolean> ENHANCED_VPC_ROUTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnhancedVpcRouting").getter(Cluster.getter(Cluster::enhancedVpcRouting)).setter(Cluster.setter(Builder::enhancedVpcRouting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnhancedVpcRouting").build()}).build();
    private static final SdkField<List<ClusterIamRole>> IAM_ROLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("IamRoles").getter(Cluster.getter(Cluster::iamRoles)).setter(Cluster.setter(Builder::iamRoles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoles").build(), ListTrait.builder().memberLocationName("ClusterIamRole").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterIamRole::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIamRole").build()}).build()).build()}).build();
    private static final SdkField<List<String>> PENDING_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("PendingActions").getter(Cluster.getter(Cluster::pendingActions)).setter(Cluster.setter(Builder::pendingActions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingActions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceTrackName").getter(Cluster.getter(Cluster::maintenanceTrackName)).setter(Cluster.setter(Builder::maintenanceTrackName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build()}).build();
    private static final SdkField<String> ELASTIC_RESIZE_NUMBER_OF_NODE_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ElasticResizeNumberOfNodeOptions").getter(Cluster.getter(Cluster::elasticResizeNumberOfNodeOptions)).setter(Cluster.setter(Builder::elasticResizeNumberOfNodeOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElasticResizeNumberOfNodeOptions").build()}).build();
    private static final SdkField<List<DeferredMaintenanceWindow>> DEFERRED_MAINTENANCE_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DeferredMaintenanceWindows").getter(Cluster.getter(Cluster::deferredMaintenanceWindows)).setter(Cluster.setter(Builder::deferredMaintenanceWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferredMaintenanceWindows").build(), ListTrait.builder().memberLocationName("DeferredMaintenanceWindow").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DeferredMaintenanceWindow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeferredMaintenanceWindow").build()}).build()).build()}).build();
    private static final SdkField<String> SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotScheduleIdentifier").getter(Cluster.getter(Cluster::snapshotScheduleIdentifier)).setter(Cluster.setter(Builder::snapshotScheduleIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotScheduleIdentifier").build()}).build();
    private static final SdkField<String> SNAPSHOT_SCHEDULE_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotScheduleState").getter(Cluster.getter(Cluster::snapshotScheduleStateAsString)).setter(Cluster.setter(Builder::snapshotScheduleState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotScheduleState").build()}).build();
    private static final SdkField<Instant> EXPECTED_NEXT_SNAPSHOT_SCHEDULE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExpectedNextSnapshotScheduleTime").getter(Cluster.getter(Cluster::expectedNextSnapshotScheduleTime)).setter(Cluster.setter(Builder::expectedNextSnapshotScheduleTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedNextSnapshotScheduleTime").build()}).build();
    private static final SdkField<String> EXPECTED_NEXT_SNAPSHOT_SCHEDULE_TIME_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExpectedNextSnapshotScheduleTimeStatus").getter(Cluster.getter(Cluster::expectedNextSnapshotScheduleTimeStatus)).setter(Cluster.setter(Builder::expectedNextSnapshotScheduleTimeStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpectedNextSnapshotScheduleTimeStatus").build()}).build();
    private static final SdkField<Instant> NEXT_MAINTENANCE_WINDOW_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("NextMaintenanceWindowStartTime").getter(Cluster.getter(Cluster::nextMaintenanceWindowStartTime)).setter(Cluster.setter(Builder::nextMaintenanceWindowStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextMaintenanceWindowStartTime").build()}).build();
    private static final SdkField<ResizeInfo> RESIZE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResizeInfo").getter(Cluster.getter(Cluster::resizeInfo)).setter(Cluster.setter(Builder::resizeInfo)).constructor(ResizeInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeInfo").build()}).build();
    private static final SdkField<String> AVAILABILITY_ZONE_RELOCATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityZoneRelocationStatus").getter(Cluster.getter(Cluster::availabilityZoneRelocationStatus)).setter(Cluster.setter(Builder::availabilityZoneRelocationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZoneRelocationStatus").build()}).build();
    private static final SdkField<String> CLUSTER_NAMESPACE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterNamespaceArn").getter(Cluster.getter(Cluster::clusterNamespaceArn)).setter(Cluster.setter(Builder::clusterNamespaceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterNamespaceArn").build()}).build();
    private static final SdkField<Long> TOTAL_STORAGE_CAPACITY_IN_MEGA_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalStorageCapacityInMegaBytes").getter(Cluster.getter(Cluster::totalStorageCapacityInMegaBytes)).setter(Cluster.setter(Builder::totalStorageCapacityInMegaBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalStorageCapacityInMegaBytes").build()}).build();
    private static final SdkField<AquaConfiguration> AQUA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AquaConfiguration").getter(Cluster.getter(Cluster::aquaConfiguration)).setter(Cluster.setter(Builder::aquaConfiguration)).constructor(AquaConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AquaConfiguration").build()}).build();
    private static final SdkField<String> DEFAULT_IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefaultIamRoleArn").getter(Cluster.getter(Cluster::defaultIamRoleArn)).setter(Cluster.setter(Builder::defaultIamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultIamRoleArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD, NODE_TYPE_FIELD, CLUSTER_STATUS_FIELD, CLUSTER_AVAILABILITY_STATUS_FIELD, MODIFY_STATUS_FIELD, MASTER_USERNAME_FIELD, DB_NAME_FIELD, ENDPOINT_FIELD, CLUSTER_CREATE_TIME_FIELD, AUTOMATED_SNAPSHOT_RETENTION_PERIOD_FIELD, MANUAL_SNAPSHOT_RETENTION_PERIOD_FIELD, CLUSTER_SECURITY_GROUPS_FIELD, VPC_SECURITY_GROUPS_FIELD, CLUSTER_PARAMETER_GROUPS_FIELD, CLUSTER_SUBNET_GROUP_NAME_FIELD, VPC_ID_FIELD, AVAILABILITY_ZONE_FIELD, PREFERRED_MAINTENANCE_WINDOW_FIELD, PENDING_MODIFIED_VALUES_FIELD, CLUSTER_VERSION_FIELD, ALLOW_VERSION_UPGRADE_FIELD, NUMBER_OF_NODES_FIELD, PUBLICLY_ACCESSIBLE_FIELD, ENCRYPTED_FIELD, RESTORE_STATUS_FIELD, DATA_TRANSFER_PROGRESS_FIELD, HSM_STATUS_FIELD, CLUSTER_SNAPSHOT_COPY_STATUS_FIELD, CLUSTER_PUBLIC_KEY_FIELD, CLUSTER_NODES_FIELD, ELASTIC_IP_STATUS_FIELD, CLUSTER_REVISION_NUMBER_FIELD, TAGS_FIELD, KMS_KEY_ID_FIELD, ENHANCED_VPC_ROUTING_FIELD, IAM_ROLES_FIELD, PENDING_ACTIONS_FIELD, MAINTENANCE_TRACK_NAME_FIELD, ELASTIC_RESIZE_NUMBER_OF_NODE_OPTIONS_FIELD, DEFERRED_MAINTENANCE_WINDOWS_FIELD, SNAPSHOT_SCHEDULE_IDENTIFIER_FIELD, SNAPSHOT_SCHEDULE_STATE_FIELD, EXPECTED_NEXT_SNAPSHOT_SCHEDULE_TIME_FIELD, EXPECTED_NEXT_SNAPSHOT_SCHEDULE_TIME_STATUS_FIELD, NEXT_MAINTENANCE_WINDOW_START_TIME_FIELD, RESIZE_INFO_FIELD, AVAILABILITY_ZONE_RELOCATION_STATUS_FIELD, CLUSTER_NAMESPACE_ARN_FIELD, TOTAL_STORAGE_CAPACITY_IN_MEGA_BYTES_FIELD, AQUA_CONFIGURATION_FIELD, DEFAULT_IAM_ROLE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String clusterIdentifier;
    private final String nodeType;
    private final String clusterStatus;
    private final String clusterAvailabilityStatus;
    private final String modifyStatus;
    private final String masterUsername;
    private final String dbName;
    private final Endpoint endpoint;
    private final Instant clusterCreateTime;
    private final Integer automatedSnapshotRetentionPeriod;
    private final Integer manualSnapshotRetentionPeriod;
    private final List<ClusterSecurityGroupMembership> clusterSecurityGroups;
    private final List<VpcSecurityGroupMembership> vpcSecurityGroups;
    private final List<ClusterParameterGroupStatus> clusterParameterGroups;
    private final String clusterSubnetGroupName;
    private final String vpcId;
    private final String availabilityZone;
    private final String preferredMaintenanceWindow;
    private final PendingModifiedValues pendingModifiedValues;
    private final String clusterVersion;
    private final Boolean allowVersionUpgrade;
    private final Integer numberOfNodes;
    private final Boolean publiclyAccessible;
    private final Boolean encrypted;
    private final RestoreStatus restoreStatus;
    private final DataTransferProgress dataTransferProgress;
    private final HsmStatus hsmStatus;
    private final ClusterSnapshotCopyStatus clusterSnapshotCopyStatus;
    private final String clusterPublicKey;
    private final List<ClusterNode> clusterNodes;
    private final ElasticIpStatus elasticIpStatus;
    private final String clusterRevisionNumber;
    private final List<Tag> tags;
    private final String kmsKeyId;
    private final Boolean enhancedVpcRouting;
    private final List<ClusterIamRole> iamRoles;
    private final List<String> pendingActions;
    private final String maintenanceTrackName;
    private final String elasticResizeNumberOfNodeOptions;
    private final List<DeferredMaintenanceWindow> deferredMaintenanceWindows;
    private final String snapshotScheduleIdentifier;
    private final String snapshotScheduleState;
    private final Instant expectedNextSnapshotScheduleTime;
    private final String expectedNextSnapshotScheduleTimeStatus;
    private final Instant nextMaintenanceWindowStartTime;
    private final ResizeInfo resizeInfo;
    private final String availabilityZoneRelocationStatus;
    private final String clusterNamespaceArn;
    private final Long totalStorageCapacityInMegaBytes;
    private final AquaConfiguration aquaConfiguration;
    private final String defaultIamRoleArn;

    private Cluster(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.nodeType = builder.nodeType;
        this.clusterStatus = builder.clusterStatus;
        this.clusterAvailabilityStatus = builder.clusterAvailabilityStatus;
        this.modifyStatus = builder.modifyStatus;
        this.masterUsername = builder.masterUsername;
        this.dbName = builder.dbName;
        this.endpoint = builder.endpoint;
        this.clusterCreateTime = builder.clusterCreateTime;
        this.automatedSnapshotRetentionPeriod = builder.automatedSnapshotRetentionPeriod;
        this.manualSnapshotRetentionPeriod = builder.manualSnapshotRetentionPeriod;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
        this.vpcSecurityGroups = builder.vpcSecurityGroups;
        this.clusterParameterGroups = builder.clusterParameterGroups;
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.vpcId = builder.vpcId;
        this.availabilityZone = builder.availabilityZone;
        this.preferredMaintenanceWindow = builder.preferredMaintenanceWindow;
        this.pendingModifiedValues = builder.pendingModifiedValues;
        this.clusterVersion = builder.clusterVersion;
        this.allowVersionUpgrade = builder.allowVersionUpgrade;
        this.numberOfNodes = builder.numberOfNodes;
        this.publiclyAccessible = builder.publiclyAccessible;
        this.encrypted = builder.encrypted;
        this.restoreStatus = builder.restoreStatus;
        this.dataTransferProgress = builder.dataTransferProgress;
        this.hsmStatus = builder.hsmStatus;
        this.clusterSnapshotCopyStatus = builder.clusterSnapshotCopyStatus;
        this.clusterPublicKey = builder.clusterPublicKey;
        this.clusterNodes = builder.clusterNodes;
        this.elasticIpStatus = builder.elasticIpStatus;
        this.clusterRevisionNumber = builder.clusterRevisionNumber;
        this.tags = builder.tags;
        this.kmsKeyId = builder.kmsKeyId;
        this.enhancedVpcRouting = builder.enhancedVpcRouting;
        this.iamRoles = builder.iamRoles;
        this.pendingActions = builder.pendingActions;
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.elasticResizeNumberOfNodeOptions = builder.elasticResizeNumberOfNodeOptions;
        this.deferredMaintenanceWindows = builder.deferredMaintenanceWindows;
        this.snapshotScheduleIdentifier = builder.snapshotScheduleIdentifier;
        this.snapshotScheduleState = builder.snapshotScheduleState;
        this.expectedNextSnapshotScheduleTime = builder.expectedNextSnapshotScheduleTime;
        this.expectedNextSnapshotScheduleTimeStatus = builder.expectedNextSnapshotScheduleTimeStatus;
        this.nextMaintenanceWindowStartTime = builder.nextMaintenanceWindowStartTime;
        this.resizeInfo = builder.resizeInfo;
        this.availabilityZoneRelocationStatus = builder.availabilityZoneRelocationStatus;
        this.clusterNamespaceArn = builder.clusterNamespaceArn;
        this.totalStorageCapacityInMegaBytes = builder.totalStorageCapacityInMegaBytes;
        this.aquaConfiguration = builder.aquaConfiguration;
        this.defaultIamRoleArn = builder.defaultIamRoleArn;
    }

    public final String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final String clusterStatus() {
        return this.clusterStatus;
    }

    public final String clusterAvailabilityStatus() {
        return this.clusterAvailabilityStatus;
    }

    public final String modifyStatus() {
        return this.modifyStatus;
    }

    public final String masterUsername() {
        return this.masterUsername;
    }

    public final String dbName() {
        return this.dbName;
    }

    public final Endpoint endpoint() {
        return this.endpoint;
    }

    public final Instant clusterCreateTime() {
        return this.clusterCreateTime;
    }

    public final Integer automatedSnapshotRetentionPeriod() {
        return this.automatedSnapshotRetentionPeriod;
    }

    public final Integer manualSnapshotRetentionPeriod() {
        return this.manualSnapshotRetentionPeriod;
    }

    public final boolean hasClusterSecurityGroups() {
        return this.clusterSecurityGroups != null && !(this.clusterSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<ClusterSecurityGroupMembership> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public final boolean hasVpcSecurityGroups() {
        return this.vpcSecurityGroups != null && !(this.vpcSecurityGroups instanceof SdkAutoConstructList);
    }

    public final List<VpcSecurityGroupMembership> vpcSecurityGroups() {
        return this.vpcSecurityGroups;
    }

    public final boolean hasClusterParameterGroups() {
        return this.clusterParameterGroups != null && !(this.clusterParameterGroups instanceof SdkAutoConstructList);
    }

    public final List<ClusterParameterGroupStatus> clusterParameterGroups() {
        return this.clusterParameterGroups;
    }

    public final String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final String availabilityZone() {
        return this.availabilityZone;
    }

    public final String preferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public final PendingModifiedValues pendingModifiedValues() {
        return this.pendingModifiedValues;
    }

    public final String clusterVersion() {
        return this.clusterVersion;
    }

    public final Boolean allowVersionUpgrade() {
        return this.allowVersionUpgrade;
    }

    public final Integer numberOfNodes() {
        return this.numberOfNodes;
    }

    public final Boolean publiclyAccessible() {
        return this.publiclyAccessible;
    }

    public final Boolean encrypted() {
        return this.encrypted;
    }

    public final RestoreStatus restoreStatus() {
        return this.restoreStatus;
    }

    public final DataTransferProgress dataTransferProgress() {
        return this.dataTransferProgress;
    }

    public final HsmStatus hsmStatus() {
        return this.hsmStatus;
    }

    public final ClusterSnapshotCopyStatus clusterSnapshotCopyStatus() {
        return this.clusterSnapshotCopyStatus;
    }

    public final String clusterPublicKey() {
        return this.clusterPublicKey;
    }

    public final boolean hasClusterNodes() {
        return this.clusterNodes != null && !(this.clusterNodes instanceof SdkAutoConstructList);
    }

    public final List<ClusterNode> clusterNodes() {
        return this.clusterNodes;
    }

    public final ElasticIpStatus elasticIpStatus() {
        return this.elasticIpStatus;
    }

    public final String clusterRevisionNumber() {
        return this.clusterRevisionNumber;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final Boolean enhancedVpcRouting() {
        return this.enhancedVpcRouting;
    }

    public final boolean hasIamRoles() {
        return this.iamRoles != null && !(this.iamRoles instanceof SdkAutoConstructList);
    }

    public final List<ClusterIamRole> iamRoles() {
        return this.iamRoles;
    }

    public final boolean hasPendingActions() {
        return this.pendingActions != null && !(this.pendingActions instanceof SdkAutoConstructList);
    }

    public final List<String> pendingActions() {
        return this.pendingActions;
    }

    public final String maintenanceTrackName() {
        return this.maintenanceTrackName;
    }

    public final String elasticResizeNumberOfNodeOptions() {
        return this.elasticResizeNumberOfNodeOptions;
    }

    public final boolean hasDeferredMaintenanceWindows() {
        return this.deferredMaintenanceWindows != null && !(this.deferredMaintenanceWindows instanceof SdkAutoConstructList);
    }

    public final List<DeferredMaintenanceWindow> deferredMaintenanceWindows() {
        return this.deferredMaintenanceWindows;
    }

    public final String snapshotScheduleIdentifier() {
        return this.snapshotScheduleIdentifier;
    }

    public final ScheduleState snapshotScheduleState() {
        return ScheduleState.fromValue(this.snapshotScheduleState);
    }

    public final String snapshotScheduleStateAsString() {
        return this.snapshotScheduleState;
    }

    public final Instant expectedNextSnapshotScheduleTime() {
        return this.expectedNextSnapshotScheduleTime;
    }

    public final String expectedNextSnapshotScheduleTimeStatus() {
        return this.expectedNextSnapshotScheduleTimeStatus;
    }

    public final Instant nextMaintenanceWindowStartTime() {
        return this.nextMaintenanceWindowStartTime;
    }

    public final ResizeInfo resizeInfo() {
        return this.resizeInfo;
    }

    public final String availabilityZoneRelocationStatus() {
        return this.availabilityZoneRelocationStatus;
    }

    public final String clusterNamespaceArn() {
        return this.clusterNamespaceArn;
    }

    public final Long totalStorageCapacityInMegaBytes() {
        return this.totalStorageCapacityInMegaBytes;
    }

    public final AquaConfiguration aquaConfiguration() {
        return this.aquaConfiguration;
    }

    public final String defaultIamRoleArn() {
        return this.defaultIamRoleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterAvailabilityStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.modifyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.masterUsername());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbName());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterCreateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.automatedSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.manualSnapshotRetentionPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterSecurityGroups() ? this.clusterSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterParameterGroups() ? this.clusterParameterGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(this.preferredMaintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingModifiedValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.publiclyAccessible());
        hashCode = 31 * hashCode + Objects.hashCode(this.encrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.restoreStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTransferProgress());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSnapshotCopyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterPublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterNodes() ? this.clusterNodes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticIpStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterRevisionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedVpcRouting());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIamRoles() ? this.iamRoles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPendingActions() ? this.pendingActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(this.elasticResizeNumberOfNodeOptions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDeferredMaintenanceWindows() ? this.deferredMaintenanceWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotScheduleIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotScheduleStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedNextSnapshotScheduleTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.expectedNextSnapshotScheduleTimeStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextMaintenanceWindowStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resizeInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityZoneRelocationStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterNamespaceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalStorageCapacityInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.aquaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultIamRoleArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.clusterStatus(), other.clusterStatus()) && Objects.equals(this.clusterAvailabilityStatus(), other.clusterAvailabilityStatus()) && Objects.equals(this.modifyStatus(), other.modifyStatus()) && Objects.equals(this.masterUsername(), other.masterUsername()) && Objects.equals(this.dbName(), other.dbName()) && Objects.equals(this.endpoint(), other.endpoint()) && Objects.equals(this.clusterCreateTime(), other.clusterCreateTime()) && Objects.equals(this.automatedSnapshotRetentionPeriod(), other.automatedSnapshotRetentionPeriod()) && Objects.equals(this.manualSnapshotRetentionPeriod(), other.manualSnapshotRetentionPeriod()) && this.hasClusterSecurityGroups() == other.hasClusterSecurityGroups() && Objects.equals(this.clusterSecurityGroups(), other.clusterSecurityGroups()) && this.hasVpcSecurityGroups() == other.hasVpcSecurityGroups() && Objects.equals(this.vpcSecurityGroups(), other.vpcSecurityGroups()) && this.hasClusterParameterGroups() == other.hasClusterParameterGroups() && Objects.equals(this.clusterParameterGroups(), other.clusterParameterGroups()) && Objects.equals(this.clusterSubnetGroupName(), other.clusterSubnetGroupName()) && Objects.equals(this.vpcId(), other.vpcId()) && Objects.equals(this.availabilityZone(), other.availabilityZone()) && Objects.equals(this.preferredMaintenanceWindow(), other.preferredMaintenanceWindow()) && Objects.equals(this.pendingModifiedValues(), other.pendingModifiedValues()) && Objects.equals(this.clusterVersion(), other.clusterVersion()) && Objects.equals(this.allowVersionUpgrade(), other.allowVersionUpgrade()) && Objects.equals(this.numberOfNodes(), other.numberOfNodes()) && Objects.equals(this.publiclyAccessible(), other.publiclyAccessible()) && Objects.equals(this.encrypted(), other.encrypted()) && Objects.equals(this.restoreStatus(), other.restoreStatus()) && Objects.equals(this.dataTransferProgress(), other.dataTransferProgress()) && Objects.equals(this.hsmStatus(), other.hsmStatus()) && Objects.equals(this.clusterSnapshotCopyStatus(), other.clusterSnapshotCopyStatus()) && Objects.equals(this.clusterPublicKey(), other.clusterPublicKey()) && this.hasClusterNodes() == other.hasClusterNodes() && Objects.equals(this.clusterNodes(), other.clusterNodes()) && Objects.equals(this.elasticIpStatus(), other.elasticIpStatus()) && Objects.equals(this.clusterRevisionNumber(), other.clusterRevisionNumber()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.enhancedVpcRouting(), other.enhancedVpcRouting()) && this.hasIamRoles() == other.hasIamRoles() && Objects.equals(this.iamRoles(), other.iamRoles()) && this.hasPendingActions() == other.hasPendingActions() && Objects.equals(this.pendingActions(), other.pendingActions()) && Objects.equals(this.maintenanceTrackName(), other.maintenanceTrackName()) && Objects.equals(this.elasticResizeNumberOfNodeOptions(), other.elasticResizeNumberOfNodeOptions()) && this.hasDeferredMaintenanceWindows() == other.hasDeferredMaintenanceWindows() && Objects.equals(this.deferredMaintenanceWindows(), other.deferredMaintenanceWindows()) && Objects.equals(this.snapshotScheduleIdentifier(), other.snapshotScheduleIdentifier()) && Objects.equals(this.snapshotScheduleStateAsString(), other.snapshotScheduleStateAsString()) && Objects.equals(this.expectedNextSnapshotScheduleTime(), other.expectedNextSnapshotScheduleTime()) && Objects.equals(this.expectedNextSnapshotScheduleTimeStatus(), other.expectedNextSnapshotScheduleTimeStatus()) && Objects.equals(this.nextMaintenanceWindowStartTime(), other.nextMaintenanceWindowStartTime()) && Objects.equals(this.resizeInfo(), other.resizeInfo()) && Objects.equals(this.availabilityZoneRelocationStatus(), other.availabilityZoneRelocationStatus()) && Objects.equals(this.clusterNamespaceArn(), other.clusterNamespaceArn()) && Objects.equals(this.totalStorageCapacityInMegaBytes(), other.totalStorageCapacityInMegaBytes()) && Objects.equals(this.aquaConfiguration(), other.aquaConfiguration()) && Objects.equals(this.defaultIamRoleArn(), other.defaultIamRoleArn());
    }

    public final String toString() {
        return ToString.builder((String)"Cluster").add("ClusterIdentifier", (Object)this.clusterIdentifier()).add("NodeType", (Object)this.nodeType()).add("ClusterStatus", (Object)this.clusterStatus()).add("ClusterAvailabilityStatus", (Object)this.clusterAvailabilityStatus()).add("ModifyStatus", (Object)this.modifyStatus()).add("MasterUsername", (Object)this.masterUsername()).add("DBName", (Object)this.dbName()).add("Endpoint", (Object)this.endpoint()).add("ClusterCreateTime", (Object)this.clusterCreateTime()).add("AutomatedSnapshotRetentionPeriod", (Object)this.automatedSnapshotRetentionPeriod()).add("ManualSnapshotRetentionPeriod", (Object)this.manualSnapshotRetentionPeriod()).add("ClusterSecurityGroups", this.hasClusterSecurityGroups() ? this.clusterSecurityGroups() : null).add("VpcSecurityGroups", this.hasVpcSecurityGroups() ? this.vpcSecurityGroups() : null).add("ClusterParameterGroups", this.hasClusterParameterGroups() ? this.clusterParameterGroups() : null).add("ClusterSubnetGroupName", (Object)this.clusterSubnetGroupName()).add("VpcId", (Object)this.vpcId()).add("AvailabilityZone", (Object)this.availabilityZone()).add("PreferredMaintenanceWindow", (Object)this.preferredMaintenanceWindow()).add("PendingModifiedValues", (Object)this.pendingModifiedValues()).add("ClusterVersion", (Object)this.clusterVersion()).add("AllowVersionUpgrade", (Object)this.allowVersionUpgrade()).add("NumberOfNodes", (Object)this.numberOfNodes()).add("PubliclyAccessible", (Object)this.publiclyAccessible()).add("Encrypted", (Object)this.encrypted()).add("RestoreStatus", (Object)this.restoreStatus()).add("DataTransferProgress", (Object)this.dataTransferProgress()).add("HsmStatus", (Object)this.hsmStatus()).add("ClusterSnapshotCopyStatus", (Object)this.clusterSnapshotCopyStatus()).add("ClusterPublicKey", (Object)this.clusterPublicKey()).add("ClusterNodes", this.hasClusterNodes() ? this.clusterNodes() : null).add("ElasticIpStatus", (Object)this.elasticIpStatus()).add("ClusterRevisionNumber", (Object)this.clusterRevisionNumber()).add("Tags", this.hasTags() ? this.tags() : null).add("KmsKeyId", (Object)this.kmsKeyId()).add("EnhancedVpcRouting", (Object)this.enhancedVpcRouting()).add("IamRoles", this.hasIamRoles() ? this.iamRoles() : null).add("PendingActions", this.hasPendingActions() ? this.pendingActions() : null).add("MaintenanceTrackName", (Object)this.maintenanceTrackName()).add("ElasticResizeNumberOfNodeOptions", (Object)this.elasticResizeNumberOfNodeOptions()).add("DeferredMaintenanceWindows", this.hasDeferredMaintenanceWindows() ? this.deferredMaintenanceWindows() : null).add("SnapshotScheduleIdentifier", (Object)this.snapshotScheduleIdentifier()).add("SnapshotScheduleState", (Object)this.snapshotScheduleStateAsString()).add("ExpectedNextSnapshotScheduleTime", (Object)this.expectedNextSnapshotScheduleTime()).add("ExpectedNextSnapshotScheduleTimeStatus", (Object)this.expectedNextSnapshotScheduleTimeStatus()).add("NextMaintenanceWindowStartTime", (Object)this.nextMaintenanceWindowStartTime()).add("ResizeInfo", (Object)this.resizeInfo()).add("AvailabilityZoneRelocationStatus", (Object)this.availabilityZoneRelocationStatus()).add("ClusterNamespaceArn", (Object)this.clusterNamespaceArn()).add("TotalStorageCapacityInMegaBytes", (Object)this.totalStorageCapacityInMegaBytes()).add("AquaConfiguration", (Object)this.aquaConfiguration()).add("DefaultIamRoleArn", (Object)this.defaultIamRoleArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.clusterIdentifier()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "ClusterStatus": {
                return Optional.ofNullable(clazz.cast(this.clusterStatus()));
            }
            case "ClusterAvailabilityStatus": {
                return Optional.ofNullable(clazz.cast(this.clusterAvailabilityStatus()));
            }
            case "ModifyStatus": {
                return Optional.ofNullable(clazz.cast(this.modifyStatus()));
            }
            case "MasterUsername": {
                return Optional.ofNullable(clazz.cast(this.masterUsername()));
            }
            case "DBName": {
                return Optional.ofNullable(clazz.cast(this.dbName()));
            }
            case "Endpoint": {
                return Optional.ofNullable(clazz.cast(this.endpoint()));
            }
            case "ClusterCreateTime": {
                return Optional.ofNullable(clazz.cast(this.clusterCreateTime()));
            }
            case "AutomatedSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.automatedSnapshotRetentionPeriod()));
            }
            case "ManualSnapshotRetentionPeriod": {
                return Optional.ofNullable(clazz.cast(this.manualSnapshotRetentionPeriod()));
            }
            case "ClusterSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.clusterSecurityGroups()));
            }
            case "VpcSecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.vpcSecurityGroups()));
            }
            case "ClusterParameterGroups": {
                return Optional.ofNullable(clazz.cast(this.clusterParameterGroups()));
            }
            case "ClusterSubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.clusterSubnetGroupName()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "AvailabilityZone": {
                return Optional.ofNullable(clazz.cast(this.availabilityZone()));
            }
            case "PreferredMaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.preferredMaintenanceWindow()));
            }
            case "PendingModifiedValues": {
                return Optional.ofNullable(clazz.cast(this.pendingModifiedValues()));
            }
            case "ClusterVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterVersion()));
            }
            case "AllowVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.allowVersionUpgrade()));
            }
            case "NumberOfNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfNodes()));
            }
            case "PubliclyAccessible": {
                return Optional.ofNullable(clazz.cast(this.publiclyAccessible()));
            }
            case "Encrypted": {
                return Optional.ofNullable(clazz.cast(this.encrypted()));
            }
            case "RestoreStatus": {
                return Optional.ofNullable(clazz.cast(this.restoreStatus()));
            }
            case "DataTransferProgress": {
                return Optional.ofNullable(clazz.cast(this.dataTransferProgress()));
            }
            case "HsmStatus": {
                return Optional.ofNullable(clazz.cast(this.hsmStatus()));
            }
            case "ClusterSnapshotCopyStatus": {
                return Optional.ofNullable(clazz.cast(this.clusterSnapshotCopyStatus()));
            }
            case "ClusterPublicKey": {
                return Optional.ofNullable(clazz.cast(this.clusterPublicKey()));
            }
            case "ClusterNodes": {
                return Optional.ofNullable(clazz.cast(this.clusterNodes()));
            }
            case "ElasticIpStatus": {
                return Optional.ofNullable(clazz.cast(this.elasticIpStatus()));
            }
            case "ClusterRevisionNumber": {
                return Optional.ofNullable(clazz.cast(this.clusterRevisionNumber()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "EnhancedVpcRouting": {
                return Optional.ofNullable(clazz.cast(this.enhancedVpcRouting()));
            }
            case "IamRoles": {
                return Optional.ofNullable(clazz.cast(this.iamRoles()));
            }
            case "PendingActions": {
                return Optional.ofNullable(clazz.cast(this.pendingActions()));
            }
            case "MaintenanceTrackName": {
                return Optional.ofNullable(clazz.cast(this.maintenanceTrackName()));
            }
            case "ElasticResizeNumberOfNodeOptions": {
                return Optional.ofNullable(clazz.cast(this.elasticResizeNumberOfNodeOptions()));
            }
            case "DeferredMaintenanceWindows": {
                return Optional.ofNullable(clazz.cast(this.deferredMaintenanceWindows()));
            }
            case "SnapshotScheduleIdentifier": {
                return Optional.ofNullable(clazz.cast(this.snapshotScheduleIdentifier()));
            }
            case "SnapshotScheduleState": {
                return Optional.ofNullable(clazz.cast(this.snapshotScheduleStateAsString()));
            }
            case "ExpectedNextSnapshotScheduleTime": {
                return Optional.ofNullable(clazz.cast(this.expectedNextSnapshotScheduleTime()));
            }
            case "ExpectedNextSnapshotScheduleTimeStatus": {
                return Optional.ofNullable(clazz.cast(this.expectedNextSnapshotScheduleTimeStatus()));
            }
            case "NextMaintenanceWindowStartTime": {
                return Optional.ofNullable(clazz.cast(this.nextMaintenanceWindowStartTime()));
            }
            case "ResizeInfo": {
                return Optional.ofNullable(clazz.cast(this.resizeInfo()));
            }
            case "AvailabilityZoneRelocationStatus": {
                return Optional.ofNullable(clazz.cast(this.availabilityZoneRelocationStatus()));
            }
            case "ClusterNamespaceArn": {
                return Optional.ofNullable(clazz.cast(this.clusterNamespaceArn()));
            }
            case "TotalStorageCapacityInMegaBytes": {
                return Optional.ofNullable(clazz.cast(this.totalStorageCapacityInMegaBytes()));
            }
            case "AquaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.aquaConfiguration()));
            }
            case "DefaultIamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.defaultIamRoleArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String nodeType;
        private String clusterStatus;
        private String clusterAvailabilityStatus;
        private String modifyStatus;
        private String masterUsername;
        private String dbName;
        private Endpoint endpoint;
        private Instant clusterCreateTime;
        private Integer automatedSnapshotRetentionPeriod;
        private Integer manualSnapshotRetentionPeriod;
        private List<ClusterSecurityGroupMembership> clusterSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<VpcSecurityGroupMembership> vpcSecurityGroups = DefaultSdkAutoConstructList.getInstance();
        private List<ClusterParameterGroupStatus> clusterParameterGroups = DefaultSdkAutoConstructList.getInstance();
        private String clusterSubnetGroupName;
        private String vpcId;
        private String availabilityZone;
        private String preferredMaintenanceWindow;
        private PendingModifiedValues pendingModifiedValues;
        private String clusterVersion;
        private Boolean allowVersionUpgrade;
        private Integer numberOfNodes;
        private Boolean publiclyAccessible;
        private Boolean encrypted;
        private RestoreStatus restoreStatus;
        private DataTransferProgress dataTransferProgress;
        private HsmStatus hsmStatus;
        private ClusterSnapshotCopyStatus clusterSnapshotCopyStatus;
        private String clusterPublicKey;
        private List<ClusterNode> clusterNodes = DefaultSdkAutoConstructList.getInstance();
        private ElasticIpStatus elasticIpStatus;
        private String clusterRevisionNumber;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String kmsKeyId;
        private Boolean enhancedVpcRouting;
        private List<ClusterIamRole> iamRoles = DefaultSdkAutoConstructList.getInstance();
        private List<String> pendingActions = DefaultSdkAutoConstructList.getInstance();
        private String maintenanceTrackName;
        private String elasticResizeNumberOfNodeOptions;
        private List<DeferredMaintenanceWindow> deferredMaintenanceWindows = DefaultSdkAutoConstructList.getInstance();
        private String snapshotScheduleIdentifier;
        private String snapshotScheduleState;
        private Instant expectedNextSnapshotScheduleTime;
        private String expectedNextSnapshotScheduleTimeStatus;
        private Instant nextMaintenanceWindowStartTime;
        private ResizeInfo resizeInfo;
        private String availabilityZoneRelocationStatus;
        private String clusterNamespaceArn;
        private Long totalStorageCapacityInMegaBytes;
        private AquaConfiguration aquaConfiguration;
        private String defaultIamRoleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.clusterIdentifier(model.clusterIdentifier);
            this.nodeType(model.nodeType);
            this.clusterStatus(model.clusterStatus);
            this.clusterAvailabilityStatus(model.clusterAvailabilityStatus);
            this.modifyStatus(model.modifyStatus);
            this.masterUsername(model.masterUsername);
            this.dbName(model.dbName);
            this.endpoint(model.endpoint);
            this.clusterCreateTime(model.clusterCreateTime);
            this.automatedSnapshotRetentionPeriod(model.automatedSnapshotRetentionPeriod);
            this.manualSnapshotRetentionPeriod(model.manualSnapshotRetentionPeriod);
            this.clusterSecurityGroups(model.clusterSecurityGroups);
            this.vpcSecurityGroups(model.vpcSecurityGroups);
            this.clusterParameterGroups(model.clusterParameterGroups);
            this.clusterSubnetGroupName(model.clusterSubnetGroupName);
            this.vpcId(model.vpcId);
            this.availabilityZone(model.availabilityZone);
            this.preferredMaintenanceWindow(model.preferredMaintenanceWindow);
            this.pendingModifiedValues(model.pendingModifiedValues);
            this.clusterVersion(model.clusterVersion);
            this.allowVersionUpgrade(model.allowVersionUpgrade);
            this.numberOfNodes(model.numberOfNodes);
            this.publiclyAccessible(model.publiclyAccessible);
            this.encrypted(model.encrypted);
            this.restoreStatus(model.restoreStatus);
            this.dataTransferProgress(model.dataTransferProgress);
            this.hsmStatus(model.hsmStatus);
            this.clusterSnapshotCopyStatus(model.clusterSnapshotCopyStatus);
            this.clusterPublicKey(model.clusterPublicKey);
            this.clusterNodes(model.clusterNodes);
            this.elasticIpStatus(model.elasticIpStatus);
            this.clusterRevisionNumber(model.clusterRevisionNumber);
            this.tags(model.tags);
            this.kmsKeyId(model.kmsKeyId);
            this.enhancedVpcRouting(model.enhancedVpcRouting);
            this.iamRoles(model.iamRoles);
            this.pendingActions(model.pendingActions);
            this.maintenanceTrackName(model.maintenanceTrackName);
            this.elasticResizeNumberOfNodeOptions(model.elasticResizeNumberOfNodeOptions);
            this.deferredMaintenanceWindows(model.deferredMaintenanceWindows);
            this.snapshotScheduleIdentifier(model.snapshotScheduleIdentifier);
            this.snapshotScheduleState(model.snapshotScheduleState);
            this.expectedNextSnapshotScheduleTime(model.expectedNextSnapshotScheduleTime);
            this.expectedNextSnapshotScheduleTimeStatus(model.expectedNextSnapshotScheduleTimeStatus);
            this.nextMaintenanceWindowStartTime(model.nextMaintenanceWindowStartTime);
            this.resizeInfo(model.resizeInfo);
            this.availabilityZoneRelocationStatus(model.availabilityZoneRelocationStatus);
            this.clusterNamespaceArn(model.clusterNamespaceArn);
            this.totalStorageCapacityInMegaBytes(model.totalStorageCapacityInMegaBytes);
            this.aquaConfiguration(model.aquaConfiguration);
            this.defaultIamRoleArn(model.defaultIamRoleArn);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        @Override
        @Transient
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        @Transient
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getClusterStatus() {
            return this.clusterStatus;
        }

        public final void setClusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
        }

        @Override
        @Transient
        public final Builder clusterStatus(String clusterStatus) {
            this.clusterStatus = clusterStatus;
            return this;
        }

        public final String getClusterAvailabilityStatus() {
            return this.clusterAvailabilityStatus;
        }

        public final void setClusterAvailabilityStatus(String clusterAvailabilityStatus) {
            this.clusterAvailabilityStatus = clusterAvailabilityStatus;
        }

        @Override
        @Transient
        public final Builder clusterAvailabilityStatus(String clusterAvailabilityStatus) {
            this.clusterAvailabilityStatus = clusterAvailabilityStatus;
            return this;
        }

        public final String getModifyStatus() {
            return this.modifyStatus;
        }

        public final void setModifyStatus(String modifyStatus) {
            this.modifyStatus = modifyStatus;
        }

        @Override
        @Transient
        public final Builder modifyStatus(String modifyStatus) {
            this.modifyStatus = modifyStatus;
            return this;
        }

        public final String getMasterUsername() {
            return this.masterUsername;
        }

        public final void setMasterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
        }

        @Override
        @Transient
        public final Builder masterUsername(String masterUsername) {
            this.masterUsername = masterUsername;
            return this;
        }

        public final String getDbName() {
            return this.dbName;
        }

        public final void setDbName(String dbName) {
            this.dbName = dbName;
        }

        @Override
        @Transient
        public final Builder dbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public final Endpoint.Builder getEndpoint() {
            return this.endpoint != null ? this.endpoint.toBuilder() : null;
        }

        public final void setEndpoint(Endpoint.BuilderImpl endpoint) {
            this.endpoint = endpoint != null ? endpoint.build() : null;
        }

        @Override
        @Transient
        public final Builder endpoint(Endpoint endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public final Instant getClusterCreateTime() {
            return this.clusterCreateTime;
        }

        public final void setClusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
        }

        @Override
        @Transient
        public final Builder clusterCreateTime(Instant clusterCreateTime) {
            this.clusterCreateTime = clusterCreateTime;
            return this;
        }

        public final Integer getAutomatedSnapshotRetentionPeriod() {
            return this.automatedSnapshotRetentionPeriod;
        }

        public final void setAutomatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
        }

        @Override
        @Transient
        public final Builder automatedSnapshotRetentionPeriod(Integer automatedSnapshotRetentionPeriod) {
            this.automatedSnapshotRetentionPeriod = automatedSnapshotRetentionPeriod;
            return this;
        }

        public final Integer getManualSnapshotRetentionPeriod() {
            return this.manualSnapshotRetentionPeriod;
        }

        public final void setManualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
        }

        @Override
        @Transient
        public final Builder manualSnapshotRetentionPeriod(Integer manualSnapshotRetentionPeriod) {
            this.manualSnapshotRetentionPeriod = manualSnapshotRetentionPeriod;
            return this;
        }

        public final List<ClusterSecurityGroupMembership.Builder> getClusterSecurityGroups() {
            List<ClusterSecurityGroupMembership.Builder> result = ClusterSecurityGroupMembershipListCopier.copyToBuilder(this.clusterSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterSecurityGroups(Collection<ClusterSecurityGroupMembership.BuilderImpl> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupMembershipListCopier.copyFromBuilder(clusterSecurityGroups);
        }

        @Override
        @Transient
        public final Builder clusterSecurityGroups(Collection<ClusterSecurityGroupMembership> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupMembershipListCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterSecurityGroups(ClusterSecurityGroupMembership ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterSecurityGroups(Consumer<ClusterSecurityGroupMembership.Builder> ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Stream.of(clusterSecurityGroups).map(c -> (ClusterSecurityGroupMembership)((ClusterSecurityGroupMembership.Builder)ClusterSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VpcSecurityGroupMembership.Builder> getVpcSecurityGroups() {
            List<VpcSecurityGroupMembership.Builder> result = VpcSecurityGroupMembershipListCopier.copyToBuilder(this.vpcSecurityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcSecurityGroups(Collection<VpcSecurityGroupMembership.BuilderImpl> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copyFromBuilder(vpcSecurityGroups);
        }

        @Override
        @Transient
        public final Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> vpcSecurityGroups) {
            this.vpcSecurityGroups = VpcSecurityGroupMembershipListCopier.copy(vpcSecurityGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcSecurityGroups(VpcSecurityGroupMembership ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Arrays.asList(vpcSecurityGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... vpcSecurityGroups) {
            this.vpcSecurityGroups(Stream.of(vpcSecurityGroups).map(c -> (VpcSecurityGroupMembership)((VpcSecurityGroupMembership.Builder)VpcSecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ClusterParameterGroupStatus.Builder> getClusterParameterGroups() {
            List<ClusterParameterGroupStatus.Builder> result = ClusterParameterGroupStatusListCopier.copyToBuilder(this.clusterParameterGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterParameterGroups(Collection<ClusterParameterGroupStatus.BuilderImpl> clusterParameterGroups) {
            this.clusterParameterGroups = ClusterParameterGroupStatusListCopier.copyFromBuilder(clusterParameterGroups);
        }

        @Override
        @Transient
        public final Builder clusterParameterGroups(Collection<ClusterParameterGroupStatus> clusterParameterGroups) {
            this.clusterParameterGroups = ClusterParameterGroupStatusListCopier.copy(clusterParameterGroups);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterParameterGroups(ClusterParameterGroupStatus ... clusterParameterGroups) {
            this.clusterParameterGroups(Arrays.asList(clusterParameterGroups));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterParameterGroups(Consumer<ClusterParameterGroupStatus.Builder> ... clusterParameterGroups) {
            this.clusterParameterGroups(Stream.of(clusterParameterGroups).map(c -> (ClusterParameterGroupStatus)((ClusterParameterGroupStatus.Builder)ClusterParameterGroupStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        @Override
        @Transient
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        @Transient
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final String getAvailabilityZone() {
            return this.availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        @Transient
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getPreferredMaintenanceWindow() {
            return this.preferredMaintenanceWindow;
        }

        public final void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        }

        @Override
        @Transient
        public final Builder preferredMaintenanceWindow(String preferredMaintenanceWindow) {
            this.preferredMaintenanceWindow = preferredMaintenanceWindow;
            return this;
        }

        public final PendingModifiedValues.Builder getPendingModifiedValues() {
            return this.pendingModifiedValues != null ? this.pendingModifiedValues.toBuilder() : null;
        }

        public final void setPendingModifiedValues(PendingModifiedValues.BuilderImpl pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues != null ? pendingModifiedValues.build() : null;
        }

        @Override
        @Transient
        public final Builder pendingModifiedValues(PendingModifiedValues pendingModifiedValues) {
            this.pendingModifiedValues = pendingModifiedValues;
            return this;
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        @Override
        @Transient
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final Boolean getAllowVersionUpgrade() {
            return this.allowVersionUpgrade;
        }

        public final void setAllowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
        }

        @Override
        @Transient
        public final Builder allowVersionUpgrade(Boolean allowVersionUpgrade) {
            this.allowVersionUpgrade = allowVersionUpgrade;
            return this;
        }

        public final Integer getNumberOfNodes() {
            return this.numberOfNodes;
        }

        public final void setNumberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
        }

        @Override
        @Transient
        public final Builder numberOfNodes(Integer numberOfNodes) {
            this.numberOfNodes = numberOfNodes;
            return this;
        }

        public final Boolean getPubliclyAccessible() {
            return this.publiclyAccessible;
        }

        public final void setPubliclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
        }

        @Override
        @Transient
        public final Builder publiclyAccessible(Boolean publiclyAccessible) {
            this.publiclyAccessible = publiclyAccessible;
            return this;
        }

        public final Boolean getEncrypted() {
            return this.encrypted;
        }

        public final void setEncrypted(Boolean encrypted) {
            this.encrypted = encrypted;
        }

        @Override
        @Transient
        public final Builder encrypted(Boolean encrypted) {
            this.encrypted = encrypted;
            return this;
        }

        public final RestoreStatus.Builder getRestoreStatus() {
            return this.restoreStatus != null ? this.restoreStatus.toBuilder() : null;
        }

        public final void setRestoreStatus(RestoreStatus.BuilderImpl restoreStatus) {
            this.restoreStatus = restoreStatus != null ? restoreStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder restoreStatus(RestoreStatus restoreStatus) {
            this.restoreStatus = restoreStatus;
            return this;
        }

        public final DataTransferProgress.Builder getDataTransferProgress() {
            return this.dataTransferProgress != null ? this.dataTransferProgress.toBuilder() : null;
        }

        public final void setDataTransferProgress(DataTransferProgress.BuilderImpl dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress != null ? dataTransferProgress.build() : null;
        }

        @Override
        @Transient
        public final Builder dataTransferProgress(DataTransferProgress dataTransferProgress) {
            this.dataTransferProgress = dataTransferProgress;
            return this;
        }

        public final HsmStatus.Builder getHsmStatus() {
            return this.hsmStatus != null ? this.hsmStatus.toBuilder() : null;
        }

        public final void setHsmStatus(HsmStatus.BuilderImpl hsmStatus) {
            this.hsmStatus = hsmStatus != null ? hsmStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder hsmStatus(HsmStatus hsmStatus) {
            this.hsmStatus = hsmStatus;
            return this;
        }

        public final ClusterSnapshotCopyStatus.Builder getClusterSnapshotCopyStatus() {
            return this.clusterSnapshotCopyStatus != null ? this.clusterSnapshotCopyStatus.toBuilder() : null;
        }

        public final void setClusterSnapshotCopyStatus(ClusterSnapshotCopyStatus.BuilderImpl clusterSnapshotCopyStatus) {
            this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus != null ? clusterSnapshotCopyStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus clusterSnapshotCopyStatus) {
            this.clusterSnapshotCopyStatus = clusterSnapshotCopyStatus;
            return this;
        }

        public final String getClusterPublicKey() {
            return this.clusterPublicKey;
        }

        public final void setClusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
        }

        @Override
        @Transient
        public final Builder clusterPublicKey(String clusterPublicKey) {
            this.clusterPublicKey = clusterPublicKey;
            return this;
        }

        public final List<ClusterNode.Builder> getClusterNodes() {
            List<ClusterNode.Builder> result = ClusterNodesListCopier.copyToBuilder(this.clusterNodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setClusterNodes(Collection<ClusterNode.BuilderImpl> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copyFromBuilder(clusterNodes);
        }

        @Override
        @Transient
        public final Builder clusterNodes(Collection<ClusterNode> clusterNodes) {
            this.clusterNodes = ClusterNodesListCopier.copy(clusterNodes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterNodes(ClusterNode ... clusterNodes) {
            this.clusterNodes(Arrays.asList(clusterNodes));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder clusterNodes(Consumer<ClusterNode.Builder> ... clusterNodes) {
            this.clusterNodes(Stream.of(clusterNodes).map(c -> (ClusterNode)((ClusterNode.Builder)ClusterNode.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ElasticIpStatus.Builder getElasticIpStatus() {
            return this.elasticIpStatus != null ? this.elasticIpStatus.toBuilder() : null;
        }

        public final void setElasticIpStatus(ElasticIpStatus.BuilderImpl elasticIpStatus) {
            this.elasticIpStatus = elasticIpStatus != null ? elasticIpStatus.build() : null;
        }

        @Override
        @Transient
        public final Builder elasticIpStatus(ElasticIpStatus elasticIpStatus) {
            this.elasticIpStatus = elasticIpStatus;
            return this;
        }

        public final String getClusterRevisionNumber() {
            return this.clusterRevisionNumber;
        }

        public final void setClusterRevisionNumber(String clusterRevisionNumber) {
            this.clusterRevisionNumber = clusterRevisionNumber;
        }

        @Override
        @Transient
        public final Builder clusterRevisionNumber(String clusterRevisionNumber) {
            this.clusterRevisionNumber = clusterRevisionNumber;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        @Transient
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final Boolean getEnhancedVpcRouting() {
            return this.enhancedVpcRouting;
        }

        public final void setEnhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
        }

        @Override
        @Transient
        public final Builder enhancedVpcRouting(Boolean enhancedVpcRouting) {
            this.enhancedVpcRouting = enhancedVpcRouting;
            return this;
        }

        public final List<ClusterIamRole.Builder> getIamRoles() {
            List<ClusterIamRole.Builder> result = ClusterIamRoleListCopier.copyToBuilder(this.iamRoles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setIamRoles(Collection<ClusterIamRole.BuilderImpl> iamRoles) {
            this.iamRoles = ClusterIamRoleListCopier.copyFromBuilder(iamRoles);
        }

        @Override
        @Transient
        public final Builder iamRoles(Collection<ClusterIamRole> iamRoles) {
            this.iamRoles = ClusterIamRoleListCopier.copy(iamRoles);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder iamRoles(ClusterIamRole ... iamRoles) {
            this.iamRoles(Arrays.asList(iamRoles));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder iamRoles(Consumer<ClusterIamRole.Builder> ... iamRoles) {
            this.iamRoles(Stream.of(iamRoles).map(c -> (ClusterIamRole)((ClusterIamRole.Builder)ClusterIamRole.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getPendingActions() {
            if (this.pendingActions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pendingActions;
        }

        public final void setPendingActions(Collection<String> pendingActions) {
            this.pendingActions = PendingActionsListCopier.copy(pendingActions);
        }

        @Override
        @Transient
        public final Builder pendingActions(Collection<String> pendingActions) {
            this.pendingActions = PendingActionsListCopier.copy(pendingActions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder pendingActions(String ... pendingActions) {
            this.pendingActions(Arrays.asList(pendingActions));
            return this;
        }

        public final String getMaintenanceTrackName() {
            return this.maintenanceTrackName;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        @Override
        @Transient
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final String getElasticResizeNumberOfNodeOptions() {
            return this.elasticResizeNumberOfNodeOptions;
        }

        public final void setElasticResizeNumberOfNodeOptions(String elasticResizeNumberOfNodeOptions) {
            this.elasticResizeNumberOfNodeOptions = elasticResizeNumberOfNodeOptions;
        }

        @Override
        @Transient
        public final Builder elasticResizeNumberOfNodeOptions(String elasticResizeNumberOfNodeOptions) {
            this.elasticResizeNumberOfNodeOptions = elasticResizeNumberOfNodeOptions;
            return this;
        }

        public final List<DeferredMaintenanceWindow.Builder> getDeferredMaintenanceWindows() {
            List<DeferredMaintenanceWindow.Builder> result = DeferredMaintenanceWindowsListCopier.copyToBuilder(this.deferredMaintenanceWindows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDeferredMaintenanceWindows(Collection<DeferredMaintenanceWindow.BuilderImpl> deferredMaintenanceWindows) {
            this.deferredMaintenanceWindows = DeferredMaintenanceWindowsListCopier.copyFromBuilder(deferredMaintenanceWindows);
        }

        @Override
        @Transient
        public final Builder deferredMaintenanceWindows(Collection<DeferredMaintenanceWindow> deferredMaintenanceWindows) {
            this.deferredMaintenanceWindows = DeferredMaintenanceWindowsListCopier.copy(deferredMaintenanceWindows);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deferredMaintenanceWindows(DeferredMaintenanceWindow ... deferredMaintenanceWindows) {
            this.deferredMaintenanceWindows(Arrays.asList(deferredMaintenanceWindows));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder deferredMaintenanceWindows(Consumer<DeferredMaintenanceWindow.Builder> ... deferredMaintenanceWindows) {
            this.deferredMaintenanceWindows(Stream.of(deferredMaintenanceWindows).map(c -> (DeferredMaintenanceWindow)((DeferredMaintenanceWindow.Builder)DeferredMaintenanceWindow.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSnapshotScheduleIdentifier() {
            return this.snapshotScheduleIdentifier;
        }

        public final void setSnapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
        }

        @Override
        @Transient
        public final Builder snapshotScheduleIdentifier(String snapshotScheduleIdentifier) {
            this.snapshotScheduleIdentifier = snapshotScheduleIdentifier;
            return this;
        }

        public final String getSnapshotScheduleState() {
            return this.snapshotScheduleState;
        }

        public final void setSnapshotScheduleState(String snapshotScheduleState) {
            this.snapshotScheduleState = snapshotScheduleState;
        }

        @Override
        @Transient
        public final Builder snapshotScheduleState(String snapshotScheduleState) {
            this.snapshotScheduleState = snapshotScheduleState;
            return this;
        }

        @Override
        @Transient
        public final Builder snapshotScheduleState(ScheduleState snapshotScheduleState) {
            this.snapshotScheduleState(snapshotScheduleState == null ? null : snapshotScheduleState.toString());
            return this;
        }

        public final Instant getExpectedNextSnapshotScheduleTime() {
            return this.expectedNextSnapshotScheduleTime;
        }

        public final void setExpectedNextSnapshotScheduleTime(Instant expectedNextSnapshotScheduleTime) {
            this.expectedNextSnapshotScheduleTime = expectedNextSnapshotScheduleTime;
        }

        @Override
        @Transient
        public final Builder expectedNextSnapshotScheduleTime(Instant expectedNextSnapshotScheduleTime) {
            this.expectedNextSnapshotScheduleTime = expectedNextSnapshotScheduleTime;
            return this;
        }

        public final String getExpectedNextSnapshotScheduleTimeStatus() {
            return this.expectedNextSnapshotScheduleTimeStatus;
        }

        public final void setExpectedNextSnapshotScheduleTimeStatus(String expectedNextSnapshotScheduleTimeStatus) {
            this.expectedNextSnapshotScheduleTimeStatus = expectedNextSnapshotScheduleTimeStatus;
        }

        @Override
        @Transient
        public final Builder expectedNextSnapshotScheduleTimeStatus(String expectedNextSnapshotScheduleTimeStatus) {
            this.expectedNextSnapshotScheduleTimeStatus = expectedNextSnapshotScheduleTimeStatus;
            return this;
        }

        public final Instant getNextMaintenanceWindowStartTime() {
            return this.nextMaintenanceWindowStartTime;
        }

        public final void setNextMaintenanceWindowStartTime(Instant nextMaintenanceWindowStartTime) {
            this.nextMaintenanceWindowStartTime = nextMaintenanceWindowStartTime;
        }

        @Override
        @Transient
        public final Builder nextMaintenanceWindowStartTime(Instant nextMaintenanceWindowStartTime) {
            this.nextMaintenanceWindowStartTime = nextMaintenanceWindowStartTime;
            return this;
        }

        public final ResizeInfo.Builder getResizeInfo() {
            return this.resizeInfo != null ? this.resizeInfo.toBuilder() : null;
        }

        public final void setResizeInfo(ResizeInfo.BuilderImpl resizeInfo) {
            this.resizeInfo = resizeInfo != null ? resizeInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder resizeInfo(ResizeInfo resizeInfo) {
            this.resizeInfo = resizeInfo;
            return this;
        }

        public final String getAvailabilityZoneRelocationStatus() {
            return this.availabilityZoneRelocationStatus;
        }

        public final void setAvailabilityZoneRelocationStatus(String availabilityZoneRelocationStatus) {
            this.availabilityZoneRelocationStatus = availabilityZoneRelocationStatus;
        }

        @Override
        @Transient
        public final Builder availabilityZoneRelocationStatus(String availabilityZoneRelocationStatus) {
            this.availabilityZoneRelocationStatus = availabilityZoneRelocationStatus;
            return this;
        }

        public final String getClusterNamespaceArn() {
            return this.clusterNamespaceArn;
        }

        public final void setClusterNamespaceArn(String clusterNamespaceArn) {
            this.clusterNamespaceArn = clusterNamespaceArn;
        }

        @Override
        @Transient
        public final Builder clusterNamespaceArn(String clusterNamespaceArn) {
            this.clusterNamespaceArn = clusterNamespaceArn;
            return this;
        }

        public final Long getTotalStorageCapacityInMegaBytes() {
            return this.totalStorageCapacityInMegaBytes;
        }

        public final void setTotalStorageCapacityInMegaBytes(Long totalStorageCapacityInMegaBytes) {
            this.totalStorageCapacityInMegaBytes = totalStorageCapacityInMegaBytes;
        }

        @Override
        @Transient
        public final Builder totalStorageCapacityInMegaBytes(Long totalStorageCapacityInMegaBytes) {
            this.totalStorageCapacityInMegaBytes = totalStorageCapacityInMegaBytes;
            return this;
        }

        public final AquaConfiguration.Builder getAquaConfiguration() {
            return this.aquaConfiguration != null ? this.aquaConfiguration.toBuilder() : null;
        }

        public final void setAquaConfiguration(AquaConfiguration.BuilderImpl aquaConfiguration) {
            this.aquaConfiguration = aquaConfiguration != null ? aquaConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder aquaConfiguration(AquaConfiguration aquaConfiguration) {
            this.aquaConfiguration = aquaConfiguration;
            return this;
        }

        public final String getDefaultIamRoleArn() {
            return this.defaultIamRoleArn;
        }

        public final void setDefaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
        }

        @Override
        @Transient
        public final Builder defaultIamRoleArn(String defaultIamRoleArn) {
            this.defaultIamRoleArn = defaultIamRoleArn;
            return this;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder clusterIdentifier(String var1);

        public Builder nodeType(String var1);

        public Builder clusterStatus(String var1);

        public Builder clusterAvailabilityStatus(String var1);

        public Builder modifyStatus(String var1);

        public Builder masterUsername(String var1);

        public Builder dbName(String var1);

        public Builder endpoint(Endpoint var1);

        default public Builder endpoint(Consumer<Endpoint.Builder> endpoint) {
            return this.endpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(endpoint)).build());
        }

        public Builder clusterCreateTime(Instant var1);

        public Builder automatedSnapshotRetentionPeriod(Integer var1);

        public Builder manualSnapshotRetentionPeriod(Integer var1);

        public Builder clusterSecurityGroups(Collection<ClusterSecurityGroupMembership> var1);

        public Builder clusterSecurityGroups(ClusterSecurityGroupMembership ... var1);

        public Builder clusterSecurityGroups(Consumer<ClusterSecurityGroupMembership.Builder> ... var1);

        public Builder vpcSecurityGroups(Collection<VpcSecurityGroupMembership> var1);

        public Builder vpcSecurityGroups(VpcSecurityGroupMembership ... var1);

        public Builder vpcSecurityGroups(Consumer<VpcSecurityGroupMembership.Builder> ... var1);

        public Builder clusterParameterGroups(Collection<ClusterParameterGroupStatus> var1);

        public Builder clusterParameterGroups(ClusterParameterGroupStatus ... var1);

        public Builder clusterParameterGroups(Consumer<ClusterParameterGroupStatus.Builder> ... var1);

        public Builder clusterSubnetGroupName(String var1);

        public Builder vpcId(String var1);

        public Builder availabilityZone(String var1);

        public Builder preferredMaintenanceWindow(String var1);

        public Builder pendingModifiedValues(PendingModifiedValues var1);

        default public Builder pendingModifiedValues(Consumer<PendingModifiedValues.Builder> pendingModifiedValues) {
            return this.pendingModifiedValues((PendingModifiedValues)((PendingModifiedValues.Builder)PendingModifiedValues.builder().applyMutation(pendingModifiedValues)).build());
        }

        public Builder clusterVersion(String var1);

        public Builder allowVersionUpgrade(Boolean var1);

        public Builder numberOfNodes(Integer var1);

        public Builder publiclyAccessible(Boolean var1);

        public Builder encrypted(Boolean var1);

        public Builder restoreStatus(RestoreStatus var1);

        default public Builder restoreStatus(Consumer<RestoreStatus.Builder> restoreStatus) {
            return this.restoreStatus((RestoreStatus)((RestoreStatus.Builder)RestoreStatus.builder().applyMutation(restoreStatus)).build());
        }

        public Builder dataTransferProgress(DataTransferProgress var1);

        default public Builder dataTransferProgress(Consumer<DataTransferProgress.Builder> dataTransferProgress) {
            return this.dataTransferProgress((DataTransferProgress)((DataTransferProgress.Builder)DataTransferProgress.builder().applyMutation(dataTransferProgress)).build());
        }

        public Builder hsmStatus(HsmStatus var1);

        default public Builder hsmStatus(Consumer<HsmStatus.Builder> hsmStatus) {
            return this.hsmStatus((HsmStatus)((HsmStatus.Builder)HsmStatus.builder().applyMutation(hsmStatus)).build());
        }

        public Builder clusterSnapshotCopyStatus(ClusterSnapshotCopyStatus var1);

        default public Builder clusterSnapshotCopyStatus(Consumer<ClusterSnapshotCopyStatus.Builder> clusterSnapshotCopyStatus) {
            return this.clusterSnapshotCopyStatus((ClusterSnapshotCopyStatus)((ClusterSnapshotCopyStatus.Builder)ClusterSnapshotCopyStatus.builder().applyMutation(clusterSnapshotCopyStatus)).build());
        }

        public Builder clusterPublicKey(String var1);

        public Builder clusterNodes(Collection<ClusterNode> var1);

        public Builder clusterNodes(ClusterNode ... var1);

        public Builder clusterNodes(Consumer<ClusterNode.Builder> ... var1);

        public Builder elasticIpStatus(ElasticIpStatus var1);

        default public Builder elasticIpStatus(Consumer<ElasticIpStatus.Builder> elasticIpStatus) {
            return this.elasticIpStatus((ElasticIpStatus)((ElasticIpStatus.Builder)ElasticIpStatus.builder().applyMutation(elasticIpStatus)).build());
        }

        public Builder clusterRevisionNumber(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder kmsKeyId(String var1);

        public Builder enhancedVpcRouting(Boolean var1);

        public Builder iamRoles(Collection<ClusterIamRole> var1);

        public Builder iamRoles(ClusterIamRole ... var1);

        public Builder iamRoles(Consumer<ClusterIamRole.Builder> ... var1);

        public Builder pendingActions(Collection<String> var1);

        public Builder pendingActions(String ... var1);

        public Builder maintenanceTrackName(String var1);

        public Builder elasticResizeNumberOfNodeOptions(String var1);

        public Builder deferredMaintenanceWindows(Collection<DeferredMaintenanceWindow> var1);

        public Builder deferredMaintenanceWindows(DeferredMaintenanceWindow ... var1);

        public Builder deferredMaintenanceWindows(Consumer<DeferredMaintenanceWindow.Builder> ... var1);

        public Builder snapshotScheduleIdentifier(String var1);

        public Builder snapshotScheduleState(String var1);

        public Builder snapshotScheduleState(ScheduleState var1);

        public Builder expectedNextSnapshotScheduleTime(Instant var1);

        public Builder expectedNextSnapshotScheduleTimeStatus(String var1);

        public Builder nextMaintenanceWindowStartTime(Instant var1);

        public Builder resizeInfo(ResizeInfo var1);

        default public Builder resizeInfo(Consumer<ResizeInfo.Builder> resizeInfo) {
            return this.resizeInfo((ResizeInfo)((ResizeInfo.Builder)ResizeInfo.builder().applyMutation(resizeInfo)).build());
        }

        public Builder availabilityZoneRelocationStatus(String var1);

        public Builder clusterNamespaceArn(String var1);

        public Builder totalStorageCapacityInMegaBytes(Long var1);

        public Builder aquaConfiguration(AquaConfiguration var1);

        default public Builder aquaConfiguration(Consumer<AquaConfiguration.Builder> aquaConfiguration) {
            return this.aquaConfiguration((AquaConfiguration)((AquaConfiguration.Builder)AquaConfiguration.builder().applyMutation(aquaConfiguration)).build());
        }

        public Builder defaultIamRoleArn(String var1);
    }
}

