/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.DataShareAssociation;
import software.amazon.awssdk.services.redshift.model.DataShareAssociationListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeauthorizeDataShareResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DeauthorizeDataShareResponse> {
    private static final SdkField<String> DATA_SHARE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataShareArn").getter(DeauthorizeDataShareResponse.getter(DeauthorizeDataShareResponse::dataShareArn)).setter(DeauthorizeDataShareResponse.setter(Builder::dataShareArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareArn").build()}).build();
    private static final SdkField<String> PRODUCER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProducerArn").getter(DeauthorizeDataShareResponse.getter(DeauthorizeDataShareResponse::producerArn)).setter(DeauthorizeDataShareResponse.setter(Builder::producerArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProducerArn").build()}).build();
    private static final SdkField<Boolean> ALLOW_PUBLICLY_ACCESSIBLE_CONSUMERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AllowPubliclyAccessibleConsumers").getter(DeauthorizeDataShareResponse.getter(DeauthorizeDataShareResponse::allowPubliclyAccessibleConsumers)).setter(DeauthorizeDataShareResponse.setter(Builder::allowPubliclyAccessibleConsumers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowPubliclyAccessibleConsumers").build()}).build();
    private static final SdkField<List<DataShareAssociation>> DATA_SHARE_ASSOCIATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataShareAssociations").getter(DeauthorizeDataShareResponse.getter(DeauthorizeDataShareResponse::dataShareAssociations)).setter(DeauthorizeDataShareResponse.setter(Builder::dataShareAssociations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataShareAssociations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataShareAssociation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MANAGED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ManagedBy").getter(DeauthorizeDataShareResponse.getter(DeauthorizeDataShareResponse::managedBy)).setter(DeauthorizeDataShareResponse.setter(Builder::managedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManagedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SHARE_ARN_FIELD, PRODUCER_ARN_FIELD, ALLOW_PUBLICLY_ACCESSIBLE_CONSUMERS_FIELD, DATA_SHARE_ASSOCIATIONS_FIELD, MANAGED_BY_FIELD));
    private final String dataShareArn;
    private final String producerArn;
    private final Boolean allowPubliclyAccessibleConsumers;
    private final List<DataShareAssociation> dataShareAssociations;
    private final String managedBy;

    private DeauthorizeDataShareResponse(BuilderImpl builder) {
        super(builder);
        this.dataShareArn = builder.dataShareArn;
        this.producerArn = builder.producerArn;
        this.allowPubliclyAccessibleConsumers = builder.allowPubliclyAccessibleConsumers;
        this.dataShareAssociations = builder.dataShareAssociations;
        this.managedBy = builder.managedBy;
    }

    public final String dataShareArn() {
        return this.dataShareArn;
    }

    public final String producerArn() {
        return this.producerArn;
    }

    public final Boolean allowPubliclyAccessibleConsumers() {
        return this.allowPubliclyAccessibleConsumers;
    }

    public final boolean hasDataShareAssociations() {
        return this.dataShareAssociations != null && !(this.dataShareAssociations instanceof SdkAutoConstructList);
    }

    public final List<DataShareAssociation> dataShareAssociations() {
        return this.dataShareAssociations;
    }

    public final String managedBy() {
        return this.managedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.dataShareArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.producerArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.allowPubliclyAccessibleConsumers());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataShareAssociations() ? this.dataShareAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.managedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeauthorizeDataShareResponse)) {
            return false;
        }
        DeauthorizeDataShareResponse other = (DeauthorizeDataShareResponse)((Object)obj);
        return Objects.equals(this.dataShareArn(), other.dataShareArn()) && Objects.equals(this.producerArn(), other.producerArn()) && Objects.equals(this.allowPubliclyAccessibleConsumers(), other.allowPubliclyAccessibleConsumers()) && this.hasDataShareAssociations() == other.hasDataShareAssociations() && Objects.equals(this.dataShareAssociations(), other.dataShareAssociations()) && Objects.equals(this.managedBy(), other.managedBy());
    }

    public final String toString() {
        return ToString.builder((String)"DeauthorizeDataShareResponse").add("DataShareArn", (Object)this.dataShareArn()).add("ProducerArn", (Object)this.producerArn()).add("AllowPubliclyAccessibleConsumers", (Object)this.allowPubliclyAccessibleConsumers()).add("DataShareAssociations", this.hasDataShareAssociations() ? this.dataShareAssociations() : null).add("ManagedBy", (Object)this.managedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DataShareArn": {
                return Optional.ofNullable(clazz.cast(this.dataShareArn()));
            }
            case "ProducerArn": {
                return Optional.ofNullable(clazz.cast(this.producerArn()));
            }
            case "AllowPubliclyAccessibleConsumers": {
                return Optional.ofNullable(clazz.cast(this.allowPubliclyAccessibleConsumers()));
            }
            case "DataShareAssociations": {
                return Optional.ofNullable(clazz.cast(this.dataShareAssociations()));
            }
            case "ManagedBy": {
                return Optional.ofNullable(clazz.cast(this.managedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeauthorizeDataShareResponse, T> g) {
        return obj -> g.apply((DeauthorizeDataShareResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String dataShareArn;
        private String producerArn;
        private Boolean allowPubliclyAccessibleConsumers;
        private List<DataShareAssociation> dataShareAssociations = DefaultSdkAutoConstructList.getInstance();
        private String managedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeauthorizeDataShareResponse model) {
            super(model);
            this.dataShareArn(model.dataShareArn);
            this.producerArn(model.producerArn);
            this.allowPubliclyAccessibleConsumers(model.allowPubliclyAccessibleConsumers);
            this.dataShareAssociations(model.dataShareAssociations);
            this.managedBy(model.managedBy);
        }

        public final String getDataShareArn() {
            return this.dataShareArn;
        }

        public final void setDataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
        }

        @Override
        @Transient
        public final Builder dataShareArn(String dataShareArn) {
            this.dataShareArn = dataShareArn;
            return this;
        }

        public final String getProducerArn() {
            return this.producerArn;
        }

        public final void setProducerArn(String producerArn) {
            this.producerArn = producerArn;
        }

        @Override
        @Transient
        public final Builder producerArn(String producerArn) {
            this.producerArn = producerArn;
            return this;
        }

        public final Boolean getAllowPubliclyAccessibleConsumers() {
            return this.allowPubliclyAccessibleConsumers;
        }

        public final void setAllowPubliclyAccessibleConsumers(Boolean allowPubliclyAccessibleConsumers) {
            this.allowPubliclyAccessibleConsumers = allowPubliclyAccessibleConsumers;
        }

        @Override
        @Transient
        public final Builder allowPubliclyAccessibleConsumers(Boolean allowPubliclyAccessibleConsumers) {
            this.allowPubliclyAccessibleConsumers = allowPubliclyAccessibleConsumers;
            return this;
        }

        public final List<DataShareAssociation.Builder> getDataShareAssociations() {
            List<DataShareAssociation.Builder> result = DataShareAssociationListCopier.copyToBuilder(this.dataShareAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataShareAssociations(Collection<DataShareAssociation.BuilderImpl> dataShareAssociations) {
            this.dataShareAssociations = DataShareAssociationListCopier.copyFromBuilder(dataShareAssociations);
        }

        @Override
        @Transient
        public final Builder dataShareAssociations(Collection<DataShareAssociation> dataShareAssociations) {
            this.dataShareAssociations = DataShareAssociationListCopier.copy(dataShareAssociations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataShareAssociations(DataShareAssociation ... dataShareAssociations) {
            this.dataShareAssociations(Arrays.asList(dataShareAssociations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder dataShareAssociations(Consumer<DataShareAssociation.Builder> ... dataShareAssociations) {
            this.dataShareAssociations(Stream.of(dataShareAssociations).map(c -> (DataShareAssociation)((DataShareAssociation.Builder)DataShareAssociation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getManagedBy() {
            return this.managedBy;
        }

        public final void setManagedBy(String managedBy) {
            this.managedBy = managedBy;
        }

        @Override
        @Transient
        public final Builder managedBy(String managedBy) {
            this.managedBy = managedBy;
            return this;
        }

        @Override
        public DeauthorizeDataShareResponse build() {
            return new DeauthorizeDataShareResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeauthorizeDataShareResponse> {
        public Builder dataShareArn(String var1);

        public Builder producerArn(String var1);

        public Builder allowPubliclyAccessibleConsumers(Boolean var1);

        public Builder dataShareAssociations(Collection<DataShareAssociation> var1);

        public Builder dataShareAssociations(DataShareAssociation ... var1);

        public Builder dataShareAssociations(Consumer<DataShareAssociation.Builder> ... var1);

        public Builder managedBy(String var1);
    }
}

