/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteHsmClientCertificateRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, DeleteHsmClientCertificateRequest> {
    private static final SdkField<String> HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HsmClientCertificateIdentifier").getter(DeleteHsmClientCertificateRequest.getter(DeleteHsmClientCertificateRequest::hsmClientCertificateIdentifier)).setter(DeleteHsmClientCertificateRequest.setter(Builder::hsmClientCertificateIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificateIdentifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HSM_CLIENT_CERTIFICATE_IDENTIFIER_FIELD));
    private final String hsmClientCertificateIdentifier;

    private DeleteHsmClientCertificateRequest(BuilderImpl builder) {
        super(builder);
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
    }

    public final String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificateIdentifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteHsmClientCertificateRequest)) {
            return false;
        }
        DeleteHsmClientCertificateRequest other = (DeleteHsmClientCertificateRequest)((Object)obj);
        return Objects.equals(this.hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteHsmClientCertificateRequest").add("HsmClientCertificateIdentifier", (Object)this.hsmClientCertificateIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmClientCertificateIdentifier": {
                return Optional.ofNullable(clazz.cast(this.hsmClientCertificateIdentifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteHsmClientCertificateRequest, T> g) {
        return obj -> g.apply((DeleteHsmClientCertificateRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String hsmClientCertificateIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteHsmClientCertificateRequest model) {
            super(model);
            this.hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteHsmClientCertificateRequest build() {
            return new DeleteHsmClientCertificateRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteHsmClientCertificateRequest> {
        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

