/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the errors returned by a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotErrorMessage implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotErrorMessage.Builder, SnapshotErrorMessage> {
    private static final SdkField<String> SNAPSHOT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotIdentifier").getter(getter(SnapshotErrorMessage::snapshotIdentifier))
            .setter(setter(Builder::snapshotIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotIdentifier").build())
            .build();

    private static final SdkField<String> SNAPSHOT_CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SnapshotClusterIdentifier").getter(getter(SnapshotErrorMessage::snapshotClusterIdentifier))
            .setter(setter(Builder::snapshotClusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotClusterIdentifier").build())
            .build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureCode").getter(getter(SnapshotErrorMessage::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureCode").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FailureReason").getter(getter(SnapshotErrorMessage::failureReason))
            .setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_IDENTIFIER_FIELD,
            SNAPSHOT_CLUSTER_IDENTIFIER_FIELD, FAILURE_CODE_FIELD, FAILURE_REASON_FIELD));

    private static final long serialVersionUID = 1L;

    private final String snapshotIdentifier;

    private final String snapshotClusterIdentifier;

    private final String failureCode;

    private final String failureReason;

    private SnapshotErrorMessage(BuilderImpl builder) {
        this.snapshotIdentifier = builder.snapshotIdentifier;
        this.snapshotClusterIdentifier = builder.snapshotClusterIdentifier;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
    }

    /**
     * <p>
     * A unique identifier for the snapshot returning the error.
     * </p>
     * 
     * @return A unique identifier for the snapshot returning the error.
     */
    public final String snapshotIdentifier() {
        return snapshotIdentifier;
    }

    /**
     * <p>
     * A unique identifier for the cluster.
     * </p>
     * 
     * @return A unique identifier for the cluster.
     */
    public final String snapshotClusterIdentifier() {
        return snapshotClusterIdentifier;
    }

    /**
     * <p>
     * The failure code for the error.
     * </p>
     * 
     * @return The failure code for the error.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * The text message describing the error.
     * </p>
     * 
     * @return The text message describing the error.
     */
    public final String failureReason() {
        return failureReason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(snapshotIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotErrorMessage)) {
            return false;
        }
        SnapshotErrorMessage other = (SnapshotErrorMessage) obj;
        return Objects.equals(snapshotIdentifier(), other.snapshotIdentifier())
                && Objects.equals(snapshotClusterIdentifier(), other.snapshotClusterIdentifier())
                && Objects.equals(failureCode(), other.failureCode()) && Objects.equals(failureReason(), other.failureReason());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotErrorMessage").add("SnapshotIdentifier", snapshotIdentifier())
                .add("SnapshotClusterIdentifier", snapshotClusterIdentifier()).add("FailureCode", failureCode())
                .add("FailureReason", failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SnapshotIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotIdentifier()));
        case "SnapshotClusterIdentifier":
            return Optional.ofNullable(clazz.cast(snapshotClusterIdentifier()));
        case "FailureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "FailureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotErrorMessage, T> g) {
        return obj -> g.apply((SnapshotErrorMessage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotErrorMessage> {
        /**
         * <p>
         * A unique identifier for the snapshot returning the error.
         * </p>
         * 
         * @param snapshotIdentifier
         *        A unique identifier for the snapshot returning the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotIdentifier(String snapshotIdentifier);

        /**
         * <p>
         * A unique identifier for the cluster.
         * </p>
         * 
         * @param snapshotClusterIdentifier
         *        A unique identifier for the cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotClusterIdentifier(String snapshotClusterIdentifier);

        /**
         * <p>
         * The failure code for the error.
         * </p>
         * 
         * @param failureCode
         *        The failure code for the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * The text message describing the error.
         * </p>
         * 
         * @param failureReason
         *        The text message describing the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);
    }

    static final class BuilderImpl implements Builder {
        private String snapshotIdentifier;

        private String snapshotClusterIdentifier;

        private String failureCode;

        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotErrorMessage model) {
            snapshotIdentifier(model.snapshotIdentifier);
            snapshotClusterIdentifier(model.snapshotClusterIdentifier);
            failureCode(model.failureCode);
            failureReason(model.failureReason);
        }

        public final String getSnapshotIdentifier() {
            return snapshotIdentifier;
        }

        @Override
        public final Builder snapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
            return this;
        }

        public final void setSnapshotIdentifier(String snapshotIdentifier) {
            this.snapshotIdentifier = snapshotIdentifier;
        }

        public final String getSnapshotClusterIdentifier() {
            return snapshotClusterIdentifier;
        }

        @Override
        public final Builder snapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
            return this;
        }

        public final void setSnapshotClusterIdentifier(String snapshotClusterIdentifier) {
            this.snapshotClusterIdentifier = snapshotClusterIdentifier;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public SnapshotErrorMessage build() {
            return new SnapshotErrorMessage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
