/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action type that specifies an Amazon Redshift API operation that is supported by the Amazon Redshift scheduler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledActionType implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledActionType.Builder, ScheduledActionType> {
    private static final SdkField<ResizeClusterMessage> RESIZE_CLUSTER_FIELD = SdkField
            .<ResizeClusterMessage> builder(MarshallingType.SDK_POJO).memberName("ResizeCluster")
            .getter(getter(ScheduledActionType::resizeCluster)).setter(setter(Builder::resizeCluster))
            .constructor(ResizeClusterMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeCluster").build()).build();

    private static final SdkField<PauseClusterMessage> PAUSE_CLUSTER_FIELD = SdkField
            .<PauseClusterMessage> builder(MarshallingType.SDK_POJO).memberName("PauseCluster")
            .getter(getter(ScheduledActionType::pauseCluster)).setter(setter(Builder::pauseCluster))
            .constructor(PauseClusterMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PauseCluster").build()).build();

    private static final SdkField<ResumeClusterMessage> RESUME_CLUSTER_FIELD = SdkField
            .<ResumeClusterMessage> builder(MarshallingType.SDK_POJO).memberName("ResumeCluster")
            .getter(getter(ScheduledActionType::resumeCluster)).setter(setter(Builder::resumeCluster))
            .constructor(ResumeClusterMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResumeCluster").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESIZE_CLUSTER_FIELD,
            PAUSE_CLUSTER_FIELD, RESUME_CLUSTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResizeClusterMessage resizeCluster;

    private final PauseClusterMessage pauseCluster;

    private final ResumeClusterMessage resumeCluster;

    private ScheduledActionType(BuilderImpl builder) {
        this.resizeCluster = builder.resizeCluster;
        this.pauseCluster = builder.pauseCluster;
        this.resumeCluster = builder.resumeCluster;
    }

    /**
     * <p>
     * An action that runs a <code>ResizeCluster</code> API operation.
     * </p>
     * 
     * @return An action that runs a <code>ResizeCluster</code> API operation.
     */
    public final ResizeClusterMessage resizeCluster() {
        return resizeCluster;
    }

    /**
     * <p>
     * An action that runs a <code>PauseCluster</code> API operation.
     * </p>
     * 
     * @return An action that runs a <code>PauseCluster</code> API operation.
     */
    public final PauseClusterMessage pauseCluster() {
        return pauseCluster;
    }

    /**
     * <p>
     * An action that runs a <code>ResumeCluster</code> API operation.
     * </p>
     * 
     * @return An action that runs a <code>ResumeCluster</code> API operation.
     */
    public final ResumeClusterMessage resumeCluster() {
        return resumeCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resizeCluster());
        hashCode = 31 * hashCode + Objects.hashCode(pauseCluster());
        hashCode = 31 * hashCode + Objects.hashCode(resumeCluster());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledActionType)) {
            return false;
        }
        ScheduledActionType other = (ScheduledActionType) obj;
        return Objects.equals(resizeCluster(), other.resizeCluster()) && Objects.equals(pauseCluster(), other.pauseCluster())
                && Objects.equals(resumeCluster(), other.resumeCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledActionType").add("ResizeCluster", resizeCluster()).add("PauseCluster", pauseCluster())
                .add("ResumeCluster", resumeCluster()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResizeCluster":
            return Optional.ofNullable(clazz.cast(resizeCluster()));
        case "PauseCluster":
            return Optional.ofNullable(clazz.cast(pauseCluster()));
        case "ResumeCluster":
            return Optional.ofNullable(clazz.cast(resumeCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledActionType, T> g) {
        return obj -> g.apply((ScheduledActionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledActionType> {
        /**
         * <p>
         * An action that runs a <code>ResizeCluster</code> API operation.
         * </p>
         * 
         * @param resizeCluster
         *        An action that runs a <code>ResizeCluster</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resizeCluster(ResizeClusterMessage resizeCluster);

        /**
         * <p>
         * An action that runs a <code>ResizeCluster</code> API operation.
         * </p>
         * This is a convenience that creates an instance of the {@link ResizeClusterMessage.Builder} avoiding the need
         * to create one manually via {@link ResizeClusterMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResizeClusterMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #resizeCluster(ResizeClusterMessage)}.
         * 
         * @param resizeCluster
         *        a consumer that will call methods on {@link ResizeClusterMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resizeCluster(ResizeClusterMessage)
         */
        default Builder resizeCluster(Consumer<ResizeClusterMessage.Builder> resizeCluster) {
            return resizeCluster(ResizeClusterMessage.builder().applyMutation(resizeCluster).build());
        }

        /**
         * <p>
         * An action that runs a <code>PauseCluster</code> API operation.
         * </p>
         * 
         * @param pauseCluster
         *        An action that runs a <code>PauseCluster</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pauseCluster(PauseClusterMessage pauseCluster);

        /**
         * <p>
         * An action that runs a <code>PauseCluster</code> API operation.
         * </p>
         * This is a convenience that creates an instance of the {@link PauseClusterMessage.Builder} avoiding the need
         * to create one manually via {@link PauseClusterMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link PauseClusterMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #pauseCluster(PauseClusterMessage)}.
         * 
         * @param pauseCluster
         *        a consumer that will call methods on {@link PauseClusterMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pauseCluster(PauseClusterMessage)
         */
        default Builder pauseCluster(Consumer<PauseClusterMessage.Builder> pauseCluster) {
            return pauseCluster(PauseClusterMessage.builder().applyMutation(pauseCluster).build());
        }

        /**
         * <p>
         * An action that runs a <code>ResumeCluster</code> API operation.
         * </p>
         * 
         * @param resumeCluster
         *        An action that runs a <code>ResumeCluster</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resumeCluster(ResumeClusterMessage resumeCluster);

        /**
         * <p>
         * An action that runs a <code>ResumeCluster</code> API operation.
         * </p>
         * This is a convenience that creates an instance of the {@link ResumeClusterMessage.Builder} avoiding the need
         * to create one manually via {@link ResumeClusterMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResumeClusterMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #resumeCluster(ResumeClusterMessage)}.
         * 
         * @param resumeCluster
         *        a consumer that will call methods on {@link ResumeClusterMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resumeCluster(ResumeClusterMessage)
         */
        default Builder resumeCluster(Consumer<ResumeClusterMessage.Builder> resumeCluster) {
            return resumeCluster(ResumeClusterMessage.builder().applyMutation(resumeCluster).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResizeClusterMessage resizeCluster;

        private PauseClusterMessage pauseCluster;

        private ResumeClusterMessage resumeCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledActionType model) {
            resizeCluster(model.resizeCluster);
            pauseCluster(model.pauseCluster);
            resumeCluster(model.resumeCluster);
        }

        public final ResizeClusterMessage.Builder getResizeCluster() {
            return resizeCluster != null ? resizeCluster.toBuilder() : null;
        }

        @Override
        public final Builder resizeCluster(ResizeClusterMessage resizeCluster) {
            this.resizeCluster = resizeCluster;
            return this;
        }

        public final void setResizeCluster(ResizeClusterMessage.BuilderImpl resizeCluster) {
            this.resizeCluster = resizeCluster != null ? resizeCluster.build() : null;
        }

        public final PauseClusterMessage.Builder getPauseCluster() {
            return pauseCluster != null ? pauseCluster.toBuilder() : null;
        }

        @Override
        public final Builder pauseCluster(PauseClusterMessage pauseCluster) {
            this.pauseCluster = pauseCluster;
            return this;
        }

        public final void setPauseCluster(PauseClusterMessage.BuilderImpl pauseCluster) {
            this.pauseCluster = pauseCluster != null ? pauseCluster.build() : null;
        }

        public final ResumeClusterMessage.Builder getResumeCluster() {
            return resumeCluster != null ? resumeCluster.toBuilder() : null;
        }

        @Override
        public final Builder resumeCluster(ResumeClusterMessage resumeCluster) {
            this.resumeCluster = resumeCluster;
            return this;
        }

        public final void setResumeCluster(ResumeClusterMessage.BuilderImpl resumeCluster) {
            this.resumeCluster = resumeCluster != null ? resumeCluster.build() : null;
        }

        @Override
        public ScheduledActionType build() {
            return new ScheduledActionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
