/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModifyClusterParameterGroupResponse extends RedshiftResponse implements
        ToCopyableBuilder<ModifyClusterParameterGroupResponse.Builder, ModifyClusterParameterGroupResponse> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupName").getter(getter(ModifyClusterParameterGroupResponse::parameterGroupName))
            .setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<String> PARAMETER_GROUP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterGroupStatus").getter(getter(ModifyClusterParameterGroupResponse::parameterGroupStatus))
            .setter(setter(Builder::parameterGroupStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD,
            PARAMETER_GROUP_STATUS_FIELD));

    private final String parameterGroupName;

    private final String parameterGroupStatus;

    private ModifyClusterParameterGroupResponse(BuilderImpl builder) {
        super(builder);
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterGroupStatus = builder.parameterGroupStatus;
    }

    /**
     * <p>
     * The name of the cluster parameter group.
     * </p>
     * 
     * @return The name of the cluster parameter group.
     */
    public final String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * <p>
     * The status of the parameter group. For example, if you made a change to a parameter group name-value pair, then
     * the change could be pending a reboot of an associated cluster.
     * </p>
     * 
     * @return The status of the parameter group. For example, if you made a change to a parameter group name-value
     *         pair, then the change could be pending a reboot of an associated cluster.
     */
    public final String parameterGroupStatus() {
        return parameterGroupStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterParameterGroupResponse)) {
            return false;
        }
        ModifyClusterParameterGroupResponse other = (ModifyClusterParameterGroupResponse) obj;
        return Objects.equals(parameterGroupName(), other.parameterGroupName())
                && Objects.equals(parameterGroupStatus(), other.parameterGroupStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ModifyClusterParameterGroupResponse").add("ParameterGroupName", parameterGroupName())
                .add("ParameterGroupStatus", parameterGroupStatus()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "ParameterGroupStatus":
            return Optional.ofNullable(clazz.cast(parameterGroupStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyClusterParameterGroupResponse, T> g) {
        return obj -> g.apply((ModifyClusterParameterGroupResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ModifyClusterParameterGroupResponse> {
        /**
         * <p>
         * The name of the cluster parameter group.
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * The status of the parameter group. For example, if you made a change to a parameter group name-value pair,
         * then the change could be pending a reboot of an associated cluster.
         * </p>
         * 
         * @param parameterGroupStatus
         *        The status of the parameter group. For example, if you made a change to a parameter group name-value
         *        pair, then the change could be pending a reboot of an associated cluster.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupStatus(String parameterGroupStatus);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String parameterGroupName;

        private String parameterGroupStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterParameterGroupResponse model) {
            super(model);
            parameterGroupName(model.parameterGroupName);
            parameterGroupStatus(model.parameterGroupStatus);
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final String getParameterGroupStatus() {
            return parameterGroupStatus;
        }

        @Override
        public final Builder parameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
            return this;
        }

        public final void setParameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
        }

        @Override
        public ModifyClusterParameterGroupResponse build() {
            return new ModifyClusterParameterGroupResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
