/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeTableRestoreStatusResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeTableRestoreStatusResponse.Builder, DescribeTableRestoreStatusResponse> {
    private static final SdkField<List<TableRestoreStatus>> TABLE_RESTORE_STATUS_DETAILS_FIELD = SdkField
            .<List<TableRestoreStatus>> builder(MarshallingType.LIST)
            .memberName("TableRestoreStatusDetails")
            .getter(getter(DescribeTableRestoreStatusResponse::tableRestoreStatusDetails))
            .setter(setter(Builder::tableRestoreStatusDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableRestoreStatusDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("TableRestoreStatus")
                            .memberFieldInfo(
                                    SdkField.<TableRestoreStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableRestoreStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("TableRestoreStatus").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeTableRestoreStatusResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TABLE_RESTORE_STATUS_DETAILS_FIELD, MARKER_FIELD));

    private final List<TableRestoreStatus> tableRestoreStatusDetails;

    private final String marker;

    private DescribeTableRestoreStatusResponse(BuilderImpl builder) {
        super(builder);
        this.tableRestoreStatusDetails = builder.tableRestoreStatusDetails;
        this.marker = builder.marker;
    }

    /**
     * Returns true if the TableRestoreStatusDetails property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasTableRestoreStatusDetails() {
        return tableRestoreStatusDetails != null && !(tableRestoreStatusDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of status details for one or more table restore requests.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTableRestoreStatusDetails()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of status details for one or more table restore requests.
     */
    public final List<TableRestoreStatus> tableRestoreStatusDetails() {
        return tableRestoreStatusDetails;
    }

    /**
     * <p>
     * A pagination token that can be used in a subsequent <a>DescribeTableRestoreStatus</a> request.
     * </p>
     * 
     * @return A pagination token that can be used in a subsequent <a>DescribeTableRestoreStatus</a> request.
     */
    public final String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTableRestoreStatusDetails() ? tableRestoreStatusDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTableRestoreStatusResponse)) {
            return false;
        }
        DescribeTableRestoreStatusResponse other = (DescribeTableRestoreStatusResponse) obj;
        return hasTableRestoreStatusDetails() == other.hasTableRestoreStatusDetails()
                && Objects.equals(tableRestoreStatusDetails(), other.tableRestoreStatusDetails())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeTableRestoreStatusResponse")
                .add("TableRestoreStatusDetails", hasTableRestoreStatusDetails() ? tableRestoreStatusDetails() : null)
                .add("Marker", marker()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TableRestoreStatusDetails":
            return Optional.ofNullable(clazz.cast(tableRestoreStatusDetails()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeTableRestoreStatusResponse, T> g) {
        return obj -> g.apply((DescribeTableRestoreStatusResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeTableRestoreStatusResponse> {
        /**
         * <p>
         * A list of status details for one or more table restore requests.
         * </p>
         * 
         * @param tableRestoreStatusDetails
         *        A list of status details for one or more table restore requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableRestoreStatusDetails(Collection<TableRestoreStatus> tableRestoreStatusDetails);

        /**
         * <p>
         * A list of status details for one or more table restore requests.
         * </p>
         * 
         * @param tableRestoreStatusDetails
         *        A list of status details for one or more table restore requests.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tableRestoreStatusDetails(TableRestoreStatus... tableRestoreStatusDetails);

        /**
         * <p>
         * A list of status details for one or more table restore requests.
         * </p>
         * This is a convenience that creates an instance of the {@link List<TableRestoreStatus>.Builder} avoiding the
         * need to create one manually via {@link List<TableRestoreStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<TableRestoreStatus>.Builder#build()} is called immediately
         * and its result is passed to {@link #tableRestoreStatusDetails(List<TableRestoreStatus>)}.
         * 
         * @param tableRestoreStatusDetails
         *        a consumer that will call methods on {@link List<TableRestoreStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tableRestoreStatusDetails(List<TableRestoreStatus>)
         */
        Builder tableRestoreStatusDetails(Consumer<TableRestoreStatus.Builder>... tableRestoreStatusDetails);

        /**
         * <p>
         * A pagination token that can be used in a subsequent <a>DescribeTableRestoreStatus</a> request.
         * </p>
         * 
         * @param marker
         *        A pagination token that can be used in a subsequent <a>DescribeTableRestoreStatus</a> request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private List<TableRestoreStatus> tableRestoreStatusDetails = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTableRestoreStatusResponse model) {
            super(model);
            tableRestoreStatusDetails(model.tableRestoreStatusDetails);
            marker(model.marker);
        }

        public final Collection<TableRestoreStatus.Builder> getTableRestoreStatusDetails() {
            if (tableRestoreStatusDetails instanceof SdkAutoConstructList) {
                return null;
            }
            return tableRestoreStatusDetails != null ? tableRestoreStatusDetails.stream().map(TableRestoreStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tableRestoreStatusDetails(Collection<TableRestoreStatus> tableRestoreStatusDetails) {
            this.tableRestoreStatusDetails = TableRestoreStatusListCopier.copy(tableRestoreStatusDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableRestoreStatusDetails(TableRestoreStatus... tableRestoreStatusDetails) {
            tableRestoreStatusDetails(Arrays.asList(tableRestoreStatusDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableRestoreStatusDetails(Consumer<TableRestoreStatus.Builder>... tableRestoreStatusDetails) {
            tableRestoreStatusDetails(Stream.of(tableRestoreStatusDetails)
                    .map(c -> TableRestoreStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTableRestoreStatusDetails(Collection<TableRestoreStatus.BuilderImpl> tableRestoreStatusDetails) {
            this.tableRestoreStatusDetails = TableRestoreStatusListCopier.copyFromBuilder(tableRestoreStatusDetails);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public DescribeTableRestoreStatusResponse build() {
            return new DescribeTableRestoreStatusResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
