/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSnapshotCopyGrantsResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeSnapshotCopyGrantsResponse.Builder, DescribeSnapshotCopyGrantsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeSnapshotCopyGrantsResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<SnapshotCopyGrant>> SNAPSHOT_COPY_GRANTS_FIELD = SdkField
            .<List<SnapshotCopyGrant>> builder(MarshallingType.LIST)
            .memberName("SnapshotCopyGrants")
            .getter(getter(DescribeSnapshotCopyGrantsResponse::snapshotCopyGrants))
            .setter(setter(Builder::snapshotCopyGrants))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotCopyGrants").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("SnapshotCopyGrant")
                            .memberFieldInfo(
                                    SdkField.<SnapshotCopyGrant> builder(MarshallingType.SDK_POJO)
                                            .constructor(SnapshotCopyGrant::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("SnapshotCopyGrant").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            SNAPSHOT_COPY_GRANTS_FIELD));

    private final String marker;

    private final List<SnapshotCopyGrant> snapshotCopyGrants;

    private DescribeSnapshotCopyGrantsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.snapshotCopyGrants = builder.snapshotCopyGrants;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set of response records. When the results of
     * a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>, AWS
     * returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response
     * records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
     * </p>
     * <p>
     * Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b> parameter,
     * but not both.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return a set of response records. When the
     *         results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in
     *         <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can
     *         retrieve the next set of response records by providing the returned marker value in the
     *         <code>Marker</code> parameter and retrying the request. </p>
     *         <p>
     *         Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b>
     *         parameter, but not both.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the SnapshotCopyGrants property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasSnapshotCopyGrants() {
        return snapshotCopyGrants != null && !(snapshotCopyGrants instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>SnapshotCopyGrant</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSnapshotCopyGrants()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of <code>SnapshotCopyGrant</code> objects.
     */
    public final List<SnapshotCopyGrant> snapshotCopyGrants() {
        return snapshotCopyGrants;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasSnapshotCopyGrants() ? snapshotCopyGrants() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSnapshotCopyGrantsResponse)) {
            return false;
        }
        DescribeSnapshotCopyGrantsResponse other = (DescribeSnapshotCopyGrantsResponse) obj;
        return Objects.equals(marker(), other.marker()) && hasSnapshotCopyGrants() == other.hasSnapshotCopyGrants()
                && Objects.equals(snapshotCopyGrants(), other.snapshotCopyGrants());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeSnapshotCopyGrantsResponse").add("Marker", marker())
                .add("SnapshotCopyGrants", hasSnapshotCopyGrants() ? snapshotCopyGrants() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "SnapshotCopyGrants":
            return Optional.ofNullable(clazz.cast(snapshotCopyGrants()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSnapshotCopyGrantsResponse, T> g) {
        return obj -> g.apply((DescribeSnapshotCopyGrantsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeSnapshotCopyGrantsResponse> {
        /**
         * <p>
         * An optional parameter that specifies the starting point to return a set of response records. When the results
         * of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in <code>MaxRecords</code>,
         * AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of
         * response records by providing the returned marker value in the <code>Marker</code> parameter and retrying the
         * request.
         * </p>
         * <p>
         * Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b>
         * parameter, but not both.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point to return a set of response records. When the
         *        results of a <code>DescribeSnapshotCopyGrant</code> request exceed the value specified in
         *        <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can
         *        retrieve the next set of response records by providing the returned marker value in the
         *        <code>Marker</code> parameter and retrying the request. </p>
         *        <p>
         *        Constraints: You can specify either the <b>SnapshotCopyGrantName</b> parameter or the <b>Marker</b>
         *        parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The list of <code>SnapshotCopyGrant</code> objects.
         * </p>
         * 
         * @param snapshotCopyGrants
         *        The list of <code>SnapshotCopyGrant</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCopyGrants(Collection<SnapshotCopyGrant> snapshotCopyGrants);

        /**
         * <p>
         * The list of <code>SnapshotCopyGrant</code> objects.
         * </p>
         * 
         * @param snapshotCopyGrants
         *        The list of <code>SnapshotCopyGrant</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotCopyGrants(SnapshotCopyGrant... snapshotCopyGrants);

        /**
         * <p>
         * The list of <code>SnapshotCopyGrant</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<SnapshotCopyGrant>.Builder} avoiding the
         * need to create one manually via {@link List<SnapshotCopyGrant>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<SnapshotCopyGrant>.Builder#build()} is called immediately
         * and its result is passed to {@link #snapshotCopyGrants(List<SnapshotCopyGrant>)}.
         * 
         * @param snapshotCopyGrants
         *        a consumer that will call methods on {@link List<SnapshotCopyGrant>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #snapshotCopyGrants(List<SnapshotCopyGrant>)
         */
        Builder snapshotCopyGrants(Consumer<SnapshotCopyGrant.Builder>... snapshotCopyGrants);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<SnapshotCopyGrant> snapshotCopyGrants = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSnapshotCopyGrantsResponse model) {
            super(model);
            marker(model.marker);
            snapshotCopyGrants(model.snapshotCopyGrants);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<SnapshotCopyGrant.Builder> getSnapshotCopyGrants() {
            if (snapshotCopyGrants instanceof SdkAutoConstructList) {
                return null;
            }
            return snapshotCopyGrants != null ? snapshotCopyGrants.stream().map(SnapshotCopyGrant::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder snapshotCopyGrants(Collection<SnapshotCopyGrant> snapshotCopyGrants) {
            this.snapshotCopyGrants = SnapshotCopyGrantListCopier.copy(snapshotCopyGrants);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyGrants(SnapshotCopyGrant... snapshotCopyGrants) {
            snapshotCopyGrants(Arrays.asList(snapshotCopyGrants));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder snapshotCopyGrants(Consumer<SnapshotCopyGrant.Builder>... snapshotCopyGrants) {
            snapshotCopyGrants(Stream.of(snapshotCopyGrants).map(c -> SnapshotCopyGrant.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setSnapshotCopyGrants(Collection<SnapshotCopyGrant.BuilderImpl> snapshotCopyGrants) {
            this.snapshotCopyGrants = SnapshotCopyGrantListCopier.copyFromBuilder(snapshotCopyGrants);
        }

        @Override
        public DescribeSnapshotCopyGrantsResponse build() {
            return new DescribeSnapshotCopyGrantsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
