/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeEventSubscriptionsRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeEventSubscriptionsRequest.Builder, DescribeEventSubscriptionsRequest> {
    private static final SdkField<String> SUBSCRIPTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubscriptionName").getter(getter(DescribeEventSubscriptionsRequest::subscriptionName))
            .setter(setter(Builder::subscriptionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubscriptionName").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxRecords").getter(getter(DescribeEventSubscriptionsRequest::maxRecords))
            .setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Marker")
            .getter(getter(DescribeEventSubscriptionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<String>> TAG_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagKeys")
            .getter(getter(DescribeEventSubscriptionsRequest::tagKeys))
            .setter(setter(Builder::tagKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("TagKey")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("TagKey").build()).build()).build()).build();

    private static final SdkField<List<String>> TAG_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TagValues")
            .getter(getter(DescribeEventSubscriptionsRequest::tagValues))
            .setter(setter(Builder::tagValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("TagValue")
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("TagValue").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUBSCRIPTION_NAME_FIELD,
            MAX_RECORDS_FIELD, MARKER_FIELD, TAG_KEYS_FIELD, TAG_VALUES_FIELD));

    private final String subscriptionName;

    private final Integer maxRecords;

    private final String marker;

    private final List<String> tagKeys;

    private final List<String> tagValues;

    private DescribeEventSubscriptionsRequest(BuilderImpl builder) {
        super(builder);
        this.subscriptionName = builder.subscriptionName;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
        this.tagKeys = builder.tagKeys;
        this.tagValues = builder.tagValues;
    }

    /**
     * <p>
     * The name of the Amazon Redshift event notification subscription to be described.
     * </p>
     * 
     * @return The name of the Amazon Redshift event notification subscription to be described.
     */
    public final String subscriptionName() {
        return subscriptionName;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the
     * response. You can retrieve the next set of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <p>
     * Constraints: minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code>
     *         field of the response. You can retrieve the next set of records by retrying the command with the returned
     *         marker value. </p>
     *         <p>
     *         Default: <code>100</code>
     *         </p>
     *         <p>
     *         Constraints: minimum 20, maximum 100.
     */
    public final Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set of response records. When the results of
     * a DescribeEventSubscriptions request exceed the value specified in <code>MaxRecords</code>, AWS returns a value
     * in the <code>Marker</code> field of the response. You can retrieve the next set of response records by providing
     * the returned marker value in the <code>Marker</code> parameter and retrying the request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return a set of response records. When the
     *         results of a DescribeEventSubscriptions request exceed the value specified in <code>MaxRecords</code>,
     *         AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of
     *         response records by providing the returned marker value in the <code>Marker</code> parameter and retrying
     *         the request.
     */
    public final String marker() {
        return marker;
    }

    /**
     * Returns true if the TagKeys property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTagKeys() {
        return tagKeys != null && !(tagKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A tag key or keys for which you want to return all matching event notification subscriptions that are associated
     * with the specified key or keys. For example, suppose that you have subscriptions that are tagged with keys called
     * <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in the request, Amazon
     * Redshift returns a response with the subscriptions that have either or both of these tag keys associated with
     * them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagKeys()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A tag key or keys for which you want to return all matching event notification subscriptions that are
     *         associated with the specified key or keys. For example, suppose that you have subscriptions that are
     *         tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag
     *         keys in the request, Amazon Redshift returns a response with the subscriptions that have either or both
     *         of these tag keys associated with them.
     */
    public final List<String> tagKeys() {
        return tagKeys;
    }

    /**
     * Returns true if the TagValues property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTagValues() {
        return tagValues != null && !(tagValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A tag value or values for which you want to return all matching event notification subscriptions that are
     * associated with the specified tag value or values. For example, suppose that you have subscriptions that are
     * tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values in
     * the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag
     * values associated with them.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTagValues()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A tag value or values for which you want to return all matching event notification subscriptions that are
     *         associated with the specified tag value or values. For example, suppose that you have subscriptions that
     *         are tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag
     *         values in the request, Amazon Redshift returns a response with the subscriptions that have either or both
     *         of these tag values associated with them.
     */
    public final List<String> tagValues() {
        return tagValues;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(subscriptionName());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagKeys() ? tagKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagValues() ? tagValues() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeEventSubscriptionsRequest)) {
            return false;
        }
        DescribeEventSubscriptionsRequest other = (DescribeEventSubscriptionsRequest) obj;
        return Objects.equals(subscriptionName(), other.subscriptionName()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker()) && hasTagKeys() == other.hasTagKeys()
                && Objects.equals(tagKeys(), other.tagKeys()) && hasTagValues() == other.hasTagValues()
                && Objects.equals(tagValues(), other.tagValues());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeEventSubscriptionsRequest").add("SubscriptionName", subscriptionName())
                .add("MaxRecords", maxRecords()).add("Marker", marker()).add("TagKeys", hasTagKeys() ? tagKeys() : null)
                .add("TagValues", hasTagValues() ? tagValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SubscriptionName":
            return Optional.ofNullable(clazz.cast(subscriptionName()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "TagKeys":
            return Optional.ofNullable(clazz.cast(tagKeys()));
        case "TagValues":
            return Optional.ofNullable(clazz.cast(tagValues()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeEventSubscriptionsRequest, T> g) {
        return obj -> g.apply((DescribeEventSubscriptionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeEventSubscriptionsRequest> {
        /**
         * <p>
         * The name of the Amazon Redshift event notification subscription to be described.
         * </p>
         * 
         * @param subscriptionName
         *        The name of the Amazon Redshift event notification subscription to be described.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subscriptionName(String subscriptionName);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of
         * the response. You can retrieve the next set of records by retrying the command with the returned marker
         * value.
         * </p>
         * <p>
         * Default: <code>100</code>
         * </p>
         * <p>
         * Constraints: minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified <code>MaxRecords</code> value, a value is returned in a
         *        <code>marker</code> field of the response. You can retrieve the next set of records by retrying the
         *        command with the returned marker value. </p>
         *        <p>
         *        Default: <code>100</code>
         *        </p>
         *        <p>
         *        Constraints: minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional parameter that specifies the starting point to return a set of response records. When the results
         * of a DescribeEventSubscriptions request exceed the value specified in <code>MaxRecords</code>, AWS returns a
         * value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by
         * providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point to return a set of response records. When the
         *        results of a DescribeEventSubscriptions request exceed the value specified in <code>MaxRecords</code>,
         *        AWS returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of
         *        response records by providing the returned marker value in the <code>Marker</code> parameter and
         *        retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * A tag key or keys for which you want to return all matching event notification subscriptions that are
         * associated with the specified key or keys. For example, suppose that you have subscriptions that are tagged
         * with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in
         * the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag
         * keys associated with them.
         * </p>
         * 
         * @param tagKeys
         *        A tag key or keys for which you want to return all matching event notification subscriptions that are
         *        associated with the specified key or keys. For example, suppose that you have subscriptions that are
         *        tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these
         *        tag keys in the request, Amazon Redshift returns a response with the subscriptions that have either or
         *        both of these tag keys associated with them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(Collection<String> tagKeys);

        /**
         * <p>
         * A tag key or keys for which you want to return all matching event notification subscriptions that are
         * associated with the specified key or keys. For example, suppose that you have subscriptions that are tagged
         * with keys called <code>owner</code> and <code>environment</code>. If you specify both of these tag keys in
         * the request, Amazon Redshift returns a response with the subscriptions that have either or both of these tag
         * keys associated with them.
         * </p>
         * 
         * @param tagKeys
         *        A tag key or keys for which you want to return all matching event notification subscriptions that are
         *        associated with the specified key or keys. For example, suppose that you have subscriptions that are
         *        tagged with keys called <code>owner</code> and <code>environment</code>. If you specify both of these
         *        tag keys in the request, Amazon Redshift returns a response with the subscriptions that have either or
         *        both of these tag keys associated with them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagKeys(String... tagKeys);

        /**
         * <p>
         * A tag value or values for which you want to return all matching event notification subscriptions that are
         * associated with the specified tag value or values. For example, suppose that you have subscriptions that are
         * tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values
         * in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these
         * tag values associated with them.
         * </p>
         * 
         * @param tagValues
         *        A tag value or values for which you want to return all matching event notification subscriptions that
         *        are associated with the specified tag value or values. For example, suppose that you have
         *        subscriptions that are tagged with values called <code>admin</code> and <code>test</code>. If you
         *        specify both of these tag values in the request, Amazon Redshift returns a response with the
         *        subscriptions that have either or both of these tag values associated with them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(Collection<String> tagValues);

        /**
         * <p>
         * A tag value or values for which you want to return all matching event notification subscriptions that are
         * associated with the specified tag value or values. For example, suppose that you have subscriptions that are
         * tagged with values called <code>admin</code> and <code>test</code>. If you specify both of these tag values
         * in the request, Amazon Redshift returns a response with the subscriptions that have either or both of these
         * tag values associated with them.
         * </p>
         * 
         * @param tagValues
         *        A tag value or values for which you want to return all matching event notification subscriptions that
         *        are associated with the specified tag value or values. For example, suppose that you have
         *        subscriptions that are tagged with values called <code>admin</code> and <code>test</code>. If you
         *        specify both of these tag values in the request, Amazon Redshift returns a response with the
         *        subscriptions that have either or both of these tag values associated with them.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagValues(String... tagValues);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String subscriptionName;

        private Integer maxRecords;

        private String marker;

        private List<String> tagKeys = DefaultSdkAutoConstructList.getInstance();

        private List<String> tagValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeEventSubscriptionsRequest model) {
            super(model);
            subscriptionName(model.subscriptionName);
            maxRecords(model.maxRecords);
            marker(model.marker);
            tagKeys(model.tagKeys);
            tagValues(model.tagValues);
        }

        public final String getSubscriptionName() {
            return subscriptionName;
        }

        @Override
        public final Builder subscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
            return this;
        }

        public final void setSubscriptionName(String subscriptionName) {
            this.subscriptionName = subscriptionName;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<String> getTagKeys() {
            if (tagKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return tagKeys;
        }

        @Override
        public final Builder tagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagKeys(String... tagKeys) {
            tagKeys(Arrays.asList(tagKeys));
            return this;
        }

        public final void setTagKeys(Collection<String> tagKeys) {
            this.tagKeys = TagKeyListCopier.copy(tagKeys);
        }

        public final Collection<String> getTagValues() {
            if (tagValues instanceof SdkAutoConstructList) {
                return null;
            }
            return tagValues;
        }

        @Override
        public final Builder tagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagValues(String... tagValues) {
            tagValues(Arrays.asList(tagValues));
            return this;
        }

        public final void setTagValues(Collection<String> tagValues) {
            this.tagValues = TagValueListCopier.copy(tagValues);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeEventSubscriptionsRequest build() {
            return new DescribeEventSubscriptionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
