/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchDeleteClusterSnapshotsRequest extends RedshiftRequest implements
        ToCopyableBuilder<BatchDeleteClusterSnapshotsRequest.Builder, BatchDeleteClusterSnapshotsRequest> {
    private static final SdkField<List<DeleteClusterSnapshotMessage>> IDENTIFIERS_FIELD = SdkField
            .<List<DeleteClusterSnapshotMessage>> builder(MarshallingType.LIST)
            .memberName("Identifiers")
            .getter(getter(BatchDeleteClusterSnapshotsRequest::identifiers))
            .setter(setter(Builder::identifiers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifiers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("DeleteClusterSnapshotMessage")
                            .memberFieldInfo(
                                    SdkField.<DeleteClusterSnapshotMessage> builder(MarshallingType.SDK_POJO)
                                            .constructor(DeleteClusterSnapshotMessage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("DeleteClusterSnapshotMessage").build()).build()).build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIERS_FIELD));

    private final List<DeleteClusterSnapshotMessage> identifiers;

    private BatchDeleteClusterSnapshotsRequest(BuilderImpl builder) {
        super(builder);
        this.identifiers = builder.identifiers;
    }

    /**
     * Returns true if the Identifiers property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasIdentifiers() {
        return identifiers != null && !(identifiers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of identifiers for the snapshots that you want to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasIdentifiers()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of identifiers for the snapshots that you want to delete.
     */
    public final List<DeleteClusterSnapshotMessage> identifiers() {
        return identifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentifiers() ? identifiers() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchDeleteClusterSnapshotsRequest)) {
            return false;
        }
        BatchDeleteClusterSnapshotsRequest other = (BatchDeleteClusterSnapshotsRequest) obj;
        return hasIdentifiers() == other.hasIdentifiers() && Objects.equals(identifiers(), other.identifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchDeleteClusterSnapshotsRequest").add("Identifiers", hasIdentifiers() ? identifiers() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Identifiers":
            return Optional.ofNullable(clazz.cast(identifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchDeleteClusterSnapshotsRequest, T> g) {
        return obj -> g.apply((BatchDeleteClusterSnapshotsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchDeleteClusterSnapshotsRequest> {
        /**
         * <p>
         * A list of identifiers for the snapshots that you want to delete.
         * </p>
         * 
         * @param identifiers
         *        A list of identifiers for the snapshots that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiers(Collection<DeleteClusterSnapshotMessage> identifiers);

        /**
         * <p>
         * A list of identifiers for the snapshots that you want to delete.
         * </p>
         * 
         * @param identifiers
         *        A list of identifiers for the snapshots that you want to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifiers(DeleteClusterSnapshotMessage... identifiers);

        /**
         * <p>
         * A list of identifiers for the snapshots that you want to delete.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DeleteClusterSnapshotMessage>.Builder}
         * avoiding the need to create one manually via {@link List<DeleteClusterSnapshotMessage>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DeleteClusterSnapshotMessage>.Builder#build()} is called
         * immediately and its result is passed to {@link #identifiers(List<DeleteClusterSnapshotMessage>)}.
         * 
         * @param identifiers
         *        a consumer that will call methods on {@link List<DeleteClusterSnapshotMessage>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #identifiers(List<DeleteClusterSnapshotMessage>)
         */
        Builder identifiers(Consumer<DeleteClusterSnapshotMessage.Builder>... identifiers);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private List<DeleteClusterSnapshotMessage> identifiers = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchDeleteClusterSnapshotsRequest model) {
            super(model);
            identifiers(model.identifiers);
        }

        public final Collection<DeleteClusterSnapshotMessage.Builder> getIdentifiers() {
            if (identifiers instanceof SdkAutoConstructList) {
                return null;
            }
            return identifiers != null ? identifiers.stream().map(DeleteClusterSnapshotMessage::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder identifiers(Collection<DeleteClusterSnapshotMessage> identifiers) {
            this.identifiers = DeleteClusterSnapshotMessageListCopier.copy(identifiers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(DeleteClusterSnapshotMessage... identifiers) {
            identifiers(Arrays.asList(identifiers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifiers(Consumer<DeleteClusterSnapshotMessage.Builder>... identifiers) {
            identifiers(Stream.of(identifiers).map(c -> DeleteClusterSnapshotMessage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setIdentifiers(Collection<DeleteClusterSnapshotMessage.BuilderImpl> identifiers) {
            this.identifiers = DeleteClusterSnapshotMessageListCopier.copyFromBuilder(identifiers);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchDeleteClusterSnapshotsRequest build() {
            return new BatchDeleteClusterSnapshotsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
