/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificate;
import software.amazon.awssdk.services.redshift.model.HsmClientCertificateListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHsmClientCertificatesResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeHsmClientCertificatesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeHsmClientCertificatesResponse.getter(DescribeHsmClientCertificatesResponse::marker)).setter(DescribeHsmClientCertificatesResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<HsmClientCertificate>> HSM_CLIENT_CERTIFICATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HsmClientCertificates").getter(DescribeHsmClientCertificatesResponse.getter(DescribeHsmClientCertificatesResponse::hsmClientCertificates)).setter(DescribeHsmClientCertificatesResponse.setter(Builder::hsmClientCertificates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificates").build(), ListTrait.builder().memberLocationName("HsmClientCertificate").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HsmClientCertificate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HsmClientCertificate").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, HSM_CLIENT_CERTIFICATES_FIELD));
    private final String marker;
    private final List<HsmClientCertificate> hsmClientCertificates;

    private DescribeHsmClientCertificatesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.hsmClientCertificates = builder.hsmClientCertificates;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasHsmClientCertificates() {
        return this.hsmClientCertificates != null && !(this.hsmClientCertificates instanceof SdkAutoConstructList);
    }

    public List<HsmClientCertificate> hsmClientCertificates() {
        return this.hsmClientCertificates;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHsmClientCertificates() ? this.hsmClientCertificates() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHsmClientCertificatesResponse)) {
            return false;
        }
        DescribeHsmClientCertificatesResponse other = (DescribeHsmClientCertificatesResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasHsmClientCertificates() == other.hasHsmClientCertificates() && Objects.equals(this.hsmClientCertificates(), other.hsmClientCertificates());
    }

    public String toString() {
        return ToString.builder((String)"DescribeHsmClientCertificatesResponse").add("Marker", (Object)this.marker()).add("HsmClientCertificates", this.hasHsmClientCertificates() ? this.hsmClientCertificates() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "HsmClientCertificates": {
                return Optional.ofNullable(clazz.cast(this.hsmClientCertificates()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHsmClientCertificatesResponse, T> g) {
        return obj -> g.apply((DescribeHsmClientCertificatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<HsmClientCertificate> hsmClientCertificates = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHsmClientCertificatesResponse model) {
            super(model);
            this.marker(model.marker);
            this.hsmClientCertificates(model.hsmClientCertificates);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<HsmClientCertificate.Builder> getHsmClientCertificates() {
            if (this.hsmClientCertificates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.hsmClientCertificates != null ? (Collection)this.hsmClientCertificates.stream().map(HsmClientCertificate::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder hsmClientCertificates(Collection<HsmClientCertificate> hsmClientCertificates) {
            this.hsmClientCertificates = HsmClientCertificateListCopier.copy(hsmClientCertificates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmClientCertificates(HsmClientCertificate ... hsmClientCertificates) {
            this.hsmClientCertificates(Arrays.asList(hsmClientCertificates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hsmClientCertificates(Consumer<HsmClientCertificate.Builder> ... hsmClientCertificates) {
            this.hsmClientCertificates(Stream.of(hsmClientCertificates).map(c -> (HsmClientCertificate)((HsmClientCertificate.Builder)HsmClientCertificate.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setHsmClientCertificates(Collection<HsmClientCertificate.BuilderImpl> hsmClientCertificates) {
            this.hsmClientCertificates = HsmClientCertificateListCopier.copyFromBuilder(hsmClientCertificates);
        }

        @Override
        public DescribeHsmClientCertificatesResponse build() {
            return new DescribeHsmClientCertificatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHsmClientCertificatesResponse> {
        public Builder marker(String var1);

        public Builder hsmClientCertificates(Collection<HsmClientCertificate> var1);

        public Builder hsmClientCertificates(HsmClientCertificate ... var1);

        public Builder hsmClientCertificates(Consumer<HsmClientCertificate.Builder> ... var1);
    }
}

