/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.ClusterVersion;
import software.amazon.awssdk.services.redshift.model.ClusterVersionListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterVersionsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterVersionsResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Marker").getter(DescribeClusterVersionsResponse.getter(DescribeClusterVersionsResponse::marker)).setter(DescribeClusterVersionsResponse.setter(Builder::marker)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()}).build();
    private static final SdkField<List<ClusterVersion>> CLUSTER_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ClusterVersions").getter(DescribeClusterVersionsResponse.getter(DescribeClusterVersionsResponse::clusterVersions)).setter(DescribeClusterVersionsResponse.setter(Builder::clusterVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersions").build(), ListTrait.builder().memberLocationName("ClusterVersion").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterVersion").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD, CLUSTER_VERSIONS_FIELD));
    private final String marker;
    private final List<ClusterVersion> clusterVersions;

    private DescribeClusterVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterVersions = builder.clusterVersions;
    }

    public String marker() {
        return this.marker;
    }

    public boolean hasClusterVersions() {
        return this.clusterVersions != null && !(this.clusterVersions instanceof SdkAutoConstructList);
    }

    public List<ClusterVersion> clusterVersions() {
        return this.clusterVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasClusterVersions() ? this.clusterVersions() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterVersionsResponse)) {
            return false;
        }
        DescribeClusterVersionsResponse other = (DescribeClusterVersionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && this.hasClusterVersions() == other.hasClusterVersions() && Objects.equals(this.clusterVersions(), other.clusterVersions());
    }

    public String toString() {
        return ToString.builder((String)"DescribeClusterVersionsResponse").add("Marker", (Object)this.marker()).add("ClusterVersions", this.hasClusterVersions() ? this.clusterVersions() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.ofNullable(clazz.cast(this.marker()));
            }
            case "ClusterVersions": {
                return Optional.ofNullable(clazz.cast(this.clusterVersions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterVersionsResponse, T> g) {
        return obj -> g.apply((DescribeClusterVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterVersion> clusterVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterVersionsResponse model) {
            super(model);
            this.marker(model.marker);
            this.clusterVersions(model.clusterVersions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterVersion.Builder> getClusterVersions() {
            if (this.clusterVersions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.clusterVersions != null ? (Collection)this.clusterVersions.stream().map(ClusterVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterVersions(Collection<ClusterVersion> clusterVersions) {
            this.clusterVersions = ClusterVersionListCopier.copy(clusterVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterVersions(ClusterVersion ... clusterVersions) {
            this.clusterVersions(Arrays.asList(clusterVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterVersions(Consumer<ClusterVersion.Builder> ... clusterVersions) {
            this.clusterVersions(Stream.of(clusterVersions).map(c -> (ClusterVersion)((ClusterVersion.Builder)ClusterVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterVersions(Collection<ClusterVersion.BuilderImpl> clusterVersions) {
            this.clusterVersions = ClusterVersionListCopier.copyFromBuilder(clusterVersions);
        }

        @Override
        public DescribeClusterVersionsResponse build() {
            return new DescribeClusterVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterVersionsResponse> {
        public Builder marker(String var1);

        public Builder clusterVersions(Collection<ClusterVersion> var1);

        public Builder clusterVersions(ClusterVersion ... var1);

        public Builder clusterVersions(Consumer<ClusterVersion.Builder> ... var1);
    }
}

