/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a parameter group.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ClusterParameterGroupStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ClusterParameterGroupStatus.Builder, ClusterParameterGroupStatus> {
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterParameterGroupStatus::parameterGroupName)).setter(setter(Builder::parameterGroupName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build())
            .build();

    private static final SdkField<String> PARAMETER_APPLY_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ClusterParameterGroupStatus::parameterApplyStatus)).setter(setter(Builder::parameterApplyStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterApplyStatus").build())
            .build();

    private static final SdkField<List<ClusterParameterStatus>> CLUSTER_PARAMETER_STATUS_LIST_FIELD = SdkField
            .<List<ClusterParameterStatus>> builder(MarshallingType.LIST)
            .getter(getter(ClusterParameterGroupStatus::clusterParameterStatusList))
            .setter(setter(Builder::clusterParameterStatusList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterParameterStatusList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ClusterParameterStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(ClusterParameterStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_GROUP_NAME_FIELD,
            PARAMETER_APPLY_STATUS_FIELD, CLUSTER_PARAMETER_STATUS_LIST_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterGroupName;

    private final String parameterApplyStatus;

    private final List<ClusterParameterStatus> clusterParameterStatusList;

    private ClusterParameterGroupStatus(BuilderImpl builder) {
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterApplyStatus = builder.parameterApplyStatus;
        this.clusterParameterStatusList = builder.clusterParameterStatusList;
    }

    /**
     * <p>
     * The name of the cluster parameter group.
     * </p>
     * 
     * @return The name of the cluster parameter group.
     */
    public String parameterGroupName() {
        return parameterGroupName;
    }

    /**
     * <p>
     * The status of parameter updates.
     * </p>
     * 
     * @return The status of parameter updates.
     */
    public String parameterApplyStatus() {
        return parameterApplyStatus;
    }

    /**
     * Returns true if the ClusterParameterStatusList property was specified by the sender (it may be empty), or false
     * if the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the
     * AWS service.
     */
    public boolean hasClusterParameterStatusList() {
        return clusterParameterStatusList != null && !(clusterParameterStatusList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of parameter statuses.
     * </p>
     * <p>
     * For more information about parameters and parameter groups, go to <a
     * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
     * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasClusterParameterStatusList()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of parameter statuses.</p>
     *         <p>
     *         For more information about parameters and parameter groups, go to <a
     *         href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon
     *         Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
     */
    public List<ClusterParameterStatus> clusterParameterStatusList() {
        return clusterParameterStatusList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(parameterApplyStatus());
        hashCode = 31 * hashCode + Objects.hashCode(clusterParameterStatusList());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterParameterGroupStatus)) {
            return false;
        }
        ClusterParameterGroupStatus other = (ClusterParameterGroupStatus) obj;
        return Objects.equals(parameterGroupName(), other.parameterGroupName())
                && Objects.equals(parameterApplyStatus(), other.parameterApplyStatus())
                && Objects.equals(clusterParameterStatusList(), other.clusterParameterStatusList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ClusterParameterGroupStatus").add("ParameterGroupName", parameterGroupName())
                .add("ParameterApplyStatus", parameterApplyStatus())
                .add("ClusterParameterStatusList", clusterParameterStatusList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterGroupName":
            return Optional.ofNullable(clazz.cast(parameterGroupName()));
        case "ParameterApplyStatus":
            return Optional.ofNullable(clazz.cast(parameterApplyStatus()));
        case "ClusterParameterStatusList":
            return Optional.ofNullable(clazz.cast(clusterParameterStatusList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterParameterGroupStatus, T> g) {
        return obj -> g.apply((ClusterParameterGroupStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ClusterParameterGroupStatus> {
        /**
         * <p>
         * The name of the cluster parameter group.
         * </p>
         * 
         * @param parameterGroupName
         *        The name of the cluster parameter group.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterGroupName(String parameterGroupName);

        /**
         * <p>
         * The status of parameter updates.
         * </p>
         * 
         * @param parameterApplyStatus
         *        The status of parameter updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterApplyStatus(String parameterApplyStatus);

        /**
         * <p>
         * The list of parameter statuses.
         * </p>
         * <p>
         * For more information about parameters and parameter groups, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
         * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * </p>
         * 
         * @param clusterParameterStatusList
         *        The list of parameter statuses.</p>
         *        <p>
         *        For more information about parameters and parameter groups, go to <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon
         *        Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterStatusList(Collection<ClusterParameterStatus> clusterParameterStatusList);

        /**
         * <p>
         * The list of parameter statuses.
         * </p>
         * <p>
         * For more information about parameters and parameter groups, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
         * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * </p>
         * 
         * @param clusterParameterStatusList
         *        The list of parameter statuses.</p>
         *        <p>
         *        For more information about parameters and parameter groups, go to <a
         *        href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon
         *        Redshift Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterParameterStatusList(ClusterParameterStatus... clusterParameterStatusList);

        /**
         * <p>
         * The list of parameter statuses.
         * </p>
         * <p>
         * For more information about parameters and parameter groups, go to <a
         * href="https://docs.aws.amazon.com/redshift/latest/mgmt/working-with-parameter-groups.html">Amazon Redshift
         * Parameter Groups</a> in the <i>Amazon Redshift Cluster Management Guide</i>.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ClusterParameterStatus>.Builder} avoiding
         * the need to create one manually via {@link List<ClusterParameterStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ClusterParameterStatus>.Builder#build()} is called
         * immediately and its result is passed to {@link #clusterParameterStatusList(List<ClusterParameterStatus>)}.
         * 
         * @param clusterParameterStatusList
         *        a consumer that will call methods on {@link List<ClusterParameterStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #clusterParameterStatusList(List<ClusterParameterStatus>)
         */
        Builder clusterParameterStatusList(Consumer<ClusterParameterStatus.Builder>... clusterParameterStatusList);
    }

    static final class BuilderImpl implements Builder {
        private String parameterGroupName;

        private String parameterApplyStatus;

        private List<ClusterParameterStatus> clusterParameterStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterParameterGroupStatus model) {
            parameterGroupName(model.parameterGroupName);
            parameterApplyStatus(model.parameterApplyStatus);
            clusterParameterStatusList(model.clusterParameterStatusList);
        }

        public final String getParameterGroupName() {
            return parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        public final String getParameterApplyStatus() {
            return parameterApplyStatus;
        }

        @Override
        public final Builder parameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
            return this;
        }

        public final void setParameterApplyStatus(String parameterApplyStatus) {
            this.parameterApplyStatus = parameterApplyStatus;
        }

        public final Collection<ClusterParameterStatus.Builder> getClusterParameterStatusList() {
            return clusterParameterStatusList != null ? clusterParameterStatusList.stream()
                    .map(ClusterParameterStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterParameterStatusList(Collection<ClusterParameterStatus> clusterParameterStatusList) {
            this.clusterParameterStatusList = ClusterParameterStatusListCopier.copy(clusterParameterStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterStatusList(ClusterParameterStatus... clusterParameterStatusList) {
            clusterParameterStatusList(Arrays.asList(clusterParameterStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterParameterStatusList(Consumer<ClusterParameterStatus.Builder>... clusterParameterStatusList) {
            clusterParameterStatusList(Stream.of(clusterParameterStatusList)
                    .map(c -> ClusterParameterStatus.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setClusterParameterStatusList(Collection<ClusterParameterStatus.BuilderImpl> clusterParameterStatusList) {
            this.clusterParameterStatusList = ClusterParameterStatusListCopier.copyFromBuilder(clusterParameterStatusList);
        }

        @Override
        public ClusterParameterGroupStatus build() {
            return new ClusterParameterGroupStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
