/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action type that specifies an Amazon Redshift API operation that is supported by the Amazon Redshift scheduler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledActionType implements SdkPojo, Serializable,
        ToCopyableBuilder<ScheduledActionType.Builder, ScheduledActionType> {
    private static final SdkField<ResizeClusterMessage> RESIZE_CLUSTER_FIELD = SdkField
            .<ResizeClusterMessage> builder(MarshallingType.SDK_POJO).getter(getter(ScheduledActionType::resizeCluster))
            .setter(setter(Builder::resizeCluster)).constructor(ResizeClusterMessage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResizeCluster").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESIZE_CLUSTER_FIELD));

    private static final long serialVersionUID = 1L;

    private final ResizeClusterMessage resizeCluster;

    private ScheduledActionType(BuilderImpl builder) {
        this.resizeCluster = builder.resizeCluster;
    }

    /**
     * <p>
     * An action that runs a <code>ResizeCluster</code> API operation.
     * </p>
     * 
     * @return An action that runs a <code>ResizeCluster</code> API operation.
     */
    public ResizeClusterMessage resizeCluster() {
        return resizeCluster;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resizeCluster());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledActionType)) {
            return false;
        }
        ScheduledActionType other = (ScheduledActionType) obj;
        return Objects.equals(resizeCluster(), other.resizeCluster());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ScheduledActionType").add("ResizeCluster", resizeCluster()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResizeCluster":
            return Optional.ofNullable(clazz.cast(resizeCluster()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScheduledActionType, T> g) {
        return obj -> g.apply((ScheduledActionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledActionType> {
        /**
         * <p>
         * An action that runs a <code>ResizeCluster</code> API operation.
         * </p>
         * 
         * @param resizeCluster
         *        An action that runs a <code>ResizeCluster</code> API operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resizeCluster(ResizeClusterMessage resizeCluster);

        /**
         * <p>
         * An action that runs a <code>ResizeCluster</code> API operation.
         * </p>
         * This is a convenience that creates an instance of the {@link ResizeClusterMessage.Builder} avoiding the need
         * to create one manually via {@link ResizeClusterMessage#builder()}.
         *
         * When the {@link Consumer} completes, {@link ResizeClusterMessage.Builder#build()} is called immediately and
         * its result is passed to {@link #resizeCluster(ResizeClusterMessage)}.
         * 
         * @param resizeCluster
         *        a consumer that will call methods on {@link ResizeClusterMessage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resizeCluster(ResizeClusterMessage)
         */
        default Builder resizeCluster(Consumer<ResizeClusterMessage.Builder> resizeCluster) {
            return resizeCluster(ResizeClusterMessage.builder().applyMutation(resizeCluster).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResizeClusterMessage resizeCluster;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledActionType model) {
            resizeCluster(model.resizeCluster);
        }

        public final ResizeClusterMessage.Builder getResizeCluster() {
            return resizeCluster != null ? resizeCluster.toBuilder() : null;
        }

        @Override
        public final Builder resizeCluster(ResizeClusterMessage resizeCluster) {
            this.resizeCluster = resizeCluster;
            return this;
        }

        public final void setResizeCluster(ResizeClusterMessage.BuilderImpl resizeCluster) {
            this.resizeCluster = resizeCluster != null ? resizeCluster.build() : null;
        }

        @Override
        public ScheduledActionType build() {
            return new ScheduledActionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
