/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the status of a cluster restore action. Returns null if the cluster was not created by restoring a
 * snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreStatus implements SdkPojo, Serializable, ToCopyableBuilder<RestoreStatus.Builder, RestoreStatus> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(RestoreStatus::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Double> CURRENT_RESTORE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD = SdkField
            .<Double> builder(MarshallingType.DOUBLE)
            .getter(getter(RestoreStatus::currentRestoreRateInMegaBytesPerSecond))
            .setter(setter(Builder::currentRestoreRateInMegaBytesPerSecond))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("CurrentRestoreRateInMegaBytesPerSecond").build()).build();

    private static final SdkField<Long> SNAPSHOT_SIZE_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(RestoreStatus::snapshotSizeInMegaBytes)).setter(setter(Builder::snapshotSizeInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotSizeInMegaBytes").build())
            .build();

    private static final SdkField<Long> PROGRESS_IN_MEGA_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(RestoreStatus::progressInMegaBytes)).setter(setter(Builder::progressInMegaBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressInMegaBytes").build())
            .build();

    private static final SdkField<Long> ELAPSED_TIME_IN_SECONDS_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .getter(getter(RestoreStatus::elapsedTimeInSeconds)).setter(setter(Builder::elapsedTimeInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ElapsedTimeInSeconds").build())
            .build();

    private static final SdkField<Long> ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .getter(getter(RestoreStatus::estimatedTimeToCompletionInSeconds))
            .setter(setter(Builder::estimatedTimeToCompletionInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimatedTimeToCompletionInSeconds")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD,
            CURRENT_RESTORE_RATE_IN_MEGA_BYTES_PER_SECOND_FIELD, SNAPSHOT_SIZE_IN_MEGA_BYTES_FIELD, PROGRESS_IN_MEGA_BYTES_FIELD,
            ELAPSED_TIME_IN_SECONDS_FIELD, ESTIMATED_TIME_TO_COMPLETION_IN_SECONDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final Double currentRestoreRateInMegaBytesPerSecond;

    private final Long snapshotSizeInMegaBytes;

    private final Long progressInMegaBytes;

    private final Long elapsedTimeInSeconds;

    private final Long estimatedTimeToCompletionInSeconds;

    private RestoreStatus(BuilderImpl builder) {
        this.status = builder.status;
        this.currentRestoreRateInMegaBytesPerSecond = builder.currentRestoreRateInMegaBytesPerSecond;
        this.snapshotSizeInMegaBytes = builder.snapshotSizeInMegaBytes;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
    }

    /**
     * <p>
     * The status of the restore action. Returns starting, restoring, completed, or failed.
     * </p>
     * 
     * @return The status of the restore action. Returns starting, restoring, completed, or failed.
     */
    public String status() {
        return status;
    }

    /**
     * <p>
     * The number of megabytes per second being transferred from the backup storage. Returns the average rate for a
     * completed backup. This field is only updated when you restore to DC2 and DS2 node types.
     * </p>
     * 
     * @return The number of megabytes per second being transferred from the backup storage. Returns the average rate
     *         for a completed backup. This field is only updated when you restore to DC2 and DS2 node types.
     */
    public Double currentRestoreRateInMegaBytesPerSecond() {
        return currentRestoreRateInMegaBytesPerSecond;
    }

    /**
     * <p>
     * The size of the set of snapshot data used to restore the cluster. This field is only updated when you restore to
     * DC2 and DS2 node types.
     * </p>
     * 
     * @return The size of the set of snapshot data used to restore the cluster. This field is only updated when you
     *         restore to DC2 and DS2 node types.
     */
    public Long snapshotSizeInMegaBytes() {
        return snapshotSizeInMegaBytes;
    }

    /**
     * <p>
     * The number of megabytes that have been transferred from snapshot storage. This field is only updated when you
     * restore to DC2 and DS2 node types.
     * </p>
     * 
     * @return The number of megabytes that have been transferred from snapshot storage. This field is only updated when
     *         you restore to DC2 and DS2 node types.
     */
    public Long progressInMegaBytes() {
        return progressInMegaBytes;
    }

    /**
     * <p>
     * The amount of time an in-progress restore has been running, or the amount of time it took a completed restore to
     * finish. This field is only updated when you restore to DC2 and DS2 node types.
     * </p>
     * 
     * @return The amount of time an in-progress restore has been running, or the amount of time it took a completed
     *         restore to finish. This field is only updated when you restore to DC2 and DS2 node types.
     */
    public Long elapsedTimeInSeconds() {
        return elapsedTimeInSeconds;
    }

    /**
     * <p>
     * The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore. This
     * field is only updated when you restore to DC2 and DS2 node types.
     * </p>
     * 
     * @return The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore.
     *         This field is only updated when you restore to DC2 and DS2 node types.
     */
    public Long estimatedTimeToCompletionInSeconds() {
        return estimatedTimeToCompletionInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(currentRestoreRateInMegaBytesPerSecond());
        hashCode = 31 * hashCode + Objects.hashCode(snapshotSizeInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(progressInMegaBytes());
        hashCode = 31 * hashCode + Objects.hashCode(elapsedTimeInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(estimatedTimeToCompletionInSeconds());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreStatus)) {
            return false;
        }
        RestoreStatus other = (RestoreStatus) obj;
        return Objects.equals(status(), other.status())
                && Objects.equals(currentRestoreRateInMegaBytesPerSecond(), other.currentRestoreRateInMegaBytesPerSecond())
                && Objects.equals(snapshotSizeInMegaBytes(), other.snapshotSizeInMegaBytes())
                && Objects.equals(progressInMegaBytes(), other.progressInMegaBytes())
                && Objects.equals(elapsedTimeInSeconds(), other.elapsedTimeInSeconds())
                && Objects.equals(estimatedTimeToCompletionInSeconds(), other.estimatedTimeToCompletionInSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("RestoreStatus").add("Status", status())
                .add("CurrentRestoreRateInMegaBytesPerSecond", currentRestoreRateInMegaBytesPerSecond())
                .add("SnapshotSizeInMegaBytes", snapshotSizeInMegaBytes()).add("ProgressInMegaBytes", progressInMegaBytes())
                .add("ElapsedTimeInSeconds", elapsedTimeInSeconds())
                .add("EstimatedTimeToCompletionInSeconds", estimatedTimeToCompletionInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "CurrentRestoreRateInMegaBytesPerSecond":
            return Optional.ofNullable(clazz.cast(currentRestoreRateInMegaBytesPerSecond()));
        case "SnapshotSizeInMegaBytes":
            return Optional.ofNullable(clazz.cast(snapshotSizeInMegaBytes()));
        case "ProgressInMegaBytes":
            return Optional.ofNullable(clazz.cast(progressInMegaBytes()));
        case "ElapsedTimeInSeconds":
            return Optional.ofNullable(clazz.cast(elapsedTimeInSeconds()));
        case "EstimatedTimeToCompletionInSeconds":
            return Optional.ofNullable(clazz.cast(estimatedTimeToCompletionInSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RestoreStatus, T> g) {
        return obj -> g.apply((RestoreStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreStatus> {
        /**
         * <p>
         * The status of the restore action. Returns starting, restoring, completed, or failed.
         * </p>
         * 
         * @param status
         *        The status of the restore action. Returns starting, restoring, completed, or failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(String status);

        /**
         * <p>
         * The number of megabytes per second being transferred from the backup storage. Returns the average rate for a
         * completed backup. This field is only updated when you restore to DC2 and DS2 node types.
         * </p>
         * 
         * @param currentRestoreRateInMegaBytesPerSecond
         *        The number of megabytes per second being transferred from the backup storage. Returns the average rate
         *        for a completed backup. This field is only updated when you restore to DC2 and DS2 node types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond);

        /**
         * <p>
         * The size of the set of snapshot data used to restore the cluster. This field is only updated when you restore
         * to DC2 and DS2 node types.
         * </p>
         * 
         * @param snapshotSizeInMegaBytes
         *        The size of the set of snapshot data used to restore the cluster. This field is only updated when you
         *        restore to DC2 and DS2 node types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder snapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes);

        /**
         * <p>
         * The number of megabytes that have been transferred from snapshot storage. This field is only updated when you
         * restore to DC2 and DS2 node types.
         * </p>
         * 
         * @param progressInMegaBytes
         *        The number of megabytes that have been transferred from snapshot storage. This field is only updated
         *        when you restore to DC2 and DS2 node types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressInMegaBytes(Long progressInMegaBytes);

        /**
         * <p>
         * The amount of time an in-progress restore has been running, or the amount of time it took a completed restore
         * to finish. This field is only updated when you restore to DC2 and DS2 node types.
         * </p>
         * 
         * @param elapsedTimeInSeconds
         *        The amount of time an in-progress restore has been running, or the amount of time it took a completed
         *        restore to finish. This field is only updated when you restore to DC2 and DS2 node types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds);

        /**
         * <p>
         * The estimate of the time remaining before the restore will complete. Returns 0 for a completed restore. This
         * field is only updated when you restore to DC2 and DS2 node types.
         * </p>
         * 
         * @param estimatedTimeToCompletionInSeconds
         *        The estimate of the time remaining before the restore will complete. Returns 0 for a completed
         *        restore. This field is only updated when you restore to DC2 and DS2 node types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private Double currentRestoreRateInMegaBytesPerSecond;

        private Long snapshotSizeInMegaBytes;

        private Long progressInMegaBytes;

        private Long elapsedTimeInSeconds;

        private Long estimatedTimeToCompletionInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreStatus model) {
            status(model.status);
            currentRestoreRateInMegaBytesPerSecond(model.currentRestoreRateInMegaBytesPerSecond);
            snapshotSizeInMegaBytes(model.snapshotSizeInMegaBytes);
            progressInMegaBytes(model.progressInMegaBytes);
            elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Double getCurrentRestoreRateInMegaBytesPerSecond() {
            return currentRestoreRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder currentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
            return this;
        }

        public final void setCurrentRestoreRateInMegaBytesPerSecond(Double currentRestoreRateInMegaBytesPerSecond) {
            this.currentRestoreRateInMegaBytesPerSecond = currentRestoreRateInMegaBytesPerSecond;
        }

        public final Long getSnapshotSizeInMegaBytes() {
            return snapshotSizeInMegaBytes;
        }

        @Override
        public final Builder snapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
            return this;
        }

        public final void setSnapshotSizeInMegaBytes(Long snapshotSizeInMegaBytes) {
            this.snapshotSizeInMegaBytes = snapshotSizeInMegaBytes;
        }

        public final Long getProgressInMegaBytes() {
            return progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        public final Long getElapsedTimeInSeconds() {
            return elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        @Override
        public RestoreStatus build() {
            return new RestoreStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
