/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a maintenance track that determines which Amazon Redshift version to apply during a maintenance window. If
 * the value for <code>MaintenanceTrack</code> is <code>current</code>, the cluster is updated to the most recently
 * certified maintenance release. If the value is <code>trailing</code>, the cluster is updated to the previously
 * certified maintenance release.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MaintenanceTrack implements SdkPojo, Serializable,
        ToCopyableBuilder<MaintenanceTrack.Builder, MaintenanceTrack> {
    private static final SdkField<String> MAINTENANCE_TRACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MaintenanceTrack::maintenanceTrackName)).setter(setter(Builder::maintenanceTrackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceTrackName").build())
            .build();

    private static final SdkField<String> DATABASE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(MaintenanceTrack::databaseVersion)).setter(setter(Builder::databaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseVersion").build()).build();

    private static final SdkField<List<UpdateTarget>> UPDATE_TARGETS_FIELD = SdkField
            .<List<UpdateTarget>> builder(MarshallingType.LIST)
            .getter(getter(MaintenanceTrack::updateTargets))
            .setter(setter(Builder::updateTargets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateTargets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("UpdateTarget")
                            .memberFieldInfo(
                                    SdkField.<UpdateTarget> builder(MarshallingType.SDK_POJO)
                                            .constructor(UpdateTarget::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("UpdateTarget").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINTENANCE_TRACK_NAME_FIELD,
            DATABASE_VERSION_FIELD, UPDATE_TARGETS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String maintenanceTrackName;

    private final String databaseVersion;

    private final List<UpdateTarget> updateTargets;

    private MaintenanceTrack(BuilderImpl builder) {
        this.maintenanceTrackName = builder.maintenanceTrackName;
        this.databaseVersion = builder.databaseVersion;
        this.updateTargets = builder.updateTargets;
    }

    /**
     * <p>
     * The name of the maintenance track. Possible values are <code>current</code> and <code>trailing</code>.
     * </p>
     * 
     * @return The name of the maintenance track. Possible values are <code>current</code> and <code>trailing</code>.
     */
    public String maintenanceTrackName() {
        return maintenanceTrackName;
    }

    /**
     * <p>
     * The version number for the cluster release.
     * </p>
     * 
     * @return The version number for the cluster release.
     */
    public String databaseVersion() {
        return databaseVersion;
    }

    /**
     * Returns true if the UpdateTargets property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasUpdateTargets() {
        return updateTargets != null && !(updateTargets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <a>UpdateTarget</a> objects to update with the maintenance track.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasUpdateTargets()} to see if a value was sent in this field.
     * </p>
     * 
     * @return An array of <a>UpdateTarget</a> objects to update with the maintenance track.
     */
    public List<UpdateTarget> updateTargets() {
        return updateTargets;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maintenanceTrackName());
        hashCode = 31 * hashCode + Objects.hashCode(databaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(updateTargets());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MaintenanceTrack)) {
            return false;
        }
        MaintenanceTrack other = (MaintenanceTrack) obj;
        return Objects.equals(maintenanceTrackName(), other.maintenanceTrackName())
                && Objects.equals(databaseVersion(), other.databaseVersion())
                && Objects.equals(updateTargets(), other.updateTargets());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MaintenanceTrack").add("MaintenanceTrackName", maintenanceTrackName())
                .add("DatabaseVersion", databaseVersion()).add("UpdateTargets", updateTargets()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaintenanceTrackName":
            return Optional.ofNullable(clazz.cast(maintenanceTrackName()));
        case "DatabaseVersion":
            return Optional.ofNullable(clazz.cast(databaseVersion()));
        case "UpdateTargets":
            return Optional.ofNullable(clazz.cast(updateTargets()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MaintenanceTrack, T> g) {
        return obj -> g.apply((MaintenanceTrack) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MaintenanceTrack> {
        /**
         * <p>
         * The name of the maintenance track. Possible values are <code>current</code> and <code>trailing</code>.
         * </p>
         * 
         * @param maintenanceTrackName
         *        The name of the maintenance track. Possible values are <code>current</code> and <code>trailing</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maintenanceTrackName(String maintenanceTrackName);

        /**
         * <p>
         * The version number for the cluster release.
         * </p>
         * 
         * @param databaseVersion
         *        The version number for the cluster release.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseVersion(String databaseVersion);

        /**
         * <p>
         * An array of <a>UpdateTarget</a> objects to update with the maintenance track.
         * </p>
         * 
         * @param updateTargets
         *        An array of <a>UpdateTarget</a> objects to update with the maintenance track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTargets(Collection<UpdateTarget> updateTargets);

        /**
         * <p>
         * An array of <a>UpdateTarget</a> objects to update with the maintenance track.
         * </p>
         * 
         * @param updateTargets
         *        An array of <a>UpdateTarget</a> objects to update with the maintenance track.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateTargets(UpdateTarget... updateTargets);

        /**
         * <p>
         * An array of <a>UpdateTarget</a> objects to update with the maintenance track.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UpdateTarget>.Builder} avoiding the need to
         * create one manually via {@link List<UpdateTarget>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UpdateTarget>.Builder#build()} is called immediately and its
         * result is passed to {@link #updateTargets(List<UpdateTarget>)}.
         * 
         * @param updateTargets
         *        a consumer that will call methods on {@link List<UpdateTarget>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #updateTargets(List<UpdateTarget>)
         */
        Builder updateTargets(Consumer<UpdateTarget.Builder>... updateTargets);
    }

    static final class BuilderImpl implements Builder {
        private String maintenanceTrackName;

        private String databaseVersion;

        private List<UpdateTarget> updateTargets = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MaintenanceTrack model) {
            maintenanceTrackName(model.maintenanceTrackName);
            databaseVersion(model.databaseVersion);
            updateTargets(model.updateTargets);
        }

        public final String getMaintenanceTrackName() {
            return maintenanceTrackName;
        }

        @Override
        public final Builder maintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
            return this;
        }

        public final void setMaintenanceTrackName(String maintenanceTrackName) {
            this.maintenanceTrackName = maintenanceTrackName;
        }

        public final String getDatabaseVersion() {
            return databaseVersion;
        }

        @Override
        public final Builder databaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
            return this;
        }

        public final void setDatabaseVersion(String databaseVersion) {
            this.databaseVersion = databaseVersion;
        }

        public final Collection<UpdateTarget.Builder> getUpdateTargets() {
            return updateTargets != null ? updateTargets.stream().map(UpdateTarget::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder updateTargets(Collection<UpdateTarget> updateTargets) {
            this.updateTargets = EligibleTracksToUpdateListCopier.copy(updateTargets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(UpdateTarget... updateTargets) {
            updateTargets(Arrays.asList(updateTargets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder updateTargets(Consumer<UpdateTarget.Builder>... updateTargets) {
            updateTargets(Stream.of(updateTargets).map(c -> UpdateTarget.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setUpdateTargets(Collection<UpdateTarget.BuilderImpl> updateTargets) {
            this.updateTargets = EligibleTracksToUpdateListCopier.copyFromBuilder(updateTargets);
        }

        @Override
        public MaintenanceTrack build() {
            return new MaintenanceTrack(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
