/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeScheduledActionsRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeScheduledActionsRequest.Builder, DescribeScheduledActionsRequest> {
    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeScheduledActionsRequest::scheduledActionName)).setter(setter(Builder::scheduledActionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build())
            .build();

    private static final SdkField<String> TARGET_ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeScheduledActionsRequest::targetActionTypeAsString)).setter(setter(Builder::targetActionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetActionType").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeScheduledActionsRequest::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(DescribeScheduledActionsRequest::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeScheduledActionsRequest::active)).setter(setter(Builder::active))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Active").build()).build();

    private static final SdkField<List<ScheduledActionFilter>> FILTERS_FIELD = SdkField
            .<List<ScheduledActionFilter>> builder(MarshallingType.LIST)
            .getter(getter(DescribeScheduledActionsRequest::filters))
            .setter(setter(Builder::filters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Filters").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ScheduledActionFilter")
                            .memberFieldInfo(
                                    SdkField.<ScheduledActionFilter> builder(MarshallingType.SDK_POJO)
                                            .constructor(ScheduledActionFilter::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ScheduledActionFilter").build()).build()).build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeScheduledActionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeScheduledActionsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTION_NAME_FIELD,
            TARGET_ACTION_TYPE_FIELD, START_TIME_FIELD, END_TIME_FIELD, ACTIVE_FIELD, FILTERS_FIELD, MARKER_FIELD,
            MAX_RECORDS_FIELD));

    private final String scheduledActionName;

    private final String targetActionType;

    private final Instant startTime;

    private final Instant endTime;

    private final Boolean active;

    private final List<ScheduledActionFilter> filters;

    private final String marker;

    private final Integer maxRecords;

    private DescribeScheduledActionsRequest(BuilderImpl builder) {
        super(builder);
        this.scheduledActionName = builder.scheduledActionName;
        this.targetActionType = builder.targetActionType;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.active = builder.active;
        this.filters = builder.filters;
        this.marker = builder.marker;
        this.maxRecords = builder.maxRecords;
    }

    /**
     * <p>
     * The name of the scheduled action to retrieve.
     * </p>
     * 
     * @return The name of the scheduled action to retrieve.
     */
    public String scheduledActionName() {
        return scheduledActionName;
    }

    /**
     * <p>
     * The type of the scheduled actions to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetActionType}
     * will return {@link ScheduledActionTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetActionTypeAsString}.
     * </p>
     * 
     * @return The type of the scheduled actions to retrieve.
     * @see ScheduledActionTypeValues
     */
    public ScheduledActionTypeValues targetActionType() {
        return ScheduledActionTypeValues.fromValue(targetActionType);
    }

    /**
     * <p>
     * The type of the scheduled actions to retrieve.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #targetActionType}
     * will return {@link ScheduledActionTypeValues#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #targetActionTypeAsString}.
     * </p>
     * 
     * @return The type of the scheduled actions to retrieve.
     * @see ScheduledActionTypeValues
     */
    public String targetActionTypeAsString() {
        return targetActionType;
    }

    /**
     * <p>
     * The start time in UTC of the scheduled actions to retrieve. Only active scheduled actions that have invocations
     * after this time are retrieved.
     * </p>
     * 
     * @return The start time in UTC of the scheduled actions to retrieve. Only active scheduled actions that have
     *         invocations after this time are retrieved.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The end time in UTC of the scheduled action to retrieve. Only active scheduled actions that have invocations
     * before this time are retrieved.
     * </p>
     * 
     * @return The end time in UTC of the scheduled action to retrieve. Only active scheduled actions that have
     *         invocations before this time are retrieved.
     */
    public Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * If true, retrieve only active scheduled actions. If false, retrieve only disabled scheduled actions.
     * </p>
     * 
     * @return If true, retrieve only active scheduled actions. If false, retrieve only disabled scheduled actions.
     */
    public Boolean active() {
        return active;
    }

    /**
     * Returns true if the Filters property was specified by the sender (it may be empty), or false if the sender did
     * not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasFilters() {
        return filters != null && !(filters instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of scheduled action filters.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasFilters()} to see if a value was sent in this field.
     * </p>
     * 
     * @return List of scheduled action filters.
     */
    public List<ScheduledActionFilter> filters() {
        return filters;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point to return a set of response records. When the results of
     * a <a>DescribeScheduledActions</a> request exceed the value specified in <code>MaxRecords</code>, AWS returns a
     * value in the <code>Marker</code> field of the response. You can retrieve the next set of response records by
     * providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point to return a set of response records. When the
     *         results of a <a>DescribeScheduledActions</a> request exceed the value specified in
     *         <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can
     *         retrieve the next set of response records by providing the returned marker value in the
     *         <code>Marker</code> parameter and retrying the request.
     */
    public String marker() {
        return marker;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of the
     * response. You can retrieve the next set of records by retrying the command with the returned marker value.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <p>
     * Constraints: minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code>
     *         field of the response. You can retrieve the next set of records by retrying the command with the returned
     *         marker value. </p>
     *         <p>
     *         Default: <code>100</code>
     *         </p>
     *         <p>
     *         Constraints: minimum 20, maximum 100.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(targetActionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(active());
        hashCode = 31 * hashCode + Objects.hashCode(filters());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScheduledActionsRequest)) {
            return false;
        }
        DescribeScheduledActionsRequest other = (DescribeScheduledActionsRequest) obj;
        return Objects.equals(scheduledActionName(), other.scheduledActionName())
                && Objects.equals(targetActionTypeAsString(), other.targetActionTypeAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(active(), other.active()) && Objects.equals(filters(), other.filters())
                && Objects.equals(marker(), other.marker()) && Objects.equals(maxRecords(), other.maxRecords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeScheduledActionsRequest").add("ScheduledActionName", scheduledActionName())
                .add("TargetActionType", targetActionTypeAsString()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("Active", active()).add("Filters", filters()).add("Marker", marker()).add("MaxRecords", maxRecords())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScheduledActionName":
            return Optional.ofNullable(clazz.cast(scheduledActionName()));
        case "TargetActionType":
            return Optional.ofNullable(clazz.cast(targetActionTypeAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "Active":
            return Optional.ofNullable(clazz.cast(active()));
        case "Filters":
            return Optional.ofNullable(clazz.cast(filters()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScheduledActionsRequest, T> g) {
        return obj -> g.apply((DescribeScheduledActionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeScheduledActionsRequest> {
        /**
         * <p>
         * The name of the scheduled action to retrieve.
         * </p>
         * 
         * @param scheduledActionName
         *        The name of the scheduled action to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledActionName(String scheduledActionName);

        /**
         * <p>
         * The type of the scheduled actions to retrieve.
         * </p>
         * 
         * @param targetActionType
         *        The type of the scheduled actions to retrieve.
         * @see ScheduledActionTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledActionTypeValues
         */
        Builder targetActionType(String targetActionType);

        /**
         * <p>
         * The type of the scheduled actions to retrieve.
         * </p>
         * 
         * @param targetActionType
         *        The type of the scheduled actions to retrieve.
         * @see ScheduledActionTypeValues
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledActionTypeValues
         */
        Builder targetActionType(ScheduledActionTypeValues targetActionType);

        /**
         * <p>
         * The start time in UTC of the scheduled actions to retrieve. Only active scheduled actions that have
         * invocations after this time are retrieved.
         * </p>
         * 
         * @param startTime
         *        The start time in UTC of the scheduled actions to retrieve. Only active scheduled actions that have
         *        invocations after this time are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The end time in UTC of the scheduled action to retrieve. Only active scheduled actions that have invocations
         * before this time are retrieved.
         * </p>
         * 
         * @param endTime
         *        The end time in UTC of the scheduled action to retrieve. Only active scheduled actions that have
         *        invocations before this time are retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * If true, retrieve only active scheduled actions. If false, retrieve only disabled scheduled actions.
         * </p>
         * 
         * @param active
         *        If true, retrieve only active scheduled actions. If false, retrieve only disabled scheduled actions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder active(Boolean active);

        /**
         * <p>
         * List of scheduled action filters.
         * </p>
         * 
         * @param filters
         *        List of scheduled action filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(Collection<ScheduledActionFilter> filters);

        /**
         * <p>
         * List of scheduled action filters.
         * </p>
         * 
         * @param filters
         *        List of scheduled action filters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filters(ScheduledActionFilter... filters);

        /**
         * <p>
         * List of scheduled action filters.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ScheduledActionFilter>.Builder} avoiding
         * the need to create one manually via {@link List<ScheduledActionFilter>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ScheduledActionFilter>.Builder#build()} is called
         * immediately and its result is passed to {@link #filters(List<ScheduledActionFilter>)}.
         * 
         * @param filters
         *        a consumer that will call methods on {@link List<ScheduledActionFilter>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filters(List<ScheduledActionFilter>)
         */
        Builder filters(Consumer<ScheduledActionFilter.Builder>... filters);

        /**
         * <p>
         * An optional parameter that specifies the starting point to return a set of response records. When the results
         * of a <a>DescribeScheduledActions</a> request exceed the value specified in <code>MaxRecords</code>, AWS
         * returns a value in the <code>Marker</code> field of the response. You can retrieve the next set of response
         * records by providing the returned marker value in the <code>Marker</code> parameter and retrying the request.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point to return a set of response records. When the
         *        results of a <a>DescribeScheduledActions</a> request exceed the value specified in
         *        <code>MaxRecords</code>, AWS returns a value in the <code>Marker</code> field of the response. You can
         *        retrieve the next set of response records by providing the returned marker value in the
         *        <code>Marker</code> parameter and retrying the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified <code>MaxRecords</code> value, a value is returned in a <code>marker</code> field of
         * the response. You can retrieve the next set of records by retrying the command with the returned marker
         * value.
         * </p>
         * <p>
         * Default: <code>100</code>
         * </p>
         * <p>
         * Constraints: minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified <code>MaxRecords</code> value, a value is returned in a
         *        <code>marker</code> field of the response. You can retrieve the next set of records by retrying the
         *        command with the returned marker value. </p>
         *        <p>
         *        Default: <code>100</code>
         *        </p>
         *        <p>
         *        Constraints: minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String scheduledActionName;

        private String targetActionType;

        private Instant startTime;

        private Instant endTime;

        private Boolean active;

        private List<ScheduledActionFilter> filters = DefaultSdkAutoConstructList.getInstance();

        private String marker;

        private Integer maxRecords;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScheduledActionsRequest model) {
            super(model);
            scheduledActionName(model.scheduledActionName);
            targetActionType(model.targetActionType);
            startTime(model.startTime);
            endTime(model.endTime);
            active(model.active);
            filters(model.filters);
            marker(model.marker);
            maxRecords(model.maxRecords);
        }

        public final String getScheduledActionName() {
            return scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final String getTargetActionTypeAsString() {
            return targetActionType;
        }

        @Override
        public final Builder targetActionType(String targetActionType) {
            this.targetActionType = targetActionType;
            return this;
        }

        @Override
        public final Builder targetActionType(ScheduledActionTypeValues targetActionType) {
            this.targetActionType(targetActionType == null ? null : targetActionType.toString());
            return this;
        }

        public final void setTargetActionType(String targetActionType) {
            this.targetActionType = targetActionType;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        public final Boolean getActive() {
            return active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        public final Collection<ScheduledActionFilter.Builder> getFilters() {
            return filters != null ? filters.stream().map(ScheduledActionFilter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder filters(Collection<ScheduledActionFilter> filters) {
            this.filters = ScheduledActionFilterListCopier.copy(filters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(ScheduledActionFilter... filters) {
            filters(Arrays.asList(filters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder filters(Consumer<ScheduledActionFilter.Builder>... filters) {
            filters(Stream.of(filters).map(c -> ScheduledActionFilter.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFilters(Collection<ScheduledActionFilter.BuilderImpl> filters) {
            this.filters = ScheduledActionFilterListCopier.copyFromBuilder(filters);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeScheduledActionsRequest build() {
            return new DescribeScheduledActionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
