/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeReservedNodesResponse extends RedshiftResponse implements
        ToCopyableBuilder<DescribeReservedNodesResponse.Builder, DescribeReservedNodesResponse> {
    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeReservedNodesResponse::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final SdkField<List<ReservedNode>> RESERVED_NODES_FIELD = SdkField
            .<List<ReservedNode>> builder(MarshallingType.LIST)
            .getter(getter(DescribeReservedNodesResponse::reservedNodes))
            .setter(setter(Builder::reservedNodes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName("ReservedNode")
                            .memberFieldInfo(
                                    SdkField.<ReservedNode> builder(MarshallingType.SDK_POJO)
                                            .constructor(ReservedNode::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("ReservedNode").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MARKER_FIELD,
            RESERVED_NODES_FIELD));

    private final String marker;

    private final List<ReservedNode> reservedNodes;

    private DescribeReservedNodesResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.reservedNodes = builder.reservedNodes;
    }

    /**
     * <p>
     * A value that indicates the starting point for the next set of response records in a subsequent request. If a
     * value is returned in a response, you can retrieve the next set of records by providing this returned marker value
     * in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is empty, all
     * response records have been retrieved for the request.
     * </p>
     * 
     * @return A value that indicates the starting point for the next set of response records in a subsequent request.
     *         If a value is returned in a response, you can retrieve the next set of records by providing this returned
     *         marker value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code>
     *         field is empty, all response records have been retrieved for the request.
     */
    public String marker() {
        return marker;
    }

    /**
     * Returns true if the ReservedNodes property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasReservedNodes() {
        return reservedNodes != null && !(reservedNodes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of <code>ReservedNode</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasReservedNodes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The list of <code>ReservedNode</code> objects.
     */
    public List<ReservedNode> reservedNodes() {
        return reservedNodes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        hashCode = 31 * hashCode + Objects.hashCode(reservedNodes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodesResponse)) {
            return false;
        }
        DescribeReservedNodesResponse other = (DescribeReservedNodesResponse) obj;
        return Objects.equals(marker(), other.marker()) && Objects.equals(reservedNodes(), other.reservedNodes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeReservedNodesResponse").add("Marker", marker()).add("ReservedNodes", reservedNodes())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        case "ReservedNodes":
            return Optional.ofNullable(clazz.cast(reservedNodes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeReservedNodesResponse, T> g) {
        return obj -> g.apply((DescribeReservedNodesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeReservedNodesResponse> {
        /**
         * <p>
         * A value that indicates the starting point for the next set of response records in a subsequent request. If a
         * value is returned in a response, you can retrieve the next set of records by providing this returned marker
         * value in the <code>Marker</code> parameter and retrying the command. If the <code>Marker</code> field is
         * empty, all response records have been retrieved for the request.
         * </p>
         * 
         * @param marker
         *        A value that indicates the starting point for the next set of response records in a subsequent
         *        request. If a value is returned in a response, you can retrieve the next set of records by providing
         *        this returned marker value in the <code>Marker</code> parameter and retrying the command. If the
         *        <code>Marker</code> field is empty, all response records have been retrieved for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        /**
         * <p>
         * The list of <code>ReservedNode</code> objects.
         * </p>
         * 
         * @param reservedNodes
         *        The list of <code>ReservedNode</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodes(Collection<ReservedNode> reservedNodes);

        /**
         * <p>
         * The list of <code>ReservedNode</code> objects.
         * </p>
         * 
         * @param reservedNodes
         *        The list of <code>ReservedNode</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reservedNodes(ReservedNode... reservedNodes);

        /**
         * <p>
         * The list of <code>ReservedNode</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ReservedNode>.Builder} avoiding the need to
         * create one manually via {@link List<ReservedNode>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ReservedNode>.Builder#build()} is called immediately and its
         * result is passed to {@link #reservedNodes(List<ReservedNode>)}.
         * 
         * @param reservedNodes
         *        a consumer that will call methods on {@link List<ReservedNode>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reservedNodes(List<ReservedNode>)
         */
        Builder reservedNodes(Consumer<ReservedNode.Builder>... reservedNodes);
    }

    static final class BuilderImpl extends RedshiftResponse.BuilderImpl implements Builder {
        private String marker;

        private List<ReservedNode> reservedNodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodesResponse model) {
            super(model);
            marker(model.marker);
            reservedNodes(model.reservedNodes);
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedNode.Builder> getReservedNodes() {
            return reservedNodes != null ? reservedNodes.stream().map(ReservedNode::toBuilder).collect(Collectors.toList())
                    : null;
        }

        @Override
        public final Builder reservedNodes(Collection<ReservedNode> reservedNodes) {
            this.reservedNodes = ReservedNodeListCopier.copy(reservedNodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodes(ReservedNode... reservedNodes) {
            reservedNodes(Arrays.asList(reservedNodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodes(Consumer<ReservedNode.Builder>... reservedNodes) {
            reservedNodes(Stream.of(reservedNodes).map(c -> ReservedNode.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setReservedNodes(Collection<ReservedNode.BuilderImpl> reservedNodes) {
            this.reservedNodes = ReservedNodeListCopier.copyFromBuilder(reservedNodes);
        }

        @Override
        public DescribeReservedNodesResponse build() {
            return new DescribeReservedNodesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
