/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeClusterDbRevisionsRequest extends RedshiftRequest implements
        ToCopyableBuilder<DescribeClusterDbRevisionsRequest.Builder, DescribeClusterDbRevisionsRequest> {
    private static final SdkField<String> CLUSTER_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClusterDbRevisionsRequest::clusterIdentifier)).setter(setter(Builder::clusterIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterIdentifier").build()).build();

    private static final SdkField<Integer> MAX_RECORDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(DescribeClusterDbRevisionsRequest::maxRecords)).setter(setter(Builder::maxRecords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxRecords").build()).build();

    private static final SdkField<String> MARKER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeClusterDbRevisionsRequest::marker)).setter(setter(Builder::marker))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Marker").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_IDENTIFIER_FIELD,
            MAX_RECORDS_FIELD, MARKER_FIELD));

    private final String clusterIdentifier;

    private final Integer maxRecords;

    private final String marker;

    private DescribeClusterDbRevisionsRequest(BuilderImpl builder) {
        super(builder);
        this.clusterIdentifier = builder.clusterIdentifier;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    /**
     * <p>
     * A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are requesting. This parameter is
     * case sensitive. All clusters defined for an account are returned by default.
     * </p>
     * 
     * @return A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are requesting. This
     *         parameter is case sensitive. All clusters defined for an account are returned by default.
     */
    public String clusterIdentifier() {
        return clusterIdentifier;
    }

    /**
     * <p>
     * The maximum number of response records to return in each call. If the number of remaining response records
     * exceeds the specified MaxRecords value, a value is returned in the <code>marker</code> field of the response. You
     * can retrieve the next set of response records by providing the returned <code>marker</code> value in the
     * <code>marker</code> parameter and retrying the request.
     * </p>
     * <p>
     * Default: 100
     * </p>
     * <p>
     * Constraints: minimum 20, maximum 100.
     * </p>
     * 
     * @return The maximum number of response records to return in each call. If the number of remaining response
     *         records exceeds the specified MaxRecords value, a value is returned in the <code>marker</code> field of
     *         the response. You can retrieve the next set of response records by providing the returned
     *         <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p>
     *         <p>
     *         Default: 100
     *         </p>
     *         <p>
     *         Constraints: minimum 20, maximum 100.
     */
    public Integer maxRecords() {
        return maxRecords;
    }

    /**
     * <p>
     * An optional parameter that specifies the starting point for returning a set of response records. When the results
     * of a <code>DescribeClusterDbRevisions</code> request exceed the value specified in <code>MaxRecords</code>,
     * Amazon Redshift returns a value in the <code>marker</code> field of the response. You can retrieve the next set
     * of response records by providing the returned <code>marker</code> value in the <code>marker</code> parameter and
     * retrying the request.
     * </p>
     * <p>
     * Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or the <code>marker</code>
     * parameter, but not both.
     * </p>
     * 
     * @return An optional parameter that specifies the starting point for returning a set of response records. When the
     *         results of a <code>DescribeClusterDbRevisions</code> request exceed the value specified in
     *         <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>marker</code> field of the
     *         response. You can retrieve the next set of response records by providing the returned <code>marker</code>
     *         value in the <code>marker</code> parameter and retrying the request. </p>
     *         <p>
     *         Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or the
     *         <code>marker</code> parameter, but not both.
     */
    public String marker() {
        return marker;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(marker());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterDbRevisionsRequest)) {
            return false;
        }
        DescribeClusterDbRevisionsRequest other = (DescribeClusterDbRevisionsRequest) obj;
        return Objects.equals(clusterIdentifier(), other.clusterIdentifier()) && Objects.equals(maxRecords(), other.maxRecords())
                && Objects.equals(marker(), other.marker());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeClusterDbRevisionsRequest").add("ClusterIdentifier", clusterIdentifier())
                .add("MaxRecords", maxRecords()).add("Marker", marker()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClusterIdentifier":
            return Optional.ofNullable(clazz.cast(clusterIdentifier()));
        case "MaxRecords":
            return Optional.ofNullable(clazz.cast(maxRecords()));
        case "Marker":
            return Optional.ofNullable(clazz.cast(marker()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterDbRevisionsRequest, T> g) {
        return obj -> g.apply((DescribeClusterDbRevisionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends RedshiftRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeClusterDbRevisionsRequest> {
        /**
         * <p>
         * A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are requesting. This parameter is
         * case sensitive. All clusters defined for an account are returned by default.
         * </p>
         * 
         * @param clusterIdentifier
         *        A unique identifier for a cluster whose <code>ClusterDbRevisions</code> you are requesting. This
         *        parameter is case sensitive. All clusters defined for an account are returned by default.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterIdentifier(String clusterIdentifier);

        /**
         * <p>
         * The maximum number of response records to return in each call. If the number of remaining response records
         * exceeds the specified MaxRecords value, a value is returned in the <code>marker</code> field of the response.
         * You can retrieve the next set of response records by providing the returned <code>marker</code> value in the
         * <code>marker</code> parameter and retrying the request.
         * </p>
         * <p>
         * Default: 100
         * </p>
         * <p>
         * Constraints: minimum 20, maximum 100.
         * </p>
         * 
         * @param maxRecords
         *        The maximum number of response records to return in each call. If the number of remaining response
         *        records exceeds the specified MaxRecords value, a value is returned in the <code>marker</code> field
         *        of the response. You can retrieve the next set of response records by providing the returned
         *        <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p>
         *        <p>
         *        Default: 100
         *        </p>
         *        <p>
         *        Constraints: minimum 20, maximum 100.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxRecords(Integer maxRecords);

        /**
         * <p>
         * An optional parameter that specifies the starting point for returning a set of response records. When the
         * results of a <code>DescribeClusterDbRevisions</code> request exceed the value specified in
         * <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>marker</code> field of the response.
         * You can retrieve the next set of response records by providing the returned <code>marker</code> value in the
         * <code>marker</code> parameter and retrying the request.
         * </p>
         * <p>
         * Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or the <code>marker</code>
         * parameter, but not both.
         * </p>
         * 
         * @param marker
         *        An optional parameter that specifies the starting point for returning a set of response records. When
         *        the results of a <code>DescribeClusterDbRevisions</code> request exceed the value specified in
         *        <code>MaxRecords</code>, Amazon Redshift returns a value in the <code>marker</code> field of the
         *        response. You can retrieve the next set of response records by providing the returned
         *        <code>marker</code> value in the <code>marker</code> parameter and retrying the request. </p>
         *        <p>
         *        Constraints: You can specify either the <code>ClusterIdentifier</code> parameter, or the
         *        <code>marker</code> parameter, but not both.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder marker(String marker);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends RedshiftRequest.BuilderImpl implements Builder {
        private String clusterIdentifier;

        private Integer maxRecords;

        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterDbRevisionsRequest model) {
            super(model);
            clusterIdentifier(model.clusterIdentifier);
            maxRecords(model.maxRecords);
            marker(model.marker);
        }

        public final String getClusterIdentifier() {
            return clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final Integer getMaxRecords() {
            return maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeClusterDbRevisionsRequest build() {
            return new DescribeClusterDbRevisionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
