/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.services.redshift.model.ScheduledActionState;
import software.amazon.awssdk.services.redshift.model.ScheduledActionTimeListCopier;
import software.amazon.awssdk.services.redshift.model.ScheduledActionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModifyScheduledActionResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, ModifyScheduledActionResponse> {
    private static final SdkField<String> SCHEDULED_ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyScheduledActionResponse.getter(ModifyScheduledActionResponse::scheduledActionName)).setter(ModifyScheduledActionResponse.setter(Builder::scheduledActionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionName").build()}).build();
    private static final SdkField<ScheduledActionType> TARGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(ModifyScheduledActionResponse.getter(ModifyScheduledActionResponse::targetAction)).setter(ModifyScheduledActionResponse.setter(Builder::targetAction)).constructor(ScheduledActionType::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetAction").build()}).build();
    private static final SdkField<String> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyScheduledActionResponse.getter(ModifyScheduledActionResponse::schedule)).setter(ModifyScheduledActionResponse.setter(Builder::schedule)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Schedule").build()}).build();
    private static final SdkField<String> IAM_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyScheduledActionResponse.getter(ModifyScheduledActionResponse::iamRole)).setter(ModifyScheduledActionResponse.setter(Builder::iamRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRole").build()}).build();
    private static final SdkField<String> SCHEDULED_ACTION_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyScheduledActionResponse.getter(ModifyScheduledActionResponse::scheduledActionDescription)).setter(ModifyScheduledActionResponse.setter(Builder::scheduledActionDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionDescription").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(ModifyScheduledActionResponse.getter(ModifyScheduledActionResponse::stateAsString)).setter(ModifyScheduledActionResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<List<Instant>> NEXT_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(ModifyScheduledActionResponse.getter(ModifyScheduledActionResponse::nextInvocations)).setter(ModifyScheduledActionResponse.setter(Builder::nextInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextInvocations").build(), ListTrait.builder().memberLocationName("ScheduledActionTime").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INSTANT).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledActionTime").build()}).build()).build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ModifyScheduledActionResponse.getter(ModifyScheduledActionResponse::startTime)).setter(ModifyScheduledActionResponse.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(ModifyScheduledActionResponse.getter(ModifyScheduledActionResponse::endTime)).setter(ModifyScheduledActionResponse.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEDULED_ACTION_NAME_FIELD, TARGET_ACTION_FIELD, SCHEDULE_FIELD, IAM_ROLE_FIELD, SCHEDULED_ACTION_DESCRIPTION_FIELD, STATE_FIELD, NEXT_INVOCATIONS_FIELD, START_TIME_FIELD, END_TIME_FIELD));
    private final String scheduledActionName;
    private final ScheduledActionType targetAction;
    private final String schedule;
    private final String iamRole;
    private final String scheduledActionDescription;
    private final String state;
    private final List<Instant> nextInvocations;
    private final Instant startTime;
    private final Instant endTime;

    private ModifyScheduledActionResponse(BuilderImpl builder) {
        super(builder);
        this.scheduledActionName = builder.scheduledActionName;
        this.targetAction = builder.targetAction;
        this.schedule = builder.schedule;
        this.iamRole = builder.iamRole;
        this.scheduledActionDescription = builder.scheduledActionDescription;
        this.state = builder.state;
        this.nextInvocations = builder.nextInvocations;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    public String scheduledActionName() {
        return this.scheduledActionName;
    }

    public ScheduledActionType targetAction() {
        return this.targetAction;
    }

    public String schedule() {
        return this.schedule;
    }

    public String iamRole() {
        return this.iamRole;
    }

    public String scheduledActionDescription() {
        return this.scheduledActionDescription;
    }

    public ScheduledActionState state() {
        return ScheduledActionState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public List<Instant> nextInvocations() {
        return this.nextInvocations;
    }

    public Instant startTime() {
        return this.startTime;
    }

    public Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetAction());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduledActionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyScheduledActionResponse)) {
            return false;
        }
        ModifyScheduledActionResponse other = (ModifyScheduledActionResponse)((Object)obj);
        return Objects.equals(this.scheduledActionName(), other.scheduledActionName()) && Objects.equals(this.targetAction(), other.targetAction()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.iamRole(), other.iamRole()) && Objects.equals(this.scheduledActionDescription(), other.scheduledActionDescription()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.nextInvocations(), other.nextInvocations()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public String toString() {
        return ToString.builder((String)"ModifyScheduledActionResponse").add("ScheduledActionName", (Object)this.scheduledActionName()).add("TargetAction", (Object)this.targetAction()).add("Schedule", (Object)this.schedule()).add("IamRole", (Object)this.iamRole()).add("ScheduledActionDescription", (Object)this.scheduledActionDescription()).add("State", (Object)this.stateAsString()).add("NextInvocations", this.nextInvocations()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScheduledActionName": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionName()));
            }
            case "TargetAction": {
                return Optional.ofNullable(clazz.cast(this.targetAction()));
            }
            case "Schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "IamRole": {
                return Optional.ofNullable(clazz.cast(this.iamRole()));
            }
            case "ScheduledActionDescription": {
                return Optional.ofNullable(clazz.cast(this.scheduledActionDescription()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "NextInvocations": {
                return Optional.ofNullable(clazz.cast(this.nextInvocations()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModifyScheduledActionResponse, T> g) {
        return obj -> g.apply((ModifyScheduledActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String scheduledActionName;
        private ScheduledActionType targetAction;
        private String schedule;
        private String iamRole;
        private String scheduledActionDescription;
        private String state;
        private List<Instant> nextInvocations = DefaultSdkAutoConstructList.getInstance();
        private Instant startTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyScheduledActionResponse model) {
            super(model);
            this.scheduledActionName(model.scheduledActionName);
            this.targetAction(model.targetAction);
            this.schedule(model.schedule);
            this.iamRole(model.iamRole);
            this.scheduledActionDescription(model.scheduledActionDescription);
            this.state(model.state);
            this.nextInvocations(model.nextInvocations);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
        }

        public final String getScheduledActionName() {
            return this.scheduledActionName;
        }

        @Override
        public final Builder scheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
            return this;
        }

        public final void setScheduledActionName(String scheduledActionName) {
            this.scheduledActionName = scheduledActionName;
        }

        public final ScheduledActionType.Builder getTargetAction() {
            return this.targetAction != null ? this.targetAction.toBuilder() : null;
        }

        @Override
        public final Builder targetAction(ScheduledActionType targetAction) {
            this.targetAction = targetAction;
            return this;
        }

        public final void setTargetAction(ScheduledActionType.BuilderImpl targetAction) {
            this.targetAction = targetAction != null ? targetAction.build() : null;
        }

        public final String getSchedule() {
            return this.schedule;
        }

        @Override
        public final Builder schedule(String schedule) {
            this.schedule = schedule;
            return this;
        }

        public final void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public final String getIamRole() {
            return this.iamRole;
        }

        @Override
        public final Builder iamRole(String iamRole) {
            this.iamRole = iamRole;
            return this;
        }

        public final void setIamRole(String iamRole) {
            this.iamRole = iamRole;
        }

        public final String getScheduledActionDescription() {
            return this.scheduledActionDescription;
        }

        @Override
        public final Builder scheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
            return this;
        }

        public final void setScheduledActionDescription(String scheduledActionDescription) {
            this.scheduledActionDescription = scheduledActionDescription;
        }

        public final String getStateAsString() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScheduledActionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Collection<Instant> getNextInvocations() {
            return this.nextInvocations;
        }

        @Override
        public final Builder nextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledActionTimeListCopier.copy(nextInvocations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextInvocations(Instant ... nextInvocations) {
            this.nextInvocations(Arrays.asList(nextInvocations));
            return this;
        }

        public final void setNextInvocations(Collection<Instant> nextInvocations) {
            this.nextInvocations = ScheduledActionTimeListCopier.copy(nextInvocations);
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public ModifyScheduledActionResponse build() {
            return new ModifyScheduledActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ModifyScheduledActionResponse> {
        public Builder scheduledActionName(String var1);

        public Builder targetAction(ScheduledActionType var1);

        default public Builder targetAction(Consumer<ScheduledActionType.Builder> targetAction) {
            return this.targetAction((ScheduledActionType)((ScheduledActionType.Builder)ScheduledActionType.builder().applyMutation(targetAction)).build());
        }

        public Builder schedule(String var1);

        public Builder iamRole(String var1);

        public Builder scheduledActionDescription(String var1);

        public Builder state(String var1);

        public Builder state(ScheduledActionState var1);

        public Builder nextInvocations(Collection<Instant> var1);

        public Builder nextInvocations(Instant ... var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

