/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.redshift.RedshiftAsyncClient;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsRequest;
import software.amazon.awssdk.services.redshift.model.DescribeOrderableClusterOptionsResponse;
import software.amazon.awssdk.services.redshift.model.OrderableClusterOption;

public class DescribeOrderableClusterOptionsPublisher
implements SdkPublisher<DescribeOrderableClusterOptionsResponse> {
    private final RedshiftAsyncClient client;
    private final DescribeOrderableClusterOptionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeOrderableClusterOptionsPublisher(RedshiftAsyncClient client, DescribeOrderableClusterOptionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeOrderableClusterOptionsPublisher(RedshiftAsyncClient client, DescribeOrderableClusterOptionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeOrderableClusterOptionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeOrderableClusterOptionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OrderableClusterOption> orderableClusterOptions() {
        Function<DescribeOrderableClusterOptionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.orderableClusterOptions() != null) {
                return response.orderableClusterOptions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeOrderableClusterOptionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private final DescribeOrderableClusterOptionsPublisher resume(DescribeOrderableClusterOptionsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new DescribeOrderableClusterOptionsPublisher(this.client, (DescribeOrderableClusterOptionsRequest)((Object)this.firstRequest.toBuilder().marker(lastSuccessfulPage.marker()).build()));
        }
        return new DescribeOrderableClusterOptionsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super DescribeOrderableClusterOptionsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class DescribeOrderableClusterOptionsResponseFetcher
    implements AsyncPageFetcher<DescribeOrderableClusterOptionsResponse> {
        private DescribeOrderableClusterOptionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeOrderableClusterOptionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.marker());
        }

        public CompletableFuture<DescribeOrderableClusterOptionsResponse> nextPage(DescribeOrderableClusterOptionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeOrderableClusterOptionsPublisher.this.client.describeOrderableClusterOptions(DescribeOrderableClusterOptionsPublisher.this.firstRequest);
            }
            return DescribeOrderableClusterOptionsPublisher.this.client.describeOrderableClusterOptions((DescribeOrderableClusterOptionsRequest)((Object)DescribeOrderableClusterOptionsPublisher.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

