/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.ClusterListCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClustersResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClustersResponse> {
    private final String marker;
    private final List<Cluster> clusters;

    private DescribeClustersResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusters = builder.clusters;
    }

    public String marker() {
        return this.marker;
    }

    public List<Cluster> clusters() {
        return this.clusters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClustersResponse)) {
            return false;
        }
        DescribeClustersResponse other = (DescribeClustersResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.clusters(), other.clusters());
    }

    public String toString() {
        return ToString.builder((String)"DescribeClustersResponse").add("Marker", (Object)this.marker()).add("Clusters", this.clusters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Clusters": {
                return Optional.of(clazz.cast(this.clusters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<Cluster> clusters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClustersResponse model) {
            this.marker(model.marker);
            this.clusters(model.clusters);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Cluster.Builder> getClusters() {
            return this.clusters != null ? (Collection)this.clusters.stream().map(Cluster::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusters(Collection<Cluster> clusters) {
            this.clusters = ClusterListCopier.copy(clusters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusters(Cluster ... clusters) {
            this.clusters(Arrays.asList(clusters));
            return this;
        }

        public final void setClusters(Collection<Cluster.BuilderImpl> clusters) {
            this.clusters = ClusterListCopier.copyFromBuilder(clusters);
        }

        @Override
        public DescribeClustersResponse build() {
            return new DescribeClustersResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeClustersResponse> {
        public Builder marker(String var1);

        public Builder clusters(Collection<Cluster> var1);

        public Builder clusters(Cluster ... var1);
    }
}

