/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersResponse;
import software.amazon.awssdk.services.redshift.model.Parameter;

public final class DescribeClusterParametersPaginator
implements SdkIterable<DescribeClusterParametersResponse> {
    private final RedshiftClient client;
    private final DescribeClusterParametersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeClusterParametersPaginator(RedshiftClient client, DescribeClusterParametersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClusterParametersResponseFetcher();
    }

    public Iterator<DescribeClusterParametersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Parameter> parameters() {
        Function<DescribeClusterParametersResponse, Iterator> getIterator = response -> response != null ? response.parameters().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeClusterParametersResponseFetcher
    implements NextPageFetcher<DescribeClusterParametersResponse> {
        private DescribeClusterParametersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClusterParametersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeClusterParametersResponse nextPage(DescribeClusterParametersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClusterParametersPaginator.this.client.describeClusterParameters(DescribeClusterParametersPaginator.this.firstRequest);
            }
            return DescribeClusterParametersPaginator.this.client.describeClusterParameters((DescribeClusterParametersRequest)((Object)DescribeClusterParametersPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

