/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.redshift.model.RedshiftRequest;
import software.amazon.awssdk.services.redshift.model.SubnetIdentifierListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ModifyClusterSubnetGroupRequest
extends RedshiftRequest
implements ToCopyableBuilder<Builder, ModifyClusterSubnetGroupRequest> {
    private final String clusterSubnetGroupName;
    private final String description;
    private final List<String> subnetIds;

    private ModifyClusterSubnetGroupRequest(BuilderImpl builder) {
        super(builder);
        this.clusterSubnetGroupName = builder.clusterSubnetGroupName;
        this.description = builder.description;
        this.subnetIds = builder.subnetIds;
    }

    public String clusterSubnetGroupName() {
        return this.clusterSubnetGroupName;
    }

    public String description() {
        return this.description;
    }

    public List<String> subnetIds() {
        return this.subnetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSubnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetIds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyClusterSubnetGroupRequest)) {
            return false;
        }
        ModifyClusterSubnetGroupRequest other = (ModifyClusterSubnetGroupRequest)((Object)obj);
        return Objects.equals(this.clusterSubnetGroupName(), other.clusterSubnetGroupName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.subnetIds(), other.subnetIds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterSubnetGroupName() != null) {
            sb.append("ClusterSubnetGroupName: ").append(this.clusterSubnetGroupName()).append(",");
        }
        if (this.description() != null) {
            sb.append("Description: ").append(this.description()).append(",");
        }
        if (this.subnetIds() != null) {
            sb.append("SubnetIds: ").append(this.subnetIds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSubnetGroupName": {
                return Optional.of(clazz.cast(this.clusterSubnetGroupName()));
            }
            case "Description": {
                return Optional.of(clazz.cast(this.description()));
            }
            case "SubnetIds": {
                return Optional.of(clazz.cast(this.subnetIds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftRequest.BuilderImpl
    implements Builder {
        private String clusterSubnetGroupName;
        private String description;
        private List<String> subnetIds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModifyClusterSubnetGroupRequest model) {
            this.clusterSubnetGroupName(model.clusterSubnetGroupName);
            this.description(model.description);
            this.subnetIds(model.subnetIds);
        }

        public final String getClusterSubnetGroupName() {
            return this.clusterSubnetGroupName;
        }

        @Override
        public final Builder clusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
            return this;
        }

        public final void setClusterSubnetGroupName(String clusterSubnetGroupName) {
            this.clusterSubnetGroupName = clusterSubnetGroupName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final Collection<String> getSubnetIds() {
            return this.subnetIds;
        }

        @Override
        public final Builder subnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnetIds(String ... subnetIds) {
            this.subnetIds(Arrays.asList(subnetIds));
            return this;
        }

        public final void setSubnetIds(Collection<String> subnetIds) {
            this.subnetIds = SubnetIdentifierListCopier.copy(subnetIds);
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public ModifyClusterSubnetGroupRequest build() {
            return new ModifyClusterSubnetGroupRequest(this);
        }
    }

    public static interface Builder
    extends RedshiftRequest.Builder,
    CopyableBuilder<Builder, ModifyClusterSubnetGroupRequest> {
        public Builder clusterSubnetGroupName(String var1);

        public Builder description(String var1);

        public Builder subnetIds(Collection<String> var1);

        public Builder subnetIds(String ... var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

