/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.model.TagListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class HsmClientCertificate
implements ToCopyableBuilder<Builder, HsmClientCertificate> {
    private final String hsmClientCertificateIdentifier;
    private final String hsmClientCertificatePublicKey;
    private final List<Tag> tags;

    private HsmClientCertificate(BuilderImpl builder) {
        this.hsmClientCertificateIdentifier = builder.hsmClientCertificateIdentifier;
        this.hsmClientCertificatePublicKey = builder.hsmClientCertificatePublicKey;
        this.tags = builder.tags;
    }

    public String hsmClientCertificateIdentifier() {
        return this.hsmClientCertificateIdentifier;
    }

    public String hsmClientCertificatePublicKey() {
        return this.hsmClientCertificatePublicKey;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hsmClientCertificatePublicKey());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HsmClientCertificate)) {
            return false;
        }
        HsmClientCertificate other = (HsmClientCertificate)obj;
        return Objects.equals(this.hsmClientCertificateIdentifier(), other.hsmClientCertificateIdentifier()) && Objects.equals(this.hsmClientCertificatePublicKey(), other.hsmClientCertificatePublicKey()) && Objects.equals(this.tags(), other.tags());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.hsmClientCertificateIdentifier() != null) {
            sb.append("HsmClientCertificateIdentifier: ").append(this.hsmClientCertificateIdentifier()).append(",");
        }
        if (this.hsmClientCertificatePublicKey() != null) {
            sb.append("HsmClientCertificatePublicKey: ").append(this.hsmClientCertificatePublicKey()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HsmClientCertificateIdentifier": {
                return Optional.of(clazz.cast(this.hsmClientCertificateIdentifier()));
            }
            case "HsmClientCertificatePublicKey": {
                return Optional.of(clazz.cast(this.hsmClientCertificatePublicKey()));
            }
            case "Tags": {
                return Optional.of(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String hsmClientCertificateIdentifier;
        private String hsmClientCertificatePublicKey;
        private List<Tag> tags;

        private BuilderImpl() {
        }

        private BuilderImpl(HsmClientCertificate model) {
            this.hsmClientCertificateIdentifier(model.hsmClientCertificateIdentifier);
            this.hsmClientCertificatePublicKey(model.hsmClientCertificatePublicKey);
            this.tags(model.tags);
        }

        public final String getHsmClientCertificateIdentifier() {
            return this.hsmClientCertificateIdentifier;
        }

        @Override
        public final Builder hsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
            return this;
        }

        public final void setHsmClientCertificateIdentifier(String hsmClientCertificateIdentifier) {
            this.hsmClientCertificateIdentifier = hsmClientCertificateIdentifier;
        }

        public final String getHsmClientCertificatePublicKey() {
            return this.hsmClientCertificatePublicKey;
        }

        @Override
        public final Builder hsmClientCertificatePublicKey(String hsmClientCertificatePublicKey) {
            this.hsmClientCertificatePublicKey = hsmClientCertificatePublicKey;
            return this;
        }

        public final void setHsmClientCertificatePublicKey(String hsmClientCertificatePublicKey) {
            this.hsmClientCertificatePublicKey = hsmClientCertificatePublicKey;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public HsmClientCertificate build() {
            return new HsmClientCertificate(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, HsmClientCertificate> {
        public Builder hsmClientCertificateIdentifier(String var1);

        public Builder hsmClientCertificatePublicKey(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);
    }
}

