/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroupsCopier;
import software.amazon.awssdk.services.redshift.model.RedshiftResponse;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterSecurityGroupsResponse
extends RedshiftResponse
implements ToCopyableBuilder<Builder, DescribeClusterSecurityGroupsResponse> {
    private final String marker;
    private final List<ClusterSecurityGroup> clusterSecurityGroups;

    private DescribeClusterSecurityGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.marker = builder.marker;
        this.clusterSecurityGroups = builder.clusterSecurityGroups;
    }

    public String marker() {
        return this.marker;
    }

    public List<ClusterSecurityGroup> clusterSecurityGroups() {
        return this.clusterSecurityGroups;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSecurityGroups());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSecurityGroupsResponse)) {
            return false;
        }
        DescribeClusterSecurityGroupsResponse other = (DescribeClusterSecurityGroupsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.clusterSecurityGroups(), other.clusterSecurityGroups());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.clusterSecurityGroups() != null) {
            sb.append("ClusterSecurityGroups: ").append(this.clusterSecurityGroups()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ClusterSecurityGroups": {
                return Optional.of(clazz.cast(this.clusterSecurityGroups()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends RedshiftResponse.BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterSecurityGroup> clusterSecurityGroups;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSecurityGroupsResponse model) {
            this.marker(model.marker);
            this.clusterSecurityGroups(model.clusterSecurityGroups);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterSecurityGroup.Builder> getClusterSecurityGroups() {
            return this.clusterSecurityGroups != null ? (Collection)this.clusterSecurityGroups.stream().map(ClusterSecurityGroup::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterSecurityGroups(Collection<ClusterSecurityGroup> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupsCopier.copy(clusterSecurityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterSecurityGroups(ClusterSecurityGroup ... clusterSecurityGroups) {
            this.clusterSecurityGroups(Arrays.asList(clusterSecurityGroups));
            return this;
        }

        public final void setClusterSecurityGroups(Collection<ClusterSecurityGroup.BuilderImpl> clusterSecurityGroups) {
            this.clusterSecurityGroups = ClusterSecurityGroupsCopier.copyFromBuilder(clusterSecurityGroups);
        }

        @Override
        public DescribeClusterSecurityGroupsResponse build() {
            return new DescribeClusterSecurityGroupsResponse(this);
        }
    }

    public static interface Builder
    extends RedshiftResponse.Builder,
    CopyableBuilder<Builder, DescribeClusterSecurityGroupsResponse> {
        public Builder marker(String var1);

        public Builder clusterSecurityGroups(Collection<ClusterSecurityGroup> var1);

        public Builder clusterSecurityGroups(ClusterSecurityGroup ... var1);
    }
}

