/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.redshift.model.ClusterSecurityGroup;
import software.amazon.awssdk.services.redshift.model.EC2SecurityGroup;
import software.amazon.awssdk.services.redshift.model.IPRange;
import software.amazon.awssdk.services.redshift.model.Tag;
import software.amazon.awssdk.services.redshift.transform.EC2SecurityGroupUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.IPRangeUnmarshaller;
import software.amazon.awssdk.services.redshift.transform.TagUnmarshaller;

public class ClusterSecurityGroupUnmarshaller
implements Unmarshaller<ClusterSecurityGroup, StaxUnmarshallerContext> {
    private static final ClusterSecurityGroupUnmarshaller INSTANCE = new ClusterSecurityGroupUnmarshaller();

    public ClusterSecurityGroup unmarshall(StaxUnmarshallerContext context) throws Exception {
        ClusterSecurityGroup.Builder clusterSecurityGroup;
        block11: {
            clusterSecurityGroup = ClusterSecurityGroup.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                targetDepth += 3;
            }
            ArrayList<EC2SecurityGroup> ec2SecurityGroups = null;
            ArrayList<IPRange> ipRanges = null;
            ArrayList<Tag> tags = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    clusterSecurityGroup.ec2SecurityGroups(ec2SecurityGroups);
                    clusterSecurityGroup.ipRanges(ipRanges);
                    clusterSecurityGroup.tags(tags);
                    break block11;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("ClusterSecurityGroupName", targetDepth)) {
                        clusterSecurityGroup.clusterSecurityGroupName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Description", targetDepth)) {
                        clusterSecurityGroup.description(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("EC2SecurityGroups", targetDepth)) {
                        ec2SecurityGroups = new ArrayList<EC2SecurityGroup>();
                        continue;
                    }
                    if (context.testExpression("EC2SecurityGroups/EC2SecurityGroup", targetDepth)) {
                        ec2SecurityGroups.add(EC2SecurityGroupUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("IPRanges", targetDepth)) {
                        ipRanges = new ArrayList<IPRange>();
                        continue;
                    }
                    if (context.testExpression("IPRanges/IPRange", targetDepth)) {
                        ipRanges.add(IPRangeUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Tags", targetDepth)) {
                        tags = new ArrayList<Tag>();
                        continue;
                    }
                    if (!context.testExpression("Tags/Tag", targetDepth)) continue;
                    tags.add(TagUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            clusterSecurityGroup.ec2SecurityGroups(ec2SecurityGroups);
            clusterSecurityGroup.ipRanges(ipRanges);
            clusterSecurityGroup.tags(tags);
        }
        return (ClusterSecurityGroup)clusterSecurityGroup.build();
    }

    public static ClusterSecurityGroupUnmarshaller getInstance() {
        return INSTANCE;
    }
}

