/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.redshift.RedshiftClient;
import software.amazon.awssdk.services.redshift.model.Cluster;
import software.amazon.awssdk.services.redshift.model.DescribeClustersRequest;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;

public final class DescribeClustersPaginator
implements SdkIterable<DescribeClustersResponse> {
    private final RedshiftClient client;
    private final DescribeClustersRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeClustersPaginator(RedshiftClient client, DescribeClustersRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeClustersResponseFetcher();
    }

    public Iterator<DescribeClustersResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Cluster> clusters() {
        Function<DescribeClustersResponse, Iterator> getIterator = response -> response != null ? response.clusters().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeClustersResponseFetcher
    implements NextPageFetcher<DescribeClustersResponse> {
        private DescribeClustersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeClustersResponse previousPage) {
            return previousPage.marker() != null;
        }

        public DescribeClustersResponse nextPage(DescribeClustersResponse previousPage) {
            if (previousPage == null) {
                return DescribeClustersPaginator.this.client.describeClusters(DescribeClustersPaginator.this.firstRequest);
            }
            return DescribeClustersPaginator.this.client.describeClusters((DescribeClustersRequest)((Object)DescribeClustersPaginator.this.firstRequest.toBuilder().marker(previousPage.marker()).build()));
        }
    }
}

