/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOffering;
import software.amazon.awssdk.services.redshift.model.ReservedNodeOfferingListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeReservedNodeOfferingsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeReservedNodeOfferingsResponse> {
    private final String marker;
    private final List<ReservedNodeOffering> reservedNodeOfferings;

    private DescribeReservedNodeOfferingsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.reservedNodeOfferings = builder.reservedNodeOfferings;
    }

    public String marker() {
        return this.marker;
    }

    public List<ReservedNodeOffering> reservedNodeOfferings() {
        return this.reservedNodeOfferings;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodeOfferings());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeReservedNodeOfferingsResponse)) {
            return false;
        }
        DescribeReservedNodeOfferingsResponse other = (DescribeReservedNodeOfferingsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.reservedNodeOfferings(), other.reservedNodeOfferings());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.reservedNodeOfferings() != null) {
            sb.append("ReservedNodeOfferings: ").append(this.reservedNodeOfferings()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ReservedNodeOfferings": {
                return Optional.of(clazz.cast(this.reservedNodeOfferings()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ReservedNodeOffering> reservedNodeOfferings;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeReservedNodeOfferingsResponse model) {
            this.marker(model.marker);
            this.reservedNodeOfferings(model.reservedNodeOfferings);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ReservedNodeOffering.Builder> getReservedNodeOfferings() {
            return this.reservedNodeOfferings != null ? (Collection)this.reservedNodeOfferings.stream().map(ReservedNodeOffering::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder reservedNodeOfferings(Collection<ReservedNodeOffering> reservedNodeOfferings) {
            this.reservedNodeOfferings = ReservedNodeOfferingListCopier.copy(reservedNodeOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder reservedNodeOfferings(ReservedNodeOffering ... reservedNodeOfferings) {
            this.reservedNodeOfferings(Arrays.asList(reservedNodeOfferings));
            return this;
        }

        public final void setReservedNodeOfferings(Collection<ReservedNodeOffering.BuilderImpl> reservedNodeOfferings) {
            this.reservedNodeOfferings = ReservedNodeOfferingListCopier.copyFromBuilder(reservedNodeOfferings);
        }

        public DescribeReservedNodeOfferingsResponse build() {
            return new DescribeReservedNodeOfferingsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeReservedNodeOfferingsResponse> {
        public Builder marker(String var1);

        public Builder reservedNodeOfferings(Collection<ReservedNodeOffering> var1);

        public Builder reservedNodeOfferings(ReservedNodeOffering ... var1);
    }
}

