/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.ClusterVersion;
import software.amazon.awssdk.services.redshift.model.ClusterVersionListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeClusterVersionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeClusterVersionsResponse> {
    private final String marker;
    private final List<ClusterVersion> clusterVersions;

    private DescribeClusterVersionsResponse(BuilderImpl builder) {
        this.marker = builder.marker;
        this.clusterVersions = builder.clusterVersions;
    }

    public String marker() {
        return this.marker;
    }

    public List<ClusterVersion> clusterVersions() {
        return this.clusterVersions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterVersions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterVersionsResponse)) {
            return false;
        }
        DescribeClusterVersionsResponse other = (DescribeClusterVersionsResponse)((Object)obj);
        return Objects.equals(this.marker(), other.marker()) && Objects.equals(this.clusterVersions(), other.clusterVersions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.clusterVersions() != null) {
            sb.append("ClusterVersions: ").append(this.clusterVersions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "ClusterVersions": {
                return Optional.of(clazz.cast(this.clusterVersions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String marker;
        private List<ClusterVersion> clusterVersions;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterVersionsResponse model) {
            this.marker(model.marker);
            this.clusterVersions(model.clusterVersions);
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<ClusterVersion.Builder> getClusterVersions() {
            return this.clusterVersions != null ? (Collection)this.clusterVersions.stream().map(ClusterVersion::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder clusterVersions(Collection<ClusterVersion> clusterVersions) {
            this.clusterVersions = ClusterVersionListCopier.copy(clusterVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder clusterVersions(ClusterVersion ... clusterVersions) {
            this.clusterVersions(Arrays.asList(clusterVersions));
            return this;
        }

        public final void setClusterVersions(Collection<ClusterVersion.BuilderImpl> clusterVersions) {
            this.clusterVersions = ClusterVersionListCopier.copyFromBuilder(clusterVersions);
        }

        public DescribeClusterVersionsResponse build() {
            return new DescribeClusterVersionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeClusterVersionsResponse> {
        public Builder marker(String var1);

        public Builder clusterVersions(Collection<ClusterVersion> var1);

        public Builder clusterVersions(ClusterVersion ... var1);
    }
}

