/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.redshift.model.Parameter;
import software.amazon.awssdk.services.redshift.model.ParametersListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DefaultClusterParameters
implements ToCopyableBuilder<Builder, DefaultClusterParameters> {
    private final String parameterGroupFamily;
    private final String marker;
    private final List<Parameter> parameters;

    private DefaultClusterParameters(BuilderImpl builder) {
        this.parameterGroupFamily = builder.parameterGroupFamily;
        this.marker = builder.marker;
        this.parameters = builder.parameters;
    }

    public String parameterGroupFamily() {
        return this.parameterGroupFamily;
    }

    public String marker() {
        return this.marker;
    }

    public List<Parameter> parameters() {
        return this.parameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupFamily());
        hashCode = 31 * hashCode + Objects.hashCode(this.marker());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DefaultClusterParameters)) {
            return false;
        }
        DefaultClusterParameters other = (DefaultClusterParameters)obj;
        return Objects.equals(this.parameterGroupFamily(), other.parameterGroupFamily()) && Objects.equals(this.marker(), other.marker()) && Objects.equals(this.parameters(), other.parameters());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.parameterGroupFamily() != null) {
            sb.append("ParameterGroupFamily: ").append(this.parameterGroupFamily()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (this.parameters() != null) {
            sb.append("Parameters: ").append(this.parameters()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterGroupFamily": {
                return Optional.of(clazz.cast(this.parameterGroupFamily()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
            case "Parameters": {
                return Optional.of(clazz.cast(this.parameters()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterGroupFamily;
        private String marker;
        private List<Parameter> parameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DefaultClusterParameters model) {
            this.parameterGroupFamily(model.parameterGroupFamily);
            this.marker(model.marker);
            this.parameters(model.parameters);
        }

        public final String getParameterGroupFamily() {
            return this.parameterGroupFamily;
        }

        @Override
        public final Builder parameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
            return this;
        }

        public final void setParameterGroupFamily(String parameterGroupFamily) {
            this.parameterGroupFamily = parameterGroupFamily;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public final Collection<Parameter.Builder> getParameters() {
            return this.parameters != null ? (Collection)this.parameters.stream().map(Parameter::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder parameters(Collection<Parameter> parameters) {
            this.parameters = ParametersListCopier.copy(parameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder parameters(Parameter ... parameters) {
            this.parameters(Arrays.asList(parameters));
            return this;
        }

        public final void setParameters(Collection<Parameter.BuilderImpl> parameters) {
            this.parameters = ParametersListCopier.copyFromBuilder(parameters);
        }

        public DefaultClusterParameters build() {
            return new DefaultClusterParameters(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DefaultClusterParameters> {
        public Builder parameterGroupFamily(String var1);

        public Builder marker(String var1);

        public Builder parameters(Collection<Parameter> var1);

        public Builder parameters(Parameter ... var1);
    }
}

