/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.redshift.model.DescribeClusterSubnetGroupsRequest;

public class DescribeClusterSubnetGroupsRequestMarshaller
implements Marshaller<Request<DescribeClusterSubnetGroupsRequest>, DescribeClusterSubnetGroupsRequest> {
    public Request<DescribeClusterSubnetGroupsRequest> marshall(DescribeClusterSubnetGroupsRequest describeClusterSubnetGroupsRequest) {
        List<String> tagValuesList;
        List<String> tagKeysList;
        if (describeClusterSubnetGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClusterSubnetGroupsRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterSubnetGroups");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterSubnetGroupsRequest.clusterSubnetGroupName() != null) {
            request.addParameter("ClusterSubnetGroupName", StringUtils.fromString((String)describeClusterSubnetGroupsRequest.clusterSubnetGroupName()));
        }
        if (describeClusterSubnetGroupsRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClusterSubnetGroupsRequest.maxRecords()));
        }
        if (describeClusterSubnetGroupsRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClusterSubnetGroupsRequest.marker()));
        }
        if ((tagKeysList = describeClusterSubnetGroupsRequest.tagKeys()) != null) {
            if (!tagKeysList.isEmpty()) {
                int tagKeysListIndex = 1;
                for (String tagKeysListValue : tagKeysList) {
                    if (tagKeysListValue != null) {
                        request.addParameter("TagKeys.TagKey." + tagKeysListIndex, StringUtils.fromString((String)tagKeysListValue));
                    }
                    ++tagKeysListIndex;
                }
            } else {
                request.addParameter("TagKeys", "");
            }
        }
        if ((tagValuesList = describeClusterSubnetGroupsRequest.tagValues()) != null) {
            if (!tagValuesList.isEmpty()) {
                int tagValuesListIndex = 1;
                for (String tagValuesListValue : tagValuesList) {
                    if (tagValuesListValue != null) {
                        request.addParameter("TagValues.TagValue." + tagValuesListIndex, StringUtils.fromString((String)tagValuesListValue));
                    }
                    ++tagValuesListIndex;
                }
            } else {
                request.addParameter("TagValues", "");
            }
        }
        return request;
    }
}

