/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceResult;
import software.amazon.awssdk.core.ResponseMetadata;
import software.amazon.awssdk.services.redshift.model.ImportTablesCompletedCopier;
import software.amazon.awssdk.services.redshift.model.ImportTablesInProgressCopier;
import software.amazon.awssdk.services.redshift.model.ImportTablesNotStartedCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeResizeResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeResizeResponse> {
    private final String targetNodeType;
    private final Integer targetNumberOfNodes;
    private final String targetClusterType;
    private final String status;
    private final List<String> importTablesCompleted;
    private final List<String> importTablesInProgress;
    private final List<String> importTablesNotStarted;
    private final Double avgResizeRateInMegaBytesPerSecond;
    private final Long totalResizeDataInMegaBytes;
    private final Long progressInMegaBytes;
    private final Long elapsedTimeInSeconds;
    private final Long estimatedTimeToCompletionInSeconds;

    private DescribeResizeResponse(BuilderImpl builder) {
        this.targetNodeType = builder.targetNodeType;
        this.targetNumberOfNodes = builder.targetNumberOfNodes;
        this.targetClusterType = builder.targetClusterType;
        this.status = builder.status;
        this.importTablesCompleted = builder.importTablesCompleted;
        this.importTablesInProgress = builder.importTablesInProgress;
        this.importTablesNotStarted = builder.importTablesNotStarted;
        this.avgResizeRateInMegaBytesPerSecond = builder.avgResizeRateInMegaBytesPerSecond;
        this.totalResizeDataInMegaBytes = builder.totalResizeDataInMegaBytes;
        this.progressInMegaBytes = builder.progressInMegaBytes;
        this.elapsedTimeInSeconds = builder.elapsedTimeInSeconds;
        this.estimatedTimeToCompletionInSeconds = builder.estimatedTimeToCompletionInSeconds;
    }

    public String targetNodeType() {
        return this.targetNodeType;
    }

    public Integer targetNumberOfNodes() {
        return this.targetNumberOfNodes;
    }

    public String targetClusterType() {
        return this.targetClusterType;
    }

    public String status() {
        return this.status;
    }

    public List<String> importTablesCompleted() {
        return this.importTablesCompleted;
    }

    public List<String> importTablesInProgress() {
        return this.importTablesInProgress;
    }

    public List<String> importTablesNotStarted() {
        return this.importTablesNotStarted;
    }

    public Double avgResizeRateInMegaBytesPerSecond() {
        return this.avgResizeRateInMegaBytesPerSecond;
    }

    public Long totalResizeDataInMegaBytes() {
        return this.totalResizeDataInMegaBytes;
    }

    public Long progressInMegaBytes() {
        return this.progressInMegaBytes;
    }

    public Long elapsedTimeInSeconds() {
        return this.elapsedTimeInSeconds;
    }

    public Long estimatedTimeToCompletionInSeconds() {
        return this.estimatedTimeToCompletionInSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.targetNodeType() == null ? 0 : this.targetNodeType().hashCode());
        hashCode = 31 * hashCode + (this.targetNumberOfNodes() == null ? 0 : this.targetNumberOfNodes().hashCode());
        hashCode = 31 * hashCode + (this.targetClusterType() == null ? 0 : this.targetClusterType().hashCode());
        hashCode = 31 * hashCode + (this.status() == null ? 0 : this.status().hashCode());
        hashCode = 31 * hashCode + (this.importTablesCompleted() == null ? 0 : this.importTablesCompleted().hashCode());
        hashCode = 31 * hashCode + (this.importTablesInProgress() == null ? 0 : this.importTablesInProgress().hashCode());
        hashCode = 31 * hashCode + (this.importTablesNotStarted() == null ? 0 : this.importTablesNotStarted().hashCode());
        hashCode = 31 * hashCode + (this.avgResizeRateInMegaBytesPerSecond() == null ? 0 : this.avgResizeRateInMegaBytesPerSecond().hashCode());
        hashCode = 31 * hashCode + (this.totalResizeDataInMegaBytes() == null ? 0 : this.totalResizeDataInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.progressInMegaBytes() == null ? 0 : this.progressInMegaBytes().hashCode());
        hashCode = 31 * hashCode + (this.elapsedTimeInSeconds() == null ? 0 : this.elapsedTimeInSeconds().hashCode());
        hashCode = 31 * hashCode + (this.estimatedTimeToCompletionInSeconds() == null ? 0 : this.estimatedTimeToCompletionInSeconds().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeResizeResponse)) {
            return false;
        }
        DescribeResizeResponse other = (DescribeResizeResponse)((Object)obj);
        if (other.targetNodeType() == null ^ this.targetNodeType() == null) {
            return false;
        }
        if (other.targetNodeType() != null && !other.targetNodeType().equals(this.targetNodeType())) {
            return false;
        }
        if (other.targetNumberOfNodes() == null ^ this.targetNumberOfNodes() == null) {
            return false;
        }
        if (other.targetNumberOfNodes() != null && !other.targetNumberOfNodes().equals(this.targetNumberOfNodes())) {
            return false;
        }
        if (other.targetClusterType() == null ^ this.targetClusterType() == null) {
            return false;
        }
        if (other.targetClusterType() != null && !other.targetClusterType().equals(this.targetClusterType())) {
            return false;
        }
        if (other.status() == null ^ this.status() == null) {
            return false;
        }
        if (other.status() != null && !other.status().equals(this.status())) {
            return false;
        }
        if (other.importTablesCompleted() == null ^ this.importTablesCompleted() == null) {
            return false;
        }
        if (other.importTablesCompleted() != null && !other.importTablesCompleted().equals(this.importTablesCompleted())) {
            return false;
        }
        if (other.importTablesInProgress() == null ^ this.importTablesInProgress() == null) {
            return false;
        }
        if (other.importTablesInProgress() != null && !other.importTablesInProgress().equals(this.importTablesInProgress())) {
            return false;
        }
        if (other.importTablesNotStarted() == null ^ this.importTablesNotStarted() == null) {
            return false;
        }
        if (other.importTablesNotStarted() != null && !other.importTablesNotStarted().equals(this.importTablesNotStarted())) {
            return false;
        }
        if (other.avgResizeRateInMegaBytesPerSecond() == null ^ this.avgResizeRateInMegaBytesPerSecond() == null) {
            return false;
        }
        if (other.avgResizeRateInMegaBytesPerSecond() != null && !other.avgResizeRateInMegaBytesPerSecond().equals(this.avgResizeRateInMegaBytesPerSecond())) {
            return false;
        }
        if (other.totalResizeDataInMegaBytes() == null ^ this.totalResizeDataInMegaBytes() == null) {
            return false;
        }
        if (other.totalResizeDataInMegaBytes() != null && !other.totalResizeDataInMegaBytes().equals(this.totalResizeDataInMegaBytes())) {
            return false;
        }
        if (other.progressInMegaBytes() == null ^ this.progressInMegaBytes() == null) {
            return false;
        }
        if (other.progressInMegaBytes() != null && !other.progressInMegaBytes().equals(this.progressInMegaBytes())) {
            return false;
        }
        if (other.elapsedTimeInSeconds() == null ^ this.elapsedTimeInSeconds() == null) {
            return false;
        }
        if (other.elapsedTimeInSeconds() != null && !other.elapsedTimeInSeconds().equals(this.elapsedTimeInSeconds())) {
            return false;
        }
        if (other.estimatedTimeToCompletionInSeconds() == null ^ this.estimatedTimeToCompletionInSeconds() == null) {
            return false;
        }
        return other.estimatedTimeToCompletionInSeconds() == null || other.estimatedTimeToCompletionInSeconds().equals(this.estimatedTimeToCompletionInSeconds());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.targetNodeType() != null) {
            sb.append("TargetNodeType: ").append(this.targetNodeType()).append(",");
        }
        if (this.targetNumberOfNodes() != null) {
            sb.append("TargetNumberOfNodes: ").append(this.targetNumberOfNodes()).append(",");
        }
        if (this.targetClusterType() != null) {
            sb.append("TargetClusterType: ").append(this.targetClusterType()).append(",");
        }
        if (this.status() != null) {
            sb.append("Status: ").append(this.status()).append(",");
        }
        if (this.importTablesCompleted() != null) {
            sb.append("ImportTablesCompleted: ").append(this.importTablesCompleted()).append(",");
        }
        if (this.importTablesInProgress() != null) {
            sb.append("ImportTablesInProgress: ").append(this.importTablesInProgress()).append(",");
        }
        if (this.importTablesNotStarted() != null) {
            sb.append("ImportTablesNotStarted: ").append(this.importTablesNotStarted()).append(",");
        }
        if (this.avgResizeRateInMegaBytesPerSecond() != null) {
            sb.append("AvgResizeRateInMegaBytesPerSecond: ").append(this.avgResizeRateInMegaBytesPerSecond()).append(",");
        }
        if (this.totalResizeDataInMegaBytes() != null) {
            sb.append("TotalResizeDataInMegaBytes: ").append(this.totalResizeDataInMegaBytes()).append(",");
        }
        if (this.progressInMegaBytes() != null) {
            sb.append("ProgressInMegaBytes: ").append(this.progressInMegaBytes()).append(",");
        }
        if (this.elapsedTimeInSeconds() != null) {
            sb.append("ElapsedTimeInSeconds: ").append(this.elapsedTimeInSeconds()).append(",");
        }
        if (this.estimatedTimeToCompletionInSeconds() != null) {
            sb.append("EstimatedTimeToCompletionInSeconds: ").append(this.estimatedTimeToCompletionInSeconds()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetNodeType": {
                return Optional.of(clazz.cast(this.targetNodeType()));
            }
            case "TargetNumberOfNodes": {
                return Optional.of(clazz.cast(this.targetNumberOfNodes()));
            }
            case "TargetClusterType": {
                return Optional.of(clazz.cast(this.targetClusterType()));
            }
            case "Status": {
                return Optional.of(clazz.cast(this.status()));
            }
            case "ImportTablesCompleted": {
                return Optional.of(clazz.cast(this.importTablesCompleted()));
            }
            case "ImportTablesInProgress": {
                return Optional.of(clazz.cast(this.importTablesInProgress()));
            }
            case "ImportTablesNotStarted": {
                return Optional.of(clazz.cast(this.importTablesNotStarted()));
            }
            case "AvgResizeRateInMegaBytesPerSecond": {
                return Optional.of(clazz.cast(this.avgResizeRateInMegaBytesPerSecond()));
            }
            case "TotalResizeDataInMegaBytes": {
                return Optional.of(clazz.cast(this.totalResizeDataInMegaBytes()));
            }
            case "ProgressInMegaBytes": {
                return Optional.of(clazz.cast(this.progressInMegaBytes()));
            }
            case "ElapsedTimeInSeconds": {
                return Optional.of(clazz.cast(this.elapsedTimeInSeconds()));
            }
            case "EstimatedTimeToCompletionInSeconds": {
                return Optional.of(clazz.cast(this.estimatedTimeToCompletionInSeconds()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String targetNodeType;
        private Integer targetNumberOfNodes;
        private String targetClusterType;
        private String status;
        private List<String> importTablesCompleted;
        private List<String> importTablesInProgress;
        private List<String> importTablesNotStarted;
        private Double avgResizeRateInMegaBytesPerSecond;
        private Long totalResizeDataInMegaBytes;
        private Long progressInMegaBytes;
        private Long elapsedTimeInSeconds;
        private Long estimatedTimeToCompletionInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeResizeResponse model) {
            this.targetNodeType(model.targetNodeType);
            this.targetNumberOfNodes(model.targetNumberOfNodes);
            this.targetClusterType(model.targetClusterType);
            this.status(model.status);
            this.importTablesCompleted(model.importTablesCompleted);
            this.importTablesInProgress(model.importTablesInProgress);
            this.importTablesNotStarted(model.importTablesNotStarted);
            this.avgResizeRateInMegaBytesPerSecond(model.avgResizeRateInMegaBytesPerSecond);
            this.totalResizeDataInMegaBytes(model.totalResizeDataInMegaBytes);
            this.progressInMegaBytes(model.progressInMegaBytes);
            this.elapsedTimeInSeconds(model.elapsedTimeInSeconds);
            this.estimatedTimeToCompletionInSeconds(model.estimatedTimeToCompletionInSeconds);
        }

        public final String getTargetNodeType() {
            return this.targetNodeType;
        }

        @Override
        public final Builder targetNodeType(String targetNodeType) {
            this.targetNodeType = targetNodeType;
            return this;
        }

        public final void setTargetNodeType(String targetNodeType) {
            this.targetNodeType = targetNodeType;
        }

        public final Integer getTargetNumberOfNodes() {
            return this.targetNumberOfNodes;
        }

        @Override
        public final Builder targetNumberOfNodes(Integer targetNumberOfNodes) {
            this.targetNumberOfNodes = targetNumberOfNodes;
            return this;
        }

        public final void setTargetNumberOfNodes(Integer targetNumberOfNodes) {
            this.targetNumberOfNodes = targetNumberOfNodes;
        }

        public final String getTargetClusterType() {
            return this.targetClusterType;
        }

        @Override
        public final Builder targetClusterType(String targetClusterType) {
            this.targetClusterType = targetClusterType;
            return this;
        }

        public final void setTargetClusterType(String targetClusterType) {
            this.targetClusterType = targetClusterType;
        }

        public final String getStatus() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Collection<String> getImportTablesCompleted() {
            return this.importTablesCompleted;
        }

        @Override
        public final Builder importTablesCompleted(Collection<String> importTablesCompleted) {
            this.importTablesCompleted = ImportTablesCompletedCopier.copy(importTablesCompleted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesCompleted(String ... importTablesCompleted) {
            this.importTablesCompleted(Arrays.asList(importTablesCompleted));
            return this;
        }

        public final void setImportTablesCompleted(Collection<String> importTablesCompleted) {
            this.importTablesCompleted = ImportTablesCompletedCopier.copy(importTablesCompleted);
        }

        public final Collection<String> getImportTablesInProgress() {
            return this.importTablesInProgress;
        }

        @Override
        public final Builder importTablesInProgress(Collection<String> importTablesInProgress) {
            this.importTablesInProgress = ImportTablesInProgressCopier.copy(importTablesInProgress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesInProgress(String ... importTablesInProgress) {
            this.importTablesInProgress(Arrays.asList(importTablesInProgress));
            return this;
        }

        public final void setImportTablesInProgress(Collection<String> importTablesInProgress) {
            this.importTablesInProgress = ImportTablesInProgressCopier.copy(importTablesInProgress);
        }

        public final Collection<String> getImportTablesNotStarted() {
            return this.importTablesNotStarted;
        }

        @Override
        public final Builder importTablesNotStarted(Collection<String> importTablesNotStarted) {
            this.importTablesNotStarted = ImportTablesNotStartedCopier.copy(importTablesNotStarted);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder importTablesNotStarted(String ... importTablesNotStarted) {
            this.importTablesNotStarted(Arrays.asList(importTablesNotStarted));
            return this;
        }

        public final void setImportTablesNotStarted(Collection<String> importTablesNotStarted) {
            this.importTablesNotStarted = ImportTablesNotStartedCopier.copy(importTablesNotStarted);
        }

        public final Double getAvgResizeRateInMegaBytesPerSecond() {
            return this.avgResizeRateInMegaBytesPerSecond;
        }

        @Override
        public final Builder avgResizeRateInMegaBytesPerSecond(Double avgResizeRateInMegaBytesPerSecond) {
            this.avgResizeRateInMegaBytesPerSecond = avgResizeRateInMegaBytesPerSecond;
            return this;
        }

        public final void setAvgResizeRateInMegaBytesPerSecond(Double avgResizeRateInMegaBytesPerSecond) {
            this.avgResizeRateInMegaBytesPerSecond = avgResizeRateInMegaBytesPerSecond;
        }

        public final Long getTotalResizeDataInMegaBytes() {
            return this.totalResizeDataInMegaBytes;
        }

        @Override
        public final Builder totalResizeDataInMegaBytes(Long totalResizeDataInMegaBytes) {
            this.totalResizeDataInMegaBytes = totalResizeDataInMegaBytes;
            return this;
        }

        public final void setTotalResizeDataInMegaBytes(Long totalResizeDataInMegaBytes) {
            this.totalResizeDataInMegaBytes = totalResizeDataInMegaBytes;
        }

        public final Long getProgressInMegaBytes() {
            return this.progressInMegaBytes;
        }

        @Override
        public final Builder progressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
            return this;
        }

        public final void setProgressInMegaBytes(Long progressInMegaBytes) {
            this.progressInMegaBytes = progressInMegaBytes;
        }

        public final Long getElapsedTimeInSeconds() {
            return this.elapsedTimeInSeconds;
        }

        @Override
        public final Builder elapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
            return this;
        }

        public final void setElapsedTimeInSeconds(Long elapsedTimeInSeconds) {
            this.elapsedTimeInSeconds = elapsedTimeInSeconds;
        }

        public final Long getEstimatedTimeToCompletionInSeconds() {
            return this.estimatedTimeToCompletionInSeconds;
        }

        @Override
        public final Builder estimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
            return this;
        }

        public final void setEstimatedTimeToCompletionInSeconds(Long estimatedTimeToCompletionInSeconds) {
            this.estimatedTimeToCompletionInSeconds = estimatedTimeToCompletionInSeconds;
        }

        public DescribeResizeResponse build() {
            return new DescribeResizeResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeResizeResponse> {
        public Builder targetNodeType(String var1);

        public Builder targetNumberOfNodes(Integer var1);

        public Builder targetClusterType(String var1);

        public Builder status(String var1);

        public Builder importTablesCompleted(Collection<String> var1);

        public Builder importTablesCompleted(String ... var1);

        public Builder importTablesInProgress(Collection<String> var1);

        public Builder importTablesInProgress(String ... var1);

        public Builder importTablesNotStarted(Collection<String> var1);

        public Builder importTablesNotStarted(String ... var1);

        public Builder avgResizeRateInMegaBytesPerSecond(Double var1);

        public Builder totalResizeDataInMegaBytes(Long var1);

        public Builder progressInMegaBytes(Long var1);

        public Builder elapsedTimeInSeconds(Long var1);

        public Builder estimatedTimeToCompletionInSeconds(Long var1);
    }
}

