/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeOrderableClusterOptionsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, DescribeOrderableClusterOptionsRequest> {
    private final String clusterVersion;
    private final String nodeType;
    private final Integer maxRecords;
    private final String marker;

    private DescribeOrderableClusterOptionsRequest(BuilderImpl builder) {
        this.clusterVersion = builder.clusterVersion;
        this.nodeType = builder.nodeType;
        this.maxRecords = builder.maxRecords;
        this.marker = builder.marker;
    }

    public String clusterVersion() {
        return this.clusterVersion;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String marker() {
        return this.marker;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterVersion() == null ? 0 : this.clusterVersion().hashCode());
        hashCode = 31 * hashCode + (this.nodeType() == null ? 0 : this.nodeType().hashCode());
        hashCode = 31 * hashCode + (this.maxRecords() == null ? 0 : this.maxRecords().hashCode());
        hashCode = 31 * hashCode + (this.marker() == null ? 0 : this.marker().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeOrderableClusterOptionsRequest)) {
            return false;
        }
        DescribeOrderableClusterOptionsRequest other = (DescribeOrderableClusterOptionsRequest)((Object)obj);
        if (other.clusterVersion() == null ^ this.clusterVersion() == null) {
            return false;
        }
        if (other.clusterVersion() != null && !other.clusterVersion().equals(this.clusterVersion())) {
            return false;
        }
        if (other.nodeType() == null ^ this.nodeType() == null) {
            return false;
        }
        if (other.nodeType() != null && !other.nodeType().equals(this.nodeType())) {
            return false;
        }
        if (other.maxRecords() == null ^ this.maxRecords() == null) {
            return false;
        }
        if (other.maxRecords() != null && !other.maxRecords().equals(this.maxRecords())) {
            return false;
        }
        if (other.marker() == null ^ this.marker() == null) {
            return false;
        }
        return other.marker() == null || other.marker().equals(this.marker());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.clusterVersion() != null) {
            sb.append("ClusterVersion: ").append(this.clusterVersion()).append(",");
        }
        if (this.nodeType() != null) {
            sb.append("NodeType: ").append(this.nodeType()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.marker() != null) {
            sb.append("Marker: ").append(this.marker()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterVersion": {
                return Optional.of(clazz.cast(this.clusterVersion()));
            }
            case "NodeType": {
                return Optional.of(clazz.cast(this.nodeType()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "Marker": {
                return Optional.of(clazz.cast(this.marker()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterVersion;
        private String nodeType;
        private Integer maxRecords;
        private String marker;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeOrderableClusterOptionsRequest model) {
            this.clusterVersion(model.clusterVersion);
            this.nodeType(model.nodeType);
            this.maxRecords(model.maxRecords);
            this.marker(model.marker);
        }

        public final String getClusterVersion() {
            return this.clusterVersion;
        }

        @Override
        public final Builder clusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
            return this;
        }

        public final void setClusterVersion(String clusterVersion) {
            this.clusterVersion = clusterVersion;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getMarker() {
            return this.marker;
        }

        @Override
        public final Builder marker(String marker) {
            this.marker = marker;
            return this;
        }

        public final void setMarker(String marker) {
            this.marker = marker;
        }

        public DescribeOrderableClusterOptionsRequest build() {
            return new DescribeOrderableClusterOptionsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeOrderableClusterOptionsRequest> {
        public Builder clusterVersion(String var1);

        public Builder nodeType(String var1);

        public Builder maxRecords(Integer var1);

        public Builder marker(String var1);
    }
}

