/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Optional;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CopyClusterSnapshotRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, CopyClusterSnapshotRequest> {
    private final String sourceSnapshotIdentifier;
    private final String sourceSnapshotClusterIdentifier;
    private final String targetSnapshotIdentifier;

    private CopyClusterSnapshotRequest(BuilderImpl builder) {
        this.sourceSnapshotIdentifier = builder.sourceSnapshotIdentifier;
        this.sourceSnapshotClusterIdentifier = builder.sourceSnapshotClusterIdentifier;
        this.targetSnapshotIdentifier = builder.targetSnapshotIdentifier;
    }

    public String sourceSnapshotIdentifier() {
        return this.sourceSnapshotIdentifier;
    }

    public String sourceSnapshotClusterIdentifier() {
        return this.sourceSnapshotClusterIdentifier;
    }

    public String targetSnapshotIdentifier() {
        return this.targetSnapshotIdentifier;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceSnapshotIdentifier() == null ? 0 : this.sourceSnapshotIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.sourceSnapshotClusterIdentifier() == null ? 0 : this.sourceSnapshotClusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.targetSnapshotIdentifier() == null ? 0 : this.targetSnapshotIdentifier().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyClusterSnapshotRequest)) {
            return false;
        }
        CopyClusterSnapshotRequest other = (CopyClusterSnapshotRequest)((Object)obj);
        if (other.sourceSnapshotIdentifier() == null ^ this.sourceSnapshotIdentifier() == null) {
            return false;
        }
        if (other.sourceSnapshotIdentifier() != null && !other.sourceSnapshotIdentifier().equals(this.sourceSnapshotIdentifier())) {
            return false;
        }
        if (other.sourceSnapshotClusterIdentifier() == null ^ this.sourceSnapshotClusterIdentifier() == null) {
            return false;
        }
        if (other.sourceSnapshotClusterIdentifier() != null && !other.sourceSnapshotClusterIdentifier().equals(this.sourceSnapshotClusterIdentifier())) {
            return false;
        }
        if (other.targetSnapshotIdentifier() == null ^ this.targetSnapshotIdentifier() == null) {
            return false;
        }
        return other.targetSnapshotIdentifier() == null || other.targetSnapshotIdentifier().equals(this.targetSnapshotIdentifier());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.sourceSnapshotIdentifier() != null) {
            sb.append("SourceSnapshotIdentifier: ").append(this.sourceSnapshotIdentifier()).append(",");
        }
        if (this.sourceSnapshotClusterIdentifier() != null) {
            sb.append("SourceSnapshotClusterIdentifier: ").append(this.sourceSnapshotClusterIdentifier()).append(",");
        }
        if (this.targetSnapshotIdentifier() != null) {
            sb.append("TargetSnapshotIdentifier: ").append(this.targetSnapshotIdentifier()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.sourceSnapshotIdentifier()));
            }
            case "SourceSnapshotClusterIdentifier": {
                return Optional.of(clazz.cast(this.sourceSnapshotClusterIdentifier()));
            }
            case "TargetSnapshotIdentifier": {
                return Optional.of(clazz.cast(this.targetSnapshotIdentifier()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceSnapshotIdentifier;
        private String sourceSnapshotClusterIdentifier;
        private String targetSnapshotIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyClusterSnapshotRequest model) {
            this.sourceSnapshotIdentifier(model.sourceSnapshotIdentifier);
            this.sourceSnapshotClusterIdentifier(model.sourceSnapshotClusterIdentifier);
            this.targetSnapshotIdentifier(model.targetSnapshotIdentifier);
        }

        public final String getSourceSnapshotIdentifier() {
            return this.sourceSnapshotIdentifier;
        }

        @Override
        public final Builder sourceSnapshotIdentifier(String sourceSnapshotIdentifier) {
            this.sourceSnapshotIdentifier = sourceSnapshotIdentifier;
            return this;
        }

        public final void setSourceSnapshotIdentifier(String sourceSnapshotIdentifier) {
            this.sourceSnapshotIdentifier = sourceSnapshotIdentifier;
        }

        public final String getSourceSnapshotClusterIdentifier() {
            return this.sourceSnapshotClusterIdentifier;
        }

        @Override
        public final Builder sourceSnapshotClusterIdentifier(String sourceSnapshotClusterIdentifier) {
            this.sourceSnapshotClusterIdentifier = sourceSnapshotClusterIdentifier;
            return this;
        }

        public final void setSourceSnapshotClusterIdentifier(String sourceSnapshotClusterIdentifier) {
            this.sourceSnapshotClusterIdentifier = sourceSnapshotClusterIdentifier;
        }

        public final String getTargetSnapshotIdentifier() {
            return this.targetSnapshotIdentifier;
        }

        @Override
        public final Builder targetSnapshotIdentifier(String targetSnapshotIdentifier) {
            this.targetSnapshotIdentifier = targetSnapshotIdentifier;
            return this;
        }

        public final void setTargetSnapshotIdentifier(String targetSnapshotIdentifier) {
            this.targetSnapshotIdentifier = targetSnapshotIdentifier;
        }

        public CopyClusterSnapshotRequest build() {
            return new CopyClusterSnapshotRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, CopyClusterSnapshotRequest> {
        public Builder sourceSnapshotIdentifier(String var1);

        public Builder sourceSnapshotClusterIdentifier(String var1);

        public Builder targetSnapshotIdentifier(String var1);
    }
}

