/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ClusterSnapshotCopyStatus
implements ToCopyableBuilder<Builder, ClusterSnapshotCopyStatus> {
    private final String destinationRegion;
    private final Long retentionPeriod;
    private final String snapshotCopyGrantName;

    private ClusterSnapshotCopyStatus(BuilderImpl builder) {
        this.destinationRegion = builder.destinationRegion;
        this.retentionPeriod = builder.retentionPeriod;
        this.snapshotCopyGrantName = builder.snapshotCopyGrantName;
    }

    public String destinationRegion() {
        return this.destinationRegion;
    }

    public Long retentionPeriod() {
        return this.retentionPeriod;
    }

    public String snapshotCopyGrantName() {
        return this.snapshotCopyGrantName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.destinationRegion() == null ? 0 : this.destinationRegion().hashCode());
        hashCode = 31 * hashCode + (this.retentionPeriod() == null ? 0 : this.retentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.snapshotCopyGrantName() == null ? 0 : this.snapshotCopyGrantName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterSnapshotCopyStatus)) {
            return false;
        }
        ClusterSnapshotCopyStatus other = (ClusterSnapshotCopyStatus)obj;
        if (other.destinationRegion() == null ^ this.destinationRegion() == null) {
            return false;
        }
        if (other.destinationRegion() != null && !other.destinationRegion().equals(this.destinationRegion())) {
            return false;
        }
        if (other.retentionPeriod() == null ^ this.retentionPeriod() == null) {
            return false;
        }
        if (other.retentionPeriod() != null && !other.retentionPeriod().equals(this.retentionPeriod())) {
            return false;
        }
        if (other.snapshotCopyGrantName() == null ^ this.snapshotCopyGrantName() == null) {
            return false;
        }
        return other.snapshotCopyGrantName() == null || other.snapshotCopyGrantName().equals(this.snapshotCopyGrantName());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.destinationRegion() != null) {
            sb.append("DestinationRegion: ").append(this.destinationRegion()).append(",");
        }
        if (this.retentionPeriod() != null) {
            sb.append("RetentionPeriod: ").append(this.retentionPeriod()).append(",");
        }
        if (this.snapshotCopyGrantName() != null) {
            sb.append("SnapshotCopyGrantName: ").append(this.snapshotCopyGrantName()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DestinationRegion": {
                return Optional.of(clazz.cast(this.destinationRegion()));
            }
            case "RetentionPeriod": {
                return Optional.of(clazz.cast(this.retentionPeriod()));
            }
            case "SnapshotCopyGrantName": {
                return Optional.of(clazz.cast(this.snapshotCopyGrantName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String destinationRegion;
        private Long retentionPeriod;
        private String snapshotCopyGrantName;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterSnapshotCopyStatus model) {
            this.destinationRegion(model.destinationRegion);
            this.retentionPeriod(model.retentionPeriod);
            this.snapshotCopyGrantName(model.snapshotCopyGrantName);
        }

        public final String getDestinationRegion() {
            return this.destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final Long getRetentionPeriod() {
            return this.retentionPeriod;
        }

        @Override
        public final Builder retentionPeriod(Long retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
            return this;
        }

        public final void setRetentionPeriod(Long retentionPeriod) {
            this.retentionPeriod = retentionPeriod;
        }

        public final String getSnapshotCopyGrantName() {
            return this.snapshotCopyGrantName;
        }

        @Override
        public final Builder snapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
            return this;
        }

        public final void setSnapshotCopyGrantName(String snapshotCopyGrantName) {
            this.snapshotCopyGrantName = snapshotCopyGrantName;
        }

        public ClusterSnapshotCopyStatus build() {
            return new ClusterSnapshotCopyStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ClusterSnapshotCopyStatus> {
        public Builder destinationRegion(String var1);

        public Builder retentionPeriod(Long var1);

        public Builder snapshotCopyGrantName(String var1);
    }
}

