/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.Parameter;
import software.amazon.awssdk.services.redshift.model.ResetClusterParameterGroupRequest;
import software.amazon.awssdk.util.StringUtils;

public class ResetClusterParameterGroupRequestMarshaller
implements Marshaller<Request<ResetClusterParameterGroupRequest>, ResetClusterParameterGroupRequest> {
    public Request<ResetClusterParameterGroupRequest> marshall(ResetClusterParameterGroupRequest resetClusterParameterGroupRequest) {
        List<Parameter> parametersList;
        if (resetClusterParameterGroupRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)resetClusterParameterGroupRequest, "RedshiftClient");
        request.addParameter("Action", "ResetClusterParameterGroup");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (resetClusterParameterGroupRequest.parameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringUtils.fromString((String)resetClusterParameterGroupRequest.parameterGroupName()));
        }
        if (resetClusterParameterGroupRequest.resetAllParameters() != null) {
            request.addParameter("ResetAllParameters", StringUtils.fromBoolean((Boolean)resetClusterParameterGroupRequest.resetAllParameters()));
        }
        if ((parametersList = resetClusterParameterGroupRequest.parameters()) != null) {
            if (!parametersList.isEmpty()) {
                int parametersListIndex = 1;
                for (Parameter parametersListValue : parametersList) {
                    if (parametersListValue.parameterName() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterName", StringUtils.fromString((String)parametersListValue.parameterName()));
                    }
                    if (parametersListValue.parameterValue() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ParameterValue", StringUtils.fromString((String)parametersListValue.parameterValue()));
                    }
                    if (parametersListValue.description() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".Description", StringUtils.fromString((String)parametersListValue.description()));
                    }
                    if (parametersListValue.source() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".Source", StringUtils.fromString((String)parametersListValue.source()));
                    }
                    if (parametersListValue.dataType() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".DataType", StringUtils.fromString((String)parametersListValue.dataType()));
                    }
                    if (parametersListValue.allowedValues() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".AllowedValues", StringUtils.fromString((String)parametersListValue.allowedValues()));
                    }
                    if (parametersListValue.applyType() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".ApplyType", StringUtils.fromString((String)parametersListValue.applyType()));
                    }
                    if (parametersListValue.isModifiable() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".IsModifiable", StringUtils.fromBoolean((Boolean)parametersListValue.isModifiable()));
                    }
                    if (parametersListValue.minimumEngineVersion() != null) {
                        request.addParameter("Parameters.Parameter." + parametersListIndex + ".MinimumEngineVersion", StringUtils.fromString((String)parametersListValue.minimumEngineVersion()));
                    }
                    ++parametersListIndex;
                }
            } else {
                request.addParameter("Parameters", "");
            }
        }
        return request;
    }
}

