/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.DescribeClusterParametersRequest;
import software.amazon.awssdk.util.StringUtils;

public class DescribeClusterParametersRequestMarshaller
implements Marshaller<Request<DescribeClusterParametersRequest>, DescribeClusterParametersRequest> {
    public Request<DescribeClusterParametersRequest> marshall(DescribeClusterParametersRequest describeClusterParametersRequest) {
        if (describeClusterParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeClusterParametersRequest, "RedshiftClient");
        request.addParameter("Action", "DescribeClusterParameters");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeClusterParametersRequest.parameterGroupName() != null) {
            request.addParameter("ParameterGroupName", StringUtils.fromString((String)describeClusterParametersRequest.parameterGroupName()));
        }
        if (describeClusterParametersRequest.source() != null) {
            request.addParameter("Source", StringUtils.fromString((String)describeClusterParametersRequest.source()));
        }
        if (describeClusterParametersRequest.maxRecords() != null) {
            request.addParameter("MaxRecords", StringUtils.fromInteger((Integer)describeClusterParametersRequest.maxRecords()));
        }
        if (describeClusterParametersRequest.marker() != null) {
            request.addParameter("Marker", StringUtils.fromString((String)describeClusterParametersRequest.marker()));
        }
        return request;
    }
}

