/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.model;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class EnableLoggingRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, EnableLoggingRequest> {
    private final String clusterIdentifier;
    private final String bucketName;
    private final String s3KeyPrefix;

    private EnableLoggingRequest(BuilderImpl builder) {
        this.clusterIdentifier = builder.clusterIdentifier;
        this.bucketName = builder.bucketName;
        this.s3KeyPrefix = builder.s3KeyPrefix;
    }

    public String clusterIdentifier() {
        return this.clusterIdentifier;
    }

    public String bucketName() {
        return this.bucketName;
    }

    public String s3KeyPrefix() {
        return this.s3KeyPrefix;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.clusterIdentifier() == null ? 0 : this.clusterIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.bucketName() == null ? 0 : this.bucketName().hashCode());
        hashCode = 31 * hashCode + (this.s3KeyPrefix() == null ? 0 : this.s3KeyPrefix().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnableLoggingRequest)) {
            return false;
        }
        EnableLoggingRequest other = (EnableLoggingRequest)((Object)obj);
        if (other.clusterIdentifier() == null ^ this.clusterIdentifier() == null) {
            return false;
        }
        if (other.clusterIdentifier() != null && !other.clusterIdentifier().equals(this.clusterIdentifier())) {
            return false;
        }
        if (other.bucketName() == null ^ this.bucketName() == null) {
            return false;
        }
        if (other.bucketName() != null && !other.bucketName().equals(this.bucketName())) {
            return false;
        }
        if (other.s3KeyPrefix() == null ^ this.s3KeyPrefix() == null) {
            return false;
        }
        return other.s3KeyPrefix() == null || other.s3KeyPrefix().equals(this.s3KeyPrefix());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterIdentifier() != null) {
            sb.append("ClusterIdentifier: ").append(this.clusterIdentifier()).append(",");
        }
        if (this.bucketName() != null) {
            sb.append("BucketName: ").append(this.bucketName()).append(",");
        }
        if (this.s3KeyPrefix() != null) {
            sb.append("S3KeyPrefix: ").append(this.s3KeyPrefix()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String clusterIdentifier;
        private String bucketName;
        private String s3KeyPrefix;

        private BuilderImpl() {
        }

        private BuilderImpl(EnableLoggingRequest model) {
            this.setClusterIdentifier(model.clusterIdentifier);
            this.setBucketName(model.bucketName);
            this.setS3KeyPrefix(model.s3KeyPrefix);
        }

        public final String getClusterIdentifier() {
            return this.clusterIdentifier;
        }

        @Override
        public final Builder clusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
            return this;
        }

        public final void setClusterIdentifier(String clusterIdentifier) {
            this.clusterIdentifier = clusterIdentifier;
        }

        public final String getBucketName() {
            return this.bucketName;
        }

        @Override
        public final Builder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public final void setBucketName(String bucketName) {
            this.bucketName = bucketName;
        }

        public final String getS3KeyPrefix() {
            return this.s3KeyPrefix;
        }

        @Override
        public final Builder s3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
            return this;
        }

        public final void setS3KeyPrefix(String s3KeyPrefix) {
            this.s3KeyPrefix = s3KeyPrefix;
        }

        public EnableLoggingRequest build() {
            return new EnableLoggingRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, EnableLoggingRequest> {
        public Builder clusterIdentifier(String var1);

        public Builder bucketName(String var1);

        public Builder s3KeyPrefix(String var1);
    }
}

