/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.waiters;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import software.amazon.awssdk.AmazonServiceException;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.jmespath.JmesPathEvaluationVisitor;
import software.amazon.awssdk.jmespath.JmesPathExpression;
import software.amazon.awssdk.jmespath.JmesPathField;
import software.amazon.awssdk.jmespath.JmesPathFlatten;
import software.amazon.awssdk.jmespath.JmesPathProjection;
import software.amazon.awssdk.jmespath.JmesPathVisitor;
import software.amazon.awssdk.jmespath.ObjectMapperSingleton;
import software.amazon.awssdk.services.redshift.model.DescribeClustersResponse;
import software.amazon.awssdk.waiters.AcceptorPathMatcher;
import software.amazon.awssdk.waiters.WaiterAcceptor;
import software.amazon.awssdk.waiters.WaiterState;

@SdkInternalApi
class ClusterDeleted {
    ClusterDeleted() {
    }

    static class IsModifyingMatcher
    extends WaiterAcceptor<DescribeClustersResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final JmesPathExpression AST;

        IsModifyingMatcher() {
        }

        public boolean matches(DescribeClustersResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"modifying\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Clusters")), (JmesPathExpression)new JmesPathField("ClusterStatus"));
        }
    }

    static class IsCreatingMatcher
    extends WaiterAcceptor<DescribeClustersResponse> {
        private static final JsonNode EXPECTED_RESULT;
        private static final JmesPathExpression AST;

        IsCreatingMatcher() {
        }

        public boolean matches(DescribeClustersResponse result) {
            JsonNode queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree((Object)result);
            JsonNode finalResult = (JsonNode)AST.accept((JmesPathVisitor)new JmesPathEvaluationVisitor(), (Object)queryNode);
            return AcceptorPathMatcher.pathAny((JsonNode)EXPECTED_RESULT, (JsonNode)finalResult);
        }

        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                EXPECTED_RESULT = ObjectMapperSingleton.getObjectMapper().readTree("\"creating\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            AST = new JmesPathProjection((JmesPathExpression)new JmesPathFlatten((JmesPathExpression)new JmesPathField("Clusters")), (JmesPathExpression)new JmesPathField("ClusterStatus"));
        }
    }

    static class IsClusterNotFoundMatcher
    extends WaiterAcceptor<DescribeClustersResponse> {
        IsClusterNotFoundMatcher() {
        }

        public boolean matches(AmazonServiceException e) {
            return "ClusterNotFound".equals(e.getErrorCode());
        }

        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }
    }
}

