/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.redshift.transform;

import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.DefaultRequest;
import software.amazon.awssdk.Request;
import software.amazon.awssdk.SdkClientException;
import software.amazon.awssdk.http.HttpMethodName;
import software.amazon.awssdk.runtime.transform.Marshaller;
import software.amazon.awssdk.services.redshift.model.RevokeSnapshotAccessRequest;
import software.amazon.awssdk.util.StringUtils;

public class RevokeSnapshotAccessRequestMarshaller
implements Marshaller<Request<RevokeSnapshotAccessRequest>, RevokeSnapshotAccessRequest> {
    public Request<RevokeSnapshotAccessRequest> marshall(RevokeSnapshotAccessRequest revokeSnapshotAccessRequest) {
        if (revokeSnapshotAccessRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)revokeSnapshotAccessRequest, "RedshiftClient");
        request.addParameter("Action", "RevokeSnapshotAccess");
        request.addParameter("Version", "2012-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (revokeSnapshotAccessRequest.snapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString((String)revokeSnapshotAccessRequest.snapshotIdentifier()));
        }
        if (revokeSnapshotAccessRequest.snapshotClusterIdentifier() != null) {
            request.addParameter("SnapshotClusterIdentifier", StringUtils.fromString((String)revokeSnapshotAccessRequest.snapshotClusterIdentifier()));
        }
        if (revokeSnapshotAccessRequest.accountWithRestoreAccess() != null) {
            request.addParameter("AccountWithRestoreAccess", StringUtils.fromString((String)revokeSnapshotAccessRequest.accountWithRestoreAccess()));
        }
        return request;
    }
}

